/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapistylevalidator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.openapitools.openapistylevalidator.ErrorAggregator;
import org.openapitools.openapistylevalidator.NamingValidator;
import org.openapitools.openapistylevalidator.ValidatorParameters;
import org.openapitools.openapistylevalidator.styleerror.StyleError;

public class OpenApiSpecStyleValidator {
    public static final String INPUT_FILE = "inputFile";
    public static final String X_STYLE_VALIDATOR_IGNORED = "x-style-validator-ignored";
    private final OpenAPI openAPI;
    private final ErrorAggregator errorAggregator;
    private ValidatorParameters parameters;
    private final NamingValidator namingValidator;

    public OpenApiSpecStyleValidator(OpenAPI openApi) {
        this.openAPI = openApi;
        this.errorAggregator = new ErrorAggregator();
        this.namingValidator = new NamingValidator();
    }

    public List<StyleError> validate(ValidatorParameters parameters) {
        this.parameters = parameters;
        this.validateStructure();
        this.validateInfo();
        this.validateOperations();
        this.validateModels();
        this.validateNaming();
        return this.errorAggregator.getErrorList();
    }

    private void validateStructure() {
        boolean hasNoComponents;
        boolean hasNoPaths = this.openAPI.getPaths() == null;
        boolean bl = hasNoComponents = this.openAPI.getComponents() == null;
        if (hasNoPaths && hasNoComponents) {
            this.errorAggregator.logMissingPathsAndComponents();
        }
    }

    private void validateInfo() {
        String description;
        Info info = this.openAPI.getInfo();
        License license = info.getLicense();
        if (this.parameters.isValidateInfoLicense()) {
            if (license != null) {
                ArrayList<Boolean> infoPresence = new ArrayList<Boolean>();
                infoPresence.add(license.getName() != null && !license.getName().isEmpty());
                infoPresence.add(license.getUrl() != null && !license.getUrl().isEmpty());
                this.errorAggregator.validateMinimumInfo(infoPresence, StyleError.StyleCheckSection.APIInfo, "license", "name|url");
            } else {
                this.errorAggregator.logMissingOrEmptyAttribute(StyleError.StyleCheckSection.APIInfo, "license");
            }
        }
        if (this.parameters.isValidateInfoDescription() && ((description = info.getDescription()) == null || description.isEmpty())) {
            this.errorAggregator.logMissingOrEmptyAttribute(StyleError.StyleCheckSection.APIInfo, "description");
        }
        if (this.parameters.isValidateInfoContact()) {
            Contact contact = info.getContact();
            if (contact != null) {
                ArrayList<Boolean> infoPresence = new ArrayList<Boolean>();
                infoPresence.add(contact.getName() != null && !contact.getName().isEmpty());
                infoPresence.add(contact.getUrl() != null && !contact.getUrl().isEmpty());
                infoPresence.add(contact.getEmail() != null && !contact.getEmail().isEmpty());
                this.errorAggregator.validateMinimumInfo(infoPresence, StyleError.StyleCheckSection.APIInfo, "contact", "name|url|email");
            } else {
                this.errorAggregator.logMissingOrEmptyAttribute(StyleError.StyleCheckSection.APIInfo, "contact");
            }
        }
    }

    private void validateOperations() {
        if (this.openAPI.getPaths() == null) {
            return;
        }
        for (String key : this.openAPI.getPaths().getPathItems().keySet()) {
            PathItem path = this.openAPI.getPaths().getPathItems().get(key);
            boolean ignoreValidation = this.isPathIgnored(path);
            if (ignoreValidation) continue;
            for (PathItem.HttpMethod method : path.getOperations().keySet()) {
                Operation op = path.getOperations().get((Object)method);
                if (this.parameters.isValidateOperationOperationId() && (op.getOperationId() == null || op.getOperationId().isEmpty())) {
                    this.errorAggregator.logMissingOrEmptyOperationAttribute(key, method, "operationId");
                }
                if (this.parameters.isValidateOperationDescription() && (op.getDescription() == null || op.getDescription().isEmpty())) {
                    this.errorAggregator.logMissingOrEmptyOperationAttribute(key, method, "description");
                }
                if (this.parameters.isValidateOperationSummary() && (op.getSummary() == null || op.getSummary().isEmpty())) {
                    this.errorAggregator.logMissingOrEmptyOperationAttribute(key, method, "summary");
                }
                if (!this.parameters.isValidateOperationTag() || op.getTags() != null && !op.getTags().isEmpty()) continue;
                this.errorAggregator.logMissingOrEmptyOperationCollection(key, method, "tags");
            }
        }
    }

    private boolean isPathIgnored(PathItem path) {
        Object ignoreValidationObj = path.getExtensions() != null ? path.getExtensions().get(X_STYLE_VALIDATOR_IGNORED) : null;
        boolean ignoreValidation = false;
        if (ignoreValidationObj != null) {
            ignoreValidation = (Boolean)ignoreValidationObj;
        }
        return ignoreValidation;
    }

    private void validateModels() {
        if (this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null) {
            this.openAPI.getComponents().getSchemas().forEach((modelName, model) -> {
                this.validateModelProperties((String)modelName, (Schema)model);
                this.validateModelRequiredProperties((String)modelName, (Schema)model);
            });
        }
    }

    private void validateModelProperties(String modelName, Schema model) {
        if (model.getProperties() != null) {
            model.getProperties().forEach((propertyName, property) -> {
                boolean isNotRefProperty;
                boolean bl = isNotRefProperty = property.getRef() == null && (property.getItems() == null || property.getItems().getRef() == null);
                if (this.parameters.isValidateModelPropertiesExample() && property.getExample() == null && (property.getItems() == null && property.getRef() == null || property.getItems() != null && property.getItems().getRef() == null) && property.getAllOf() == null && isNotRefProperty) {
                    this.errorAggregator.logMissingOrEmptyModelAttribute(modelName, (String)propertyName, "example");
                }
                if (this.parameters.isValidateModelPropertiesDescription() && property.getDescription() == null && isNotRefProperty) {
                    this.errorAggregator.logMissingOrEmptyModelAttribute(modelName, (String)propertyName, "description");
                }
            });
        }
    }

    private void validateModelRequiredProperties(String modelName, Schema model) {
        if (this.parameters.isValidateModelRequiredProperties() && model.getRequired() != null) {
            Set namesOfProperties = Optional.ofNullable(model.getProperties()).map(Map::keySet).orElse(Collections.emptySet());
            model.getRequired().forEach(nameOfRequiredProperty -> {
                if (!namesOfProperties.contains(nameOfRequiredProperty)) {
                    this.errorAggregator.logMissingModelProperty(modelName, (String)nameOfRequiredProperty);
                }
            });
        }
    }

    private void validateNaming() {
        if (this.parameters.isValidateNaming()) {
            if (this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null) {
                for (String definition : this.openAPI.getComponents().getSchemas().keySet()) {
                    Schema model = this.openAPI.getComponents().getSchemas().get(definition);
                    if (model.getProperties() == null) continue;
                    for (Map.Entry<String, Schema> entry : model.getProperties().entrySet()) {
                        String name = (String)entry.getKey();
                        boolean isValid = this.namingValidator.isNamingValid(name, this.parameters.getPropertyNamingConvention()) || this.parameters.getAllowedModelProperties().contains(name);
                        if (isValid) continue;
                        this.errorAggregator.logModelBadNaming((String)entry.getKey(), "property", this.parameters.getPropertyNamingConvention().getDesignation(), definition);
                    }
                }
            }
            if (this.openAPI.getPaths() != null && this.openAPI.getPaths().getPathItems() != null) {
                for (String key : this.openAPI.getPaths().getPathItems().keySet()) {
                    String[] pathParts;
                    PathItem path = this.openAPI.getPaths().getPathItems().get(key);
                    boolean ignoreValidation = this.isPathIgnored(path);
                    if (ignoreValidation) continue;
                    for (PathItem.HttpMethod method : path.getOperations().keySet()) {
                        Operation op = path.getOperations().get((Object)method);
                        if (op == null || op.getParameters() == null) continue;
                        for (Parameter opParam : op.getParameters()) {
                            boolean shouldValidate = opParam.getIn() == Parameter.In.HEADER && opParam.getName().startsWith("X-") ? !this.parameters.isIgnoreHeaderXNaming() : true;
                            if (!shouldValidate || opParam.getRef() != null) continue;
                            if (opParam.getIn() == Parameter.In.HEADER) {
                                this.validateParamNaming(opParam.getName(), "header", this.parameters.getHeaderNamingConvention(), key, method);
                                continue;
                            }
                            if (opParam.getIn() == Parameter.In.QUERY) {
                                this.validateParamNaming(opParam.getName(), "query parameter", this.parameters.getQueryParamNamingConvention(), key, method);
                                continue;
                            }
                            if (opParam.getIn() == Parameter.In.PATH) {
                                this.validateParamNaming(opParam.getName(), "path parameter", this.parameters.getPathParamNamingConvention(), key, method);
                                continue;
                            }
                            if (opParam.getIn() != Parameter.In.COOKIE) continue;
                            this.validateParamNaming(opParam.getName(), "cookie parameter", this.parameters.getCookieParamNamingConvention(), key, method);
                        }
                    }
                    for (String part : pathParts = key.split("/")) {
                        boolean isValid;
                        if (part.isEmpty() || part.startsWith("{") && part.endsWith("}") || (isValid = this.namingValidator.isNamingValid(part, this.parameters.getPathNamingConvention()))) continue;
                        this.errorAggregator.logOperationBadNaming(part, "path", this.parameters.getPathNamingConvention().getDesignation(), key, null);
                    }
                }
            }
        }
    }

    private void validateParamNaming(String paramName, String variableType, ValidatorParameters.NamingConvention namingConvention, String key, PathItem.HttpMethod method) {
        boolean isValid = this.namingValidator.isNamingValid(paramName, namingConvention);
        if (!isValid) {
            this.errorAggregator.logOperationBadNaming(paramName, variableType, namingConvention.getDesignation(), key, method);
        }
    }
}

