/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapistylevalidator;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ValidatorParameters {
    public static final String VALIDATE_INFO_LICENSE = "validateInfoLicense";
    public static final String VALIDATE_INFO_DESCRIPTION = "validateInfoDescription";
    public static final String VALIDATE_INFO_CONTACT = "validateInfoContact";
    public static final String VALIDATE_OPERATION_OPERATION_ID = "validateOperationOperationId";
    public static final String VALIDATE_OPERATION_DESCRIPTION = "validateOperationDescription";
    public static final String VALIDATE_OPERATION_TAG = "validateOperationTag";
    public static final String VALIDATE_OPERATION_SUMMARY = "validateOperationSummary";
    public static final String VALIDATE_MODEL_PROPERTIES_EXAMPLE = "validateModelPropertiesExample";
    public static final String VALIDATE_MODEL_PROPERTIES_DESCRIPTION = "validateModelPropertiesDescription";
    public static final String VALIDATE_MODEL_REQUIRED_PROPERTIES = "validateModelRequiredProperties";
    public static final String VALIDATE_MODEL_NO_LOCAL_DEF = "validateModelNoLocalDef";
    public static final String VALIDATE_NAMING = "validateNaming";
    public static final String IGNORE_HEADER_X_NAMING = "ignoreHeaderXNaming";
    public static final String PATH_NAMING_CONVENTION = "pathNamingConvention";
    public static final String PARAMETER_NAMING_CONVENTION = "parameterNamingConvention";
    public static final String HEADER_NAMING_CONVENTION = "headerNamingConvention";
    public static final String PROPERTY_NAMING_CONVENTION = "propertyNamingConvention";
    public static final String QUERY_PARAM_NAMING_CONVENTION = "queryParamNamingConvention";
    public static final String PATH_PARAM_NAMING_CONVENTION = "pathParamNamingConvention";
    public static final String COOKIE_PARAM_NAMING_CONVENTION = "cookieParamNamingConvention";
    private boolean validateInfoLicense = true;
    private boolean validateInfoDescription = true;
    private boolean validateInfoContact = true;
    private boolean validateOperationOperationId = true;
    private boolean validateOperationDescription = true;
    private boolean validateOperationTag = true;
    private boolean validateOperationSummary = true;
    private boolean validateModelPropertiesExample = true;
    private boolean validateModelPropertiesDescription = true;
    private boolean validateModelRequiredProperties = true;
    private boolean validateModelNoLocalDef = true;
    private boolean validateNaming = true;
    private boolean ignoreHeaderXNaming = true;
    private NamingConvention pathNamingConvention = NamingConvention.HyphenCase;
    private NamingConvention parameterNamingConvention = NamingConvention.CamelCase;
    private NamingConvention headerNamingConvention = NamingConvention.UnderscoreUpperCase;
    private NamingConvention propertyNamingConvention = NamingConvention.CamelCase;
    private NamingConvention queryParamNamingConvention = NamingConvention.CamelCase;
    private NamingConvention pathParamNamingConvention = NamingConvention.CamelCase;
    private NamingConvention cookieParamNamingConvention = NamingConvention.CamelCase;
    private boolean queryParamNamingConventionWasExplicitlySet = false;
    private boolean pathParamNamingConventionWasExplicitlySet = false;
    private boolean cookieParamNamingConventionWasExplicitlySet = false;
    private Set<String> allowedModelProperties = new HashSet<String>();

    public boolean isValidateInfoLicense() {
        return this.validateInfoLicense;
    }

    public boolean isValidateInfoDescription() {
        return this.validateInfoDescription;
    }

    public boolean isValidateInfoContact() {
        return this.validateInfoContact;
    }

    public boolean isValidateOperationOperationId() {
        return this.validateOperationOperationId;
    }

    public boolean isValidateOperationDescription() {
        return this.validateOperationDescription;
    }

    public boolean isValidateOperationTag() {
        return this.validateOperationTag;
    }

    public boolean isValidateOperationSummary() {
        return this.validateOperationSummary;
    }

    public boolean isValidateModelPropertiesExample() {
        return this.validateModelPropertiesExample;
    }

    public boolean isValidateModelPropertiesDescription() {
        return this.validateModelPropertiesDescription;
    }

    public boolean isValidateModelRequiredProperties() {
        return this.validateModelRequiredProperties;
    }

    public boolean isValidateModelNoLocalDef() {
        return this.validateModelNoLocalDef;
    }

    public NamingConvention getPathNamingConvention() {
        return this.pathNamingConvention;
    }

    public NamingConvention getParameterNamingConvention() {
        return this.parameterNamingConvention;
    }

    public NamingConvention getHeaderNamingConvention() {
        return this.headerNamingConvention;
    }

    public NamingConvention getPropertyNamingConvention() {
        return this.propertyNamingConvention;
    }

    public NamingConvention getQueryParamNamingConvention() {
        return this.queryParamNamingConvention;
    }

    public NamingConvention getPathParamNamingConvention() {
        return this.pathParamNamingConvention;
    }

    public NamingConvention getCookieParamNamingConvention() {
        return this.cookieParamNamingConvention;
    }

    public ValidatorParameters setValidateInfoLicense(boolean validateInfoLicense) {
        this.validateInfoLicense = validateInfoLicense;
        return this;
    }

    public ValidatorParameters setValidateInfoDescription(boolean validateInfoDescription) {
        this.validateInfoDescription = validateInfoDescription;
        return this;
    }

    public ValidatorParameters setValidateInfoContact(boolean validateInfoContact) {
        this.validateInfoContact = validateInfoContact;
        return this;
    }

    public ValidatorParameters setValidateOperationOperationId(boolean validateOperationOperationId) {
        this.validateOperationOperationId = validateOperationOperationId;
        return this;
    }

    public ValidatorParameters setValidateOperationDescription(boolean validateOperationDescription) {
        this.validateOperationDescription = validateOperationDescription;
        return this;
    }

    public ValidatorParameters setValidateOperationTag(boolean validateOperationTag) {
        this.validateOperationTag = validateOperationTag;
        return this;
    }

    public ValidatorParameters setValidateOperationSummary(boolean validateOperationSummary) {
        this.validateOperationSummary = validateOperationSummary;
        return this;
    }

    public ValidatorParameters setValidateModelPropertiesExample(boolean validateModelPropertiesExample) {
        this.validateModelPropertiesExample = validateModelPropertiesExample;
        return this;
    }

    public ValidatorParameters setValidateModelPropertiesDescription(boolean validateModelPropertiesDescription) {
        this.validateModelPropertiesDescription = validateModelPropertiesDescription;
        return this;
    }

    public ValidatorParameters setValidateModelRequiredProperties(boolean validateModelRequiredProperties) {
        this.validateModelRequiredProperties = validateModelRequiredProperties;
        return this;
    }

    public ValidatorParameters setValidateModelNoLocalDef(boolean validateModelNoLocalDef) {
        this.validateModelNoLocalDef = validateModelNoLocalDef;
        return this;
    }

    public ValidatorParameters setPathNamingConvention(NamingConvention pathNamingConvention) {
        this.pathNamingConvention = pathNamingConvention;
        return this;
    }

    public ValidatorParameters setParameterNamingConvention(NamingConvention parameterNamingConvention) {
        this.parameterNamingConvention = parameterNamingConvention;
        if (!this.cookieParamNamingConventionWasExplicitlySet) {
            this.cookieParamNamingConvention = parameterNamingConvention;
        }
        if (!this.pathParamNamingConventionWasExplicitlySet) {
            this.pathParamNamingConvention = parameterNamingConvention;
        }
        if (!this.queryParamNamingConventionWasExplicitlySet) {
            this.queryParamNamingConvention = parameterNamingConvention;
        }
        return this;
    }

    public ValidatorParameters setHeaderNamingConvention(NamingConvention headerNamingConvention) {
        this.headerNamingConvention = headerNamingConvention;
        return this;
    }

    public ValidatorParameters setPropertyNamingConvention(NamingConvention propertyNamingConvention) {
        this.propertyNamingConvention = propertyNamingConvention;
        return this;
    }

    public ValidatorParameters setQueryParamNamingConvention(NamingConvention queryParamNamingConvention) {
        this.queryParamNamingConvention = queryParamNamingConvention;
        this.queryParamNamingConventionWasExplicitlySet = true;
        return this;
    }

    public ValidatorParameters setPathParamNamingConvention(NamingConvention pathParamNamingConvention) {
        this.pathParamNamingConvention = pathParamNamingConvention;
        this.pathParamNamingConventionWasExplicitlySet = true;
        return this;
    }

    public ValidatorParameters setCookieParamNamingConvention(NamingConvention cookieParamNamingConvention) {
        this.cookieParamNamingConvention = cookieParamNamingConvention;
        this.cookieParamNamingConventionWasExplicitlySet = true;
        return this;
    }

    public boolean isValidateNaming() {
        return this.validateNaming;
    }

    public ValidatorParameters setValidateNaming(boolean validateNaming) {
        this.validateNaming = validateNaming;
        return this;
    }

    public boolean isIgnoreHeaderXNaming() {
        return this.ignoreHeaderXNaming;
    }

    public ValidatorParameters setIgnoreHeaderXNaming(boolean ignoreHeaderXNaming) {
        this.ignoreHeaderXNaming = ignoreHeaderXNaming;
        return this;
    }

    public ValidatorParameters setAllowedModelProperties(List<String> allowedModelProperties) {
        this.allowedModelProperties = new HashSet<String>(allowedModelProperties);
        return this;
    }

    public Set<String> getAllowedModelProperties() {
        return Collections.unmodifiableSet(this.allowedModelProperties);
    }

    public String toString() {
        return String.format("ValidatorParameters [validateInfoLicense=%s, validateInfoDescription=%s, validateInfoContact=%s, validateOperationOperationId=%s, validateOperationDescription=%s, validateOperationTag=%s, validateOperationSummary=%s, validateModelPropertiesExample=%s, validateModelPropertiesDescription=%s, validateModelRequiredProperties=%s, validateModelNoLocalDef=%s, validateNaming=%s, ignoreHeaderXNaming=%s, pathNamingConvention=%s, headerNamingConvention=%s, parameterNamingConvention=%s, propertyNamingConvention=%s, queryParamNamingConvention=%s, pathParamNamingConvention=%s, cookieParamNamingConvention=%s]", new Object[]{this.validateInfoLicense, this.validateInfoDescription, this.validateInfoContact, this.validateOperationOperationId, this.validateOperationDescription, this.validateOperationTag, this.validateOperationSummary, this.validateModelPropertiesExample, this.validateModelPropertiesDescription, this.validateModelRequiredProperties, this.validateModelNoLocalDef, this.validateNaming, this.ignoreHeaderXNaming, this.pathNamingConvention, this.headerNamingConvention, this.parameterNamingConvention, this.propertyNamingConvention, this.queryParamNamingConvention, this.pathParamNamingConvention, this.cookieParamNamingConvention});
    }

    public static enum NamingConvention {
        UnderscoreCase("underscore_case"),
        UnderscoreUpperCase("UNDERSCORE_UPPER_CASE"),
        CamelCase("camelCase"),
        PascalCase("PascalCase"),
        HyphenCase("hyphen-case"),
        AnyCase("AnyCase"),
        HyphenUpperCase("Hyphen-Upper-Case");

        private final String designation;

        private NamingConvention(String appelation) {
            this.designation = appelation;
        }

        public String getDesignation() {
            return this.designation;
        }
    }
}

