/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapistylevalidator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.openapitools.openapistylevalidator.styleerror.GenericStyleError;
import org.openapitools.openapistylevalidator.styleerror.ModelNamingStyleError;
import org.openapitools.openapistylevalidator.styleerror.ModelStyleError;
import org.openapitools.openapistylevalidator.styleerror.OperationNamingStyleError;
import org.openapitools.openapistylevalidator.styleerror.OperationStyleError;
import org.openapitools.openapistylevalidator.styleerror.StyleError;

class ErrorAggregator {
    private final List<StyleError> errorList = new ArrayList<StyleError>();

    ErrorAggregator() {
    }

    void logMissingOrEmptyAttribute(StyleError.StyleCheckSection styleCheckSection, String fieldNames) {
        this.errorList.add(new StyleError(styleCheckSection, fieldNames, "Should be present and not empty"));
    }

    void validateMinimumInfo(List<Boolean> infoPresence, StyleError.StyleCheckSection styleCheckSection, String parentObjectName, String fieldNames) {
        boolean hasMinimumInfo = false;
        for (Boolean presence : infoPresence) {
            if (!presence.booleanValue()) continue;
            hasMinimumInfo = true;
            break;
        }
        if (!hasMinimumInfo) {
            this.errorList.add(new GenericStyleError(styleCheckSection, parentObjectName, fieldNames, "At least one field should be present and not empty"));
        }
    }

    List<StyleError> getErrorList() {
        return this.errorList;
    }

    void logMissingOrEmptyOperationAttribute(String path, PathItem.HttpMethod method, String field) {
        this.errorList.add(new OperationStyleError(field, "This field should be present and not empty", path, method));
    }

    void logMissingOrEmptyOperationCollection(String path, PathItem.HttpMethod method, String field) {
        this.errorList.add(new OperationStyleError(field, "The collection should be present and there should be at least one item in it", path, method));
    }

    void logMissingOrEmptyModelAttribute(String modelName, String propertyName, String field) {
        this.errorList.add(new ModelStyleError(field, "This field should be present and not empty", modelName, propertyName));
    }

    void logOperationBadNaming(String variableName, String variableType, String neededNamingStrategy, String path, PathItem.HttpMethod httpMethod) {
        this.errorList.add(new OperationNamingStyleError(StyleError.StyleCheckSection.Naming, variableName, String.format("%s should be in %s", variableType, neededNamingStrategy), path, httpMethod));
    }

    void logModelBadNaming(String variableName, String variableType, String neededNamingStrategy, String model) {
        this.errorList.add(new ModelNamingStyleError(StyleError.StyleCheckSection.Naming, variableName, String.format("%s should be in %s", variableType, neededNamingStrategy), model));
    }
}

