/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapistylevalidator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.openapitools.openapistylevalidator.ErrorAggregator;
import org.openapitools.openapistylevalidator.NamingValidator;
import org.openapitools.openapistylevalidator.ValidatorParameters;
import org.openapitools.openapistylevalidator.styleerror.StyleError;

public class OpenApiSpecStyleValidator {
    public static final String INPUT_FILE = "inputFile";
    private final OpenAPI openAPI;
    private final ErrorAggregator errorAggregator;
    private ValidatorParameters parameters;
    private final NamingValidator namingValidator;

    public OpenApiSpecStyleValidator(OpenAPI openApi) {
        this.openAPI = openApi;
        this.errorAggregator = new ErrorAggregator();
        this.namingValidator = new NamingValidator();
    }

    public List<StyleError> validate(ValidatorParameters parameters) {
        this.parameters = parameters;
        this.validateInfo();
        this.validateOperations();
        this.validateModels();
        this.validateNaming();
        return this.errorAggregator.getErrorList();
    }

    private void validateInfo() {
        String description;
        Info info = this.openAPI.getInfo();
        License license = info.getLicense();
        if (this.parameters.isValidateInfoLicense()) {
            if (license != null) {
                ArrayList<Boolean> infoPresence = new ArrayList<Boolean>();
                infoPresence.add(license.getName() != null && !license.getName().isEmpty());
                infoPresence.add(license.getUrl() != null && !license.getUrl().isEmpty());
                this.errorAggregator.validateMinimumInfo(infoPresence, StyleError.StyleCheckSection.APIInfo, "license", "name|url");
            } else {
                this.errorAggregator.logMissingOrEmptyAttribute(StyleError.StyleCheckSection.APIInfo, "license");
            }
        }
        if (this.parameters.isValidateInfoDescription() && ((description = info.getDescription()) == null || description.isEmpty())) {
            this.errorAggregator.logMissingOrEmptyAttribute(StyleError.StyleCheckSection.APIInfo, "description");
        }
        if (this.parameters.isValidateInfoContact()) {
            Contact contact = info.getContact();
            if (contact != null) {
                ArrayList<Boolean> infoPresence = new ArrayList<Boolean>();
                infoPresence.add(contact.getName() != null && !contact.getName().isEmpty());
                infoPresence.add(contact.getUrl() != null && !contact.getUrl().isEmpty());
                infoPresence.add(contact.getEmail() != null && !contact.getEmail().isEmpty());
                this.errorAggregator.validateMinimumInfo(infoPresence, StyleError.StyleCheckSection.APIInfo, "contact", "name|url|email");
            } else {
                this.errorAggregator.logMissingOrEmptyAttribute(StyleError.StyleCheckSection.APIInfo, "contact");
            }
        }
    }

    private void validateOperations() {
        for (String key : this.openAPI.getPaths().getPathItems().keySet()) {
            PathItem path = (PathItem)this.openAPI.getPaths().getPathItems().get(key);
            for (PathItem.HttpMethod method : path.getOperations().keySet()) {
                Operation op = (Operation)path.getOperations().get(method);
                if (this.parameters.isValidateOperationOperationId() && (op.getOperationId() == null || op.getOperationId().isEmpty())) {
                    this.errorAggregator.logMissingOrEmptyOperationAttribute(key, method, "operationId");
                }
                if (this.parameters.isValidateOperationDescription() && (op.getDescription() == null || op.getDescription().isEmpty())) {
                    this.errorAggregator.logMissingOrEmptyOperationAttribute(key, method, "description");
                }
                if (this.parameters.isValidateOperationSummary() && (op.getSummary() == null || op.getSummary().isEmpty())) {
                    this.errorAggregator.logMissingOrEmptyOperationAttribute(key, method, "summary");
                }
                if (!this.parameters.isValidateOperationTag() || op.getTags() != null && !op.getTags().isEmpty()) continue;
                this.errorAggregator.logMissingOrEmptyOperationCollection(key, method, "tags");
            }
        }
    }

    private void validateModels() {
        if (this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null) {
            for (String definition : this.openAPI.getComponents().getSchemas().keySet()) {
                Schema model = (Schema)this.openAPI.getComponents().getSchemas().get(definition);
                if (model.getProperties() == null) continue;
                for (Map.Entry entry : model.getProperties().entrySet()) {
                    Schema property = (Schema)entry.getValue();
                    if (!this.parameters.isValidateModelPropertiesExample() || property.getRef() != null || property.getExample() != null) continue;
                    this.errorAggregator.logMissingOrEmptyModelAttribute(definition, (String)entry.getKey(), "example");
                }
            }
        }
    }

    private void validateNaming() {
        if (this.parameters.isValidateNaming()) {
            if (this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null) {
                for (String definition : this.openAPI.getComponents().getSchemas().keySet()) {
                    Schema model = (Schema)this.openAPI.getComponents().getSchemas().get(definition);
                    if (model.getProperties() == null) continue;
                    for (Map.Entry entry : model.getProperties().entrySet()) {
                        boolean isValid = this.namingValidator.isNamingValid((String)entry.getKey(), this.parameters.getPropertyNamingConvention());
                        if (isValid) continue;
                        this.errorAggregator.logModelBadNaming((String)entry.getKey(), "property", this.parameters.getPropertyNamingConvention().getDesignation(), definition);
                    }
                }
            }
            if (this.openAPI.getPaths() != null && this.openAPI.getPaths().getPathItems() != null) {
                for (String key : this.openAPI.getPaths().getPathItems().keySet()) {
                    String[] pathParts;
                    PathItem path = (PathItem)this.openAPI.getPaths().getPathItems().get(key);
                    for (PathItem.HttpMethod method : path.getOperations().keySet()) {
                        Operation op = (Operation)path.getOperations().get(method);
                        if (op == null || op.getParameters() == null) continue;
                        for (Parameter opParam : op.getParameters()) {
                            boolean isValid;
                            boolean shouldValidate = opParam.getIn() == Parameter.In.HEADER && opParam.getName().startsWith("X-") ? !this.parameters.isIgnoreHeaderXNaming() : true;
                            if (!shouldValidate || opParam.getRef() != null || (isValid = this.namingValidator.isNamingValid(opParam.getName(), this.parameters.getParameterNamingConvention()))) continue;
                            this.errorAggregator.logOperationBadNaming(opParam.getName(), "parameter", this.parameters.getParameterNamingConvention().getDesignation(), key, method);
                        }
                    }
                    for (String part : pathParts = key.split("/")) {
                        boolean isValid;
                        if (part.isEmpty() || part.startsWith("{") && part.endsWith("}") || (isValid = this.namingValidator.isNamingValid(part, this.parameters.getPathNamingConvention()))) continue;
                        this.errorAggregator.logOperationBadNaming(part, "path", this.parameters.getPathNamingConvention().getDesignation(), key, null);
                    }
                }
            }
        }
    }
}

