/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapistylevalidator;

public class ValidatorParameters {
    public static final String VALIDATE_INFO_LICENSE = "validateInfoLicense";
    public static final String VALIDATE_INFO_DESCRIPTION = "validateInfoDescription";
    public static final String VALIDATE_INFO_CONTACT = "validateInfoContact";
    public static final String VALIDATE_OPERATION_OPERATION_ID = "validateOperationOperationId";
    public static final String VALIDATE_OPERATION_DESCRIPTION = "validateOperationDescription";
    public static final String VALIDATE_OPERATION_TAG = "validateOperationTag";
    public static final String VALIDATE_OPERATION_SUMMARY = "validateOperationSummary";
    public static final String VALIDATE_MODEL_PROPERTIES_EXAMPLE = "validateModelPropertiesExample";
    public static final String VALIDATE_MODEL_NO_LOCAL_DEF = "validateModelNoLocalDef";
    public static final String VALIDATE_NAMING = "validateNaming";
    public static final String IGNORE_HEADER_X_NAMING = "ignoreHeaderXNaming";
    public static final String PATH_NAMING_CONVENTION = "pathNamingConvention";
    public static final String PARAMETER_NAMING_CONVENTION = "parameterNamingConvention";
    public static final String PROPERTY_NAMING_CONVENTION = "propertyNamingConvention";
    private boolean validateInfoLicense = true;
    private boolean validateInfoDescription = true;
    private boolean validateInfoContact = true;
    private boolean validateOperationOperationId = true;
    private boolean validateOperationDescription = true;
    private boolean validateOperationTag = true;
    private boolean validateOperationSummary = true;
    private boolean validateModelPropertiesExample = true;
    private boolean validateModelNoLocalDef = true;
    private boolean validateNaming = true;
    private boolean ignoreHeaderXNaming = true;
    private NamingConvention pathNamingConvention = NamingConvention.HyphenCase;
    private NamingConvention parameterNamingConvention = NamingConvention.CamelCase;
    private NamingConvention propertyNamingConvention = NamingConvention.CamelCase;

    public boolean isValidateInfoLicense() {
        return this.validateInfoLicense;
    }

    public boolean isValidateInfoDescription() {
        return this.validateInfoDescription;
    }

    public boolean isValidateInfoContact() {
        return this.validateInfoContact;
    }

    public boolean isValidateOperationOperationId() {
        return this.validateOperationOperationId;
    }

    public boolean isValidateOperationDescription() {
        return this.validateOperationDescription;
    }

    public boolean isValidateOperationTag() {
        return this.validateOperationTag;
    }

    public boolean isValidateOperationSummary() {
        return this.validateOperationSummary;
    }

    public boolean isValidateModelPropertiesExample() {
        return this.validateModelPropertiesExample;
    }

    public boolean isValidateModelNoLocalDef() {
        return this.validateModelNoLocalDef;
    }

    public NamingConvention getPathNamingConvention() {
        return this.pathNamingConvention;
    }

    public NamingConvention getParameterNamingConvention() {
        return this.parameterNamingConvention;
    }

    public NamingConvention getPropertyNamingConvention() {
        return this.propertyNamingConvention;
    }

    public NamingStrategy getPathNamingStrategy() {
        return NamingStrategy.valueOf(this.getPathNamingConvention());
    }

    public NamingStrategy getParameterNamingStrategy() {
        return NamingStrategy.valueOf(this.getParameterNamingConvention());
    }

    public NamingStrategy getPropertyNamingStrategy() {
        return NamingStrategy.valueOf(this.getPropertyNamingConvention());
    }

    public ValidatorParameters setValidateInfoLicense(boolean validateInfoLicense) {
        this.validateInfoLicense = validateInfoLicense;
        return this;
    }

    public ValidatorParameters setValidateInfoDescription(boolean validateInfoDescription) {
        this.validateInfoDescription = validateInfoDescription;
        return this;
    }

    public ValidatorParameters setValidateInfoContact(boolean validateInfoContact) {
        this.validateInfoContact = validateInfoContact;
        return this;
    }

    public ValidatorParameters setValidateOperationOperationId(boolean validateOperationOperationId) {
        this.validateOperationOperationId = validateOperationOperationId;
        return this;
    }

    public ValidatorParameters setValidateOperationDescription(boolean validateOperationDescription) {
        this.validateOperationDescription = validateOperationDescription;
        return this;
    }

    public ValidatorParameters setValidateOperationTag(boolean validateOperationTag) {
        this.validateOperationTag = validateOperationTag;
        return this;
    }

    public ValidatorParameters setValidateOperationSummary(boolean validateOperationSummary) {
        this.validateOperationSummary = validateOperationSummary;
        return this;
    }

    public ValidatorParameters setValidateModelPropertiesExample(boolean validateModelPropertiesExample) {
        this.validateModelPropertiesExample = validateModelPropertiesExample;
        return this;
    }

    public ValidatorParameters setValidateModelNoLocalDef(boolean validateModelNoLocalDef) {
        this.validateModelNoLocalDef = validateModelNoLocalDef;
        return this;
    }

    public ValidatorParameters setPathNamingConvention(NamingConvention pathNamingConvention) {
        this.pathNamingConvention = pathNamingConvention;
        return this;
    }

    public ValidatorParameters setParameterNamingConvention(NamingConvention parameterNamingConvention) {
        this.parameterNamingConvention = parameterNamingConvention;
        return this;
    }

    public ValidatorParameters setPropertyNamingConvention(NamingConvention propertyNamingConvention) {
        this.propertyNamingConvention = propertyNamingConvention;
        return this;
    }

    public ValidatorParameters setPathNamingStrategy(NamingStrategy pathNamingStrategy) {
        this.setPathNamingConvention(NamingStrategy.toConvention(pathNamingStrategy));
        return this;
    }

    public ValidatorParameters setParameterNamingStrategy(NamingStrategy parameterNamingStrategy) {
        this.setParameterNamingConvention(NamingStrategy.toConvention(parameterNamingStrategy));
        return this;
    }

    public ValidatorParameters setPropertyNamingStrategy(NamingStrategy propertyNamingStrategy) {
        this.setPropertyNamingConvention(NamingStrategy.toConvention(propertyNamingStrategy));
        return this;
    }

    public boolean isValidateNaming() {
        return this.validateNaming;
    }

    public ValidatorParameters setValidateNaming(boolean validateNaming) {
        this.validateNaming = validateNaming;
        return this;
    }

    public boolean isIgnoreHeaderXNaming() {
        return this.ignoreHeaderXNaming;
    }

    public ValidatorParameters setIgnoreHeaderXNaming(boolean ignoreHeaderXNaming) {
        this.ignoreHeaderXNaming = ignoreHeaderXNaming;
        return this;
    }

    public String toString() {
        return String.format("ValidatorParameters [validateInfoLicense=%s, validateInfoDescription=%s, validateInfoContact=%s, validateOperationOperationId=%s, validateOperationDescription=%s, validateOperationTag=%s, validateOperationSummary=%s, validateModelPropertiesExample=%s, validateModelNoLocalDef=%s, validateNaming=%s, ignoreHeaderXNaming=%s, pathNamingConvention=%s, parameterNamingConvention=%s, propertyNamingConvention=%s]", new Object[]{this.validateInfoLicense, this.validateInfoDescription, this.validateInfoContact, this.validateOperationOperationId, this.validateOperationDescription, this.validateOperationTag, this.validateOperationSummary, this.validateModelPropertiesExample, this.validateModelNoLocalDef, this.validateNaming, this.ignoreHeaderXNaming, this.pathNamingConvention, this.parameterNamingConvention, this.propertyNamingConvention});
    }

    @Deprecated
    public static enum NamingStrategy {
        UnderscoreCase,
        CamelCase,
        HyphenCase;


        @Deprecated
        public String getAppelation() {
            return NamingStrategy.toConvention(this).getDesignation();
        }

        public static NamingStrategy valueOf(NamingConvention pathNamingConvention) {
            if (pathNamingConvention == null) {
                return null;
            }
            return NamingStrategy.valueOf(pathNamingConvention.name());
        }

        public static NamingConvention toConvention(NamingStrategy pathNamingStrategy) {
            if (pathNamingStrategy == null) {
                return null;
            }
            return NamingConvention.valueOf(pathNamingStrategy.name());
        }
    }

    public static enum NamingConvention {
        UnderscoreCase("underscore_case"),
        CamelCase("camelCase"),
        HyphenCase("hyphen-case");

        private final String designation;

        private NamingConvention(String appelation) {
            this.designation = appelation;
        }

        public String getDesignation() {
            return this.designation;
        }
    }
}

