/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.rst.processing;

import java.util.ArrayList;
import java.util.Collection;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.processing.VariableProcessor;
import org.openbase.jul.processing.VariableProvider;

public class MetaConfigPool
implements VariableProvider {
    private final Collection<VariableProvider> variableProviderPool;

    public MetaConfigPool(Collection<VariableProvider> variableProviderPool) {
        this.variableProviderPool = new ArrayList<VariableProvider>(variableProviderPool);
    }

    public MetaConfigPool() {
        this.variableProviderPool = new ArrayList<VariableProvider>();
    }

    public void register(VariableProvider provider) {
        this.variableProviderPool.add(provider);
    }

    public String getValue(String variable) throws NotAvailableException {
        try {
            return VariableProcessor.resolveVariables((String)VariableProcessor.resolveVariable((String)variable, this.variableProviderPool), (boolean)true, this.variableProviderPool);
        }
        catch (MultiException ex) {
            throw new NotAvailableException("Variable[" + variable + "]", (Throwable)ex);
        }
    }

    public String getName() {
        String provider = "";
        for (VariableProvider variableProvider : this.variableProviderPool) {
            if (!provider.isEmpty()) {
                provider = provider + ", ";
            }
            provider = provider + variableProvider.getName();
        }
        return this.getClass().getSimpleName() + "[" + provider + "]";
    }
}

