/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.rst.processing;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import rst.configuration.EntryType;
import rst.configuration.MetaConfigType;

public class MetaConfigProcessor {
    public static String getValue(MetaConfigType.MetaConfig metaConfig, String key) throws NotAvailableException {
        for (EntryType.Entry entry : metaConfig.getEntryList()) {
            if (!entry.getKey().equals(key) || entry.getValue().isEmpty()) continue;
            return entry.getValue();
        }
        throw new NotAvailableException("value for Key[" + key + "]");
    }

    public static MetaConfigType.MetaConfig setValue(MetaConfigType.MetaConfig metaConfig, String key, String value) throws CouldNotPerformException {
        return MetaConfigProcessor.setValue(metaConfig.toBuilder(), key, value).build();
    }

    public static MetaConfigType.MetaConfig.Builder setValue(MetaConfigType.MetaConfig.Builder metaConfigBuilder, String key, String value) throws CouldNotPerformException {
        for (int i = 0; i < metaConfigBuilder.getEntryCount(); ++i) {
            if (!metaConfigBuilder.getEntry(i).getKey().equals(key)) continue;
            metaConfigBuilder.removeEntry(i);
            break;
        }
        metaConfigBuilder.addEntry(EntryType.Entry.newBuilder().setKey(key).setValue(value));
        return metaConfigBuilder;
    }
}

