/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.rst.processing;

import com.google.protobuf.MessageOrBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotSupportedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampJavaTimeTransform;
import org.slf4j.Logger;
import rst.timing.TimestampType;

public class TimestampProcessor {
    public static final String SET = "set";
    public static final String TIMESTEMP_FIELD = "Timestamp";

    public static TimestampType.Timestamp getCurrentTimestamp() {
        return TimestampJavaTimeTransform.transform(System.currentTimeMillis());
    }

    public static <M extends MessageOrBuilder> M updateTimestampWithCurrentTime(M messageOrBuilder) throws CouldNotPerformException {
        return TimestampProcessor.updateTimestamp(System.currentTimeMillis(), messageOrBuilder);
    }

    public static <M extends MessageOrBuilder> M updateTimestamp(long milliseconds, M messageOrBuilder) throws CouldNotPerformException {
        return TimestampProcessor.updateTimestamp(milliseconds, messageOrBuilder, TimeUnit.MILLISECONDS);
    }

    public static <M extends MessageOrBuilder> M updateTimestamp(long time, M messageOrBuilder, TimeUnit timeUnit) throws CouldNotPerformException {
        long milliseconds = TimeUnit.MILLISECONDS.convert(time, timeUnit);
        try {
            if (messageOrBuilder.getClass().getSimpleName().equals("Builder")) {
                messageOrBuilder.getClass().getMethod("setTimestamp", TimestampType.Timestamp.class).invoke(messageOrBuilder, TimestampJavaTimeTransform.transform(milliseconds));
                return messageOrBuilder;
            }
            Object builder = messageOrBuilder.getClass().getMethod("toBuilder", new Class[0]).invoke(messageOrBuilder, new Object[0]);
            builder.getClass().getMethod("setTimestamp", TimestampType.Timestamp.class).invoke(builder, TimestampJavaTimeTransform.transform(milliseconds));
            return (M)((MessageOrBuilder)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not update timestemp! ", (Throwable)new NotSupportedException((Object)"Field[Timestamp]", (Object)messageOrBuilder.getClass().getName(), (Throwable)ex));
        }
    }

    public static <M extends MessageOrBuilder> M updateTimestamp(long timestamp, M messageOrBuilder, TimeUnit timeUnit, Logger logger) {
        try {
            return TimestampProcessor.updateTimestamp(timestamp, messageOrBuilder, timeUnit);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
            return messageOrBuilder;
        }
    }

    public static <M extends MessageOrBuilder> M updateTimestamp(long timestamp, M messageOrBuilder, Logger logger) {
        try {
            return TimestampProcessor.updateTimestamp(timestamp, messageOrBuilder);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
            return messageOrBuilder;
        }
    }

    public static <M extends MessageOrBuilder> M updateTimestampWithCurrentTime(M messageOrBuilder, Logger logger) {
        try {
            return TimestampProcessor.updateTimestampWithCurrentTime(messageOrBuilder);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
            return messageOrBuilder;
        }
    }
}

