/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.rst.processing;

import java.util.List;
import java.util.UUID;
import org.openbase.jul.extension.rst.processing.TimestampJavaTimeTransform;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import rst.calendar.DateTimeType;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionParameterType;
import rst.domotic.action.ActionReferenceType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.state.ActionStateType;
import rst.domotic.unit.UnitTemplateType;
import rst.timing.IntervalType;

public class ActionDescriptionProcessor {
    public static final String TOKEN_SEPERATOR = "#";
    public static final String AUTHORITY_KEY = "$AUTHORITY";
    public static final String SERVICE_TYPE_KEY = "$SERVICE_TYPE";
    public static final String LABEL_KEY = "$LABEL";
    public static final String SERVICE_ATTIBUTE_KEY = "SERVICE_ATTIBUTE";
    public static final String GENERIC_ACTION_LABEL = "$LABEL[SERVICE_ATTIBUTE]";
    public static final String GENERIC_ACTION_DESCSRIPTION = "$AUTHORITY changed $SERVICE_TYPE of unit $LABEL to SERVICE_ATTIBUTE";
    public static long MIN_ALLOCATION_TIME_MILLI = 10000L;

    public static ActionDescriptionType.ActionDescription.Builder getActionDescription(ActionParameterType.ActionParameter actionParameter, ActionAuthorityType.ActionAuthority actionAuthority, ResourceAllocationType.ResourceAllocation.Initiator initiator) {
        ActionDescriptionType.ActionDescription.Builder actionDecsription = ActionDescriptionType.ActionDescription.newBuilder();
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = actionDecsription.getResourceAllocationBuilder();
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDecsription.getServiceStateDescriptionBuilder();
        actionDecsription.setId(UUID.randomUUID().toString());
        actionDecsription.setActionState(ActionStateType.ActionState.newBuilder().setValue(ActionStateType.ActionState.State.INITIALIZED).build());
        actionDecsription.setLabel(GENERIC_ACTION_LABEL);
        actionDecsription.setDescription(GENERIC_ACTION_DESCSRIPTION);
        resourceAllocation.setId(actionDecsription.getId());
        resourceAllocation.setSlot(IntervalType.Interval.getDefaultInstance());
        resourceAllocation.setState(ResourceAllocationType.ResourceAllocation.State.REQUESTED);
        actionDecsription.setActionAuthority(actionAuthority);
        resourceAllocation.setInitiator(initiator);
        actionDecsription.setExecutionTimePeriod(actionParameter.getExecutionTimePeriod());
        actionDecsription.setExecutionValidity(actionParameter.getExecutionValidity());
        if (actionDecsription.getExecutionTimePeriod() != 0L && actionParameter.getPolicy() != ResourceAllocationType.ResourceAllocation.Policy.PRESERVE) {
            resourceAllocation.setPolicy(ResourceAllocationType.ResourceAllocation.Policy.PRESERVE);
        } else {
            resourceAllocation.setPolicy(actionParameter.getPolicy());
        }
        resourceAllocation.setPriority(actionParameter.getPriority());
        serviceStateDescription.setUnitType(actionParameter.getUnitType());
        if (actionParameter.hasInitiator()) {
            List actionReferenceList = actionParameter.getInitiator().getActionChainList();
            ActionReferenceType.ActionReference.Builder actionReference = ActionReferenceType.ActionReference.newBuilder();
            actionReference.setActionId(actionParameter.getInitiator().getId());
            actionReference.setAuthority(actionParameter.getInitiator().getActionAuthority());
            actionReference.setServiceStateDescription(actionParameter.getInitiator().getServiceStateDescription());
            actionReferenceList.add(actionReference.build());
            actionDecsription.addAllActionChain((Iterable)actionReferenceList);
        }
        return actionDecsription;
    }

    public static ActionDescriptionType.ActionDescription.Builder getActionDescription(ActionAuthorityType.ActionAuthority actionAuthority, ResourceAllocationType.ResourceAllocation.Initiator initiator) {
        return ActionDescriptionProcessor.getActionDescription(ActionDescriptionProcessor.getDefaultActionParameter(), actionAuthority, initiator);
    }

    public static ActionParameterType.ActionParameter getDefaultActionParameter() {
        ActionParameterType.ActionParameter.Builder actionParameter = ActionParameterType.ActionParameter.newBuilder();
        actionParameter.setPriority(ResourceAllocationType.ResourceAllocation.Priority.NORMAL);
        actionParameter.setExecutionTimePeriod(0L);
        long anHourFromNow = System.currentTimeMillis() + 3600000L;
        DateTimeType.DateTime dateTime = DateTimeType.DateTime.newBuilder().setDateTimeType(DateTimeType.DateTime.Type.FLOATING).setMillisecondsSinceEpoch(anHourFromNow).build();
        actionParameter.setExecutionValidity(dateTime);
        actionParameter.setPolicy(ResourceAllocationType.ResourceAllocation.Policy.FIRST);
        actionParameter.setUnitType(UnitTemplateType.UnitTemplate.UnitType.UNKNOWN);
        return actionParameter.build();
    }

    public static IntervalType.Interval getAllocationInterval(ActionDescriptionType.ActionDescription.Builder actionDescription) {
        IntervalType.Interval.Builder interval = IntervalType.Interval.newBuilder();
        actionDescription.setExecutionTimePeriod(Math.min(actionDescription.getExecutionTimePeriod(), actionDescription.getExecutionValidity().getMillisecondsSinceEpoch() - System.currentTimeMillis()));
        interval.setBegin(TimestampProcessor.getCurrentTimestamp());
        interval.setEnd(TimestampJavaTimeTransform.transform(System.currentTimeMillis() + Math.max(MIN_ALLOCATION_TIME_MILLI, actionDescription.getExecutionTimePeriod())));
        return interval.build();
    }

    public static ActionDescriptionType.ActionDescription.Builder updateResourceAllocationSlot(ActionDescriptionType.ActionDescription.Builder actionDescription) {
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocationBuilder = actionDescription.getResourceAllocationBuilder();
        resourceAllocationBuilder.setSlot(ActionDescriptionProcessor.getAllocationInterval(actionDescription));
        return actionDescription;
    }

    public static ActionReferenceType.ActionReference getActionReferenceFromActionDescription(ActionDescriptionType.ActionDescriptionOrBuilder actionDescription) {
        ActionReferenceType.ActionReference.Builder actionReference = ActionReferenceType.ActionReference.newBuilder();
        actionReference.setActionId(actionDescription.getId());
        actionReference.setAuthority(actionDescription.getActionAuthority());
        actionReference.setServiceStateDescription(actionDescription.getServiceStateDescription());
        return actionReference.build();
    }

    public static ActionDescriptionType.ActionDescription.Builder updateActionChain(ActionDescriptionType.ActionDescription.Builder actionDescription, ActionDescriptionType.ActionDescriptionOrBuilder parentAction) {
        actionDescription.addActionChain(ActionDescriptionProcessor.getActionReferenceFromActionDescription(parentAction));
        actionDescription.addAllActionChain((Iterable)parentAction.getActionChainList());
        return actionDescription;
    }

    public static boolean hasResourceAllocationToken(ActionDescriptionType.ActionDescriptionOrBuilder actionDescription) {
        return actionDescription.getResourceAllocation().getId().contains(TOKEN_SEPERATOR);
    }

    public static ActionDescriptionType.ActionDescription.Builder generateToken(ActionDescriptionType.ActionDescription.Builder actionDescription) {
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = actionDescription.getResourceAllocationBuilder();
        if (ActionDescriptionProcessor.hasResourceAllocationToken((ActionDescriptionType.ActionDescriptionOrBuilder)actionDescription)) {
            return actionDescription;
        }
        String token = UUID.randomUUID().toString();
        resourceAllocation.setId(resourceAllocation.getId() + TOKEN_SEPERATOR + token);
        return actionDescription;
    }

    public static ActionDescriptionType.ActionDescription.Builder updateResourceAllocationId(ActionDescriptionType.ActionDescription.Builder actionDescription) {
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = actionDescription.getResourceAllocationBuilder();
        String newId = UUID.randomUUID().toString();
        if (!ActionDescriptionProcessor.hasResourceAllocationToken((ActionDescriptionType.ActionDescriptionOrBuilder)actionDescription)) {
            resourceAllocation.setId(newId);
        } else {
            String token = resourceAllocation.getId().split(TOKEN_SEPERATOR)[1];
            resourceAllocation.setId(newId + TOKEN_SEPERATOR + token);
        }
        return actionDescription;
    }
}

