/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.extension.rst.transform;

import org.openbase.jul.exception.CouldNotTransformException;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class HSBColorToRGBColorTransformer {
    public static HSBColorType.HSBColor transform(RGBColorType.RGBColor rgbColor) throws CouldNotTransformException {
        try {
            double hue;
            int cmin;
            int cmax;
            int r = rgbColor.getRed();
            int g = rgbColor.getGreen();
            int b = rgbColor.getBlue();
            int n = cmax = r > g ? r : g;
            if (b > cmax) {
                cmax = b;
            }
            int n2 = cmin = r < g ? r : g;
            if (b < cmin) {
                cmin = b;
            }
            double brightness = (double)cmax / 255.0;
            double saturation = cmax != 0 ? (double)(cmax - cmin) / (double)cmax : 0.0;
            if (saturation == 0.0) {
                hue = 0.0;
            } else {
                double redc = (double)(cmax - r) / (double)(cmax - cmin);
                double greenc = (double)(cmax - g) / (double)(cmax - cmin);
                double bluec = (double)(cmax - b) / (double)(cmax - cmin);
                hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0 + redc - bluec : 4.0 + greenc - redc);
                if ((hue /= 6.0) < 0.0) {
                    hue += 1.0;
                }
            }
            return HSBColorType.HSBColor.newBuilder().setHue(hue *= 360.0).setSaturation(saturation *= 100.0).setBrightness(brightness *= 100.0).build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + RGBColorType.RGBColor.class.getName() + " to " + HSBColorType.HSBColor.class.getName() + "!", (Throwable)ex);
        }
    }

    public static RGBColorType.RGBColor transform(HSBColorType.HSBColor hsbColor) throws CouldNotTransformException {
        try {
            int r = 0;
            int g = 0;
            int b = 0;
            double hue = hsbColor.getHue() / 360.0;
            double saturation = hsbColor.getSaturation() / 100.0;
            double brightness = hsbColor.getBrightness() / 100.0;
            if (saturation == 0.0) {
                g = b = (int)(brightness * 255.0 + 0.5);
                r = b;
            } else {
                double h = (hue - Math.floor(hue)) * 6.0;
                double f = h - Math.floor(h);
                double p = brightness * (1.0 - saturation);
                double q = brightness * (1.0 - saturation * f);
                double t = brightness * (1.0 - saturation * (1.0 - f));
                switch ((int)h) {
                    case 0: {
                        r = (int)(brightness * 255.0 + 0.5);
                        g = (int)(t * 255.0 + 0.5);
                        b = (int)(p * 255.0 + 0.5);
                        break;
                    }
                    case 1: {
                        r = (int)(q * 255.0 + 0.5);
                        g = (int)(brightness * 255.0 + 0.5);
                        b = (int)(p * 255.0 + 0.5);
                        break;
                    }
                    case 2: {
                        r = (int)(p * 255.0 + 0.5);
                        g = (int)(brightness * 255.0 + 0.5);
                        b = (int)(t * 255.0 + 0.5);
                        break;
                    }
                    case 3: {
                        r = (int)(p * 255.0 + 0.5);
                        g = (int)(q * 255.0 + 0.5);
                        b = (int)(brightness * 255.0 + 0.5);
                        break;
                    }
                    case 4: {
                        r = (int)(t * 255.0 + 0.5);
                        g = (int)(p * 255.0 + 0.5);
                        b = (int)(brightness * 255.0 + 0.5);
                        break;
                    }
                    case 5: {
                        r = (int)(brightness * 255.0 + 0.5);
                        g = (int)(p * 255.0 + 0.5);
                        b = (int)(q * 255.0 + 0.5);
                    }
                }
            }
            return RGBColorType.RGBColor.newBuilder().setRed(r).setGreen(g).setBlue(b).build();
        }
        catch (Exception ex) {
            throw new CouldNotTransformException("Could not transform " + HSBColorType.HSBColor.class.getName() + " to " + RGBColorType.RGBColor.class.getName() + "!", (Throwable)ex);
        }
    }
}

