/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern.launch;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.protobuf.AbstractMessage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.communication.controller.AbstractIdentifiableController;
import org.openbase.jul.communication.iface.RPCServer;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.ExceptionProcessor;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.type.processing.ScopeProcessor;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.iface.provider.NameProvider;
import org.openbase.jul.pattern.Launcher;
import org.openbase.jul.pattern.launch.jp.JPLogDirectory;
import org.openbase.jul.pattern.launch.jp.JPLoggerConfigFile;
import org.openbase.jul.pattern.launch.jp.JPLoggerDebugConfigFile;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.type.domotic.state.ActivationStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLauncher<L extends Launchable>
extends AbstractIdentifiableController<ActivationStateType.ActivationState, ActivationStateType.ActivationState.Builder>
implements Launcher,
VoidInitializable,
NameProvider {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final long LAUNCHER_TIMEOUT = 60000L;
    public static final String SCOPE_PREFIX_LAUNCHER = "/launcher";
    private final Class<L> launchableClass;
    private final Class<?> applicationClass;
    private L launchable;
    private long launchTime = -1L;
    private LauncherState state;
    private boolean verified;
    private VerificationFailedException verificationFailedException;
    private Future<Void> launcherTask;
    private final SyncObject LAUNCHER_LOCK = new SyncObject((Object)this);
    private static MultiException.ExceptionStack errorExceptionStack = null;
    private static MultiException.ExceptionStack verificationExceptionStack = null;
    private static final List<Future> waitingTaskList = new ArrayList<Future>();
    private static final SyncObject VERIFICATION_STACK_LOCK = new SyncObject("VerificationStackLock");
    private static final SyncObject ERROR_STACK_LOCK = new SyncObject("ErrorStackLock");
    private static final SyncObject WAITING_TASK_LIST_LOCK = new SyncObject("WaitingStopLock");

    public AbstractLauncher(Class<?> applicationClass, Class<L> launchableClass) throws InstantiationException {
        super((AbstractMessage.Builder)ActivationStateType.ActivationState.newBuilder());
        this.launchableClass = launchableClass;
        this.applicationClass = applicationClass;
    }

    public void init() throws InitializationException, InterruptedException {
        super.init("/launcher/" + ScopeProcessor.convertIntoValidScopeComponent((String)this.getName()));
    }

    public boolean isCoreLauncher() {
        return false;
    }

    public L getLaunchable() {
        return this.launchable;
    }

    public String getName() {
        return AbstractLauncher.generateName();
    }

    protected L instantiateLaunchable() throws CouldNotPerformException {
        try {
            return (L)((Launchable)this.launchableClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | java.lang.InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not load launchable class!", (Throwable)ex);
        }
    }

    protected abstract void loadProperties();

    protected void verify() throws VerificationFailedException, InterruptedException {
    }

    private void setState(LauncherState state) {
        this.state = state;
    }

    public Future<Void> launch() {
        if (this.launcherTask != null && !this.launcherTask.isDone()) {
            return FutureProcessor.canceledFuture(Void.class, (Exception)new InvalidStateException("Could not launch " + this.getName() + "! Application still running!"));
        }
        this.launcherTask = GlobalCachedExecutorService.submit(() -> {
            SyncObject syncObject = this.LAUNCHER_LOCK;
            synchronized (syncObject) {
                block8: {
                    this.setState(LauncherState.INITIALIZING);
                    this.launchable = this.instantiateLaunchable();
                    try {
                        this.launchable.init();
                        this.setState(LauncherState.LAUNCHING);
                        this.launchable.activate();
                        this.launchTime = System.currentTimeMillis();
                        this.setState(LauncherState.RUNNING);
                        try {
                            this.verify();
                            this.verified = true;
                        }
                        catch (VerificationFailedException ex) {
                            this.verified = false;
                            this.verificationFailedException = ex;
                        }
                    }
                    catch (InterruptedException ex) {
                        this.setState(LauncherState.INTERRUPTED);
                        return null;
                    }
                    catch (Exception ex) {
                        this.setState(LauncherState.ERROR);
                        this.launchable.shutdown();
                        if (ExceptionProcessor.isCausedBySystemShutdown((Throwable)ex)) break block8;
                        ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not launch " + this.getName(), (Throwable)ex), (Logger)this.logger);
                    }
                }
                return null;
            }
        });
        return this.launcherTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relaunch() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.stop();
            try {
                this.launch().get();
            }
            catch (CancellationException | ExecutionException ex) {
                throw new CouldNotPerformException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.interruptBoot();
        SyncObject syncObject = this.LAUNCHER_LOCK;
        synchronized (syncObject) {
            this.setState(LauncherState.STOPPING);
            if (this.launchable != null) {
                this.launchable.shutdown();
            }
            this.setState(LauncherState.STOPPED);
        }
    }

    private void interruptBoot() {
        if (this.isBooting()) {
            this.launcherTask.cancel(true);
        }
    }

    private boolean isBooting() {
        return this.launcherTask != null && !this.launcherTask.isDone();
    }

    public void shutdown() {
        this.stop();
        super.shutdown();
    }

    public long getUpTime() {
        if (this.launchTime < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.launchTime;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public VerificationFailedException getVerificationFailedCause() {
        return this.verificationFailedException;
    }

    public Future<Void> getLauncherTask() {
        return this.launcherTask;
    }

    private static void loadCustomLoggerSettings() throws CouldNotPerformException {
        File loggerConfig;
        File debugLoggerConfig;
        File defaultLoggerConfig;
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            defaultLoggerConfig = (File)JPService.getValue(JPLoggerConfigFile.class, (Object)((File)JPService.getValue(JPLoggerDebugConfigFile.class)));
            debugLoggerConfig = (File)JPService.getValue(JPLoggerDebugConfigFile.class);
        }
        catch (JPNotAvailableException ex) {
            return;
        }
        if (debugLoggerConfig.exists() && JPService.debugMode()) {
            loggerConfig = debugLoggerConfig;
        } else if (defaultLoggerConfig.exists()) {
            loggerConfig = defaultLoggerConfig;
        } else if (debugLoggerConfig.exists()) {
            loggerConfig = debugLoggerConfig;
        } else {
            return;
        }
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            AbstractLauncher.loadProperties(context);
            configurator.doConfigure(loggerConfig);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        catch (JoranException ex) {
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
            throw new CouldNotPerformException("Could not load logger settings!", (Throwable)ex);
        }
    }

    private static void loadProperties(LoggerContext context) {
        context.putProperty("APPLICATION_NAME", JPService.getApplicationName());
        context.putProperty("SUBMODULE_NAME", JPService.getSubmoduleName());
        context.putProperty("MODULE_SEPARATOR", JPService.getSubmoduleName().isEmpty() ? "" : "-");
        try {
            context.putProperty("LOGGER_TARGET_DIR", ((File)JPService.getValue(JPLogDirectory.class)).getAbsolutePath());
            System.out.println("Logs can be found in: " + ((File)JPService.getValue(JPLogDirectory.class)).getAbsolutePath());
        }
        catch (JPNotAvailableException jPNotAvailableException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void main(String[] args, Class<?> application, Class<? extends AbstractLauncher> ... launchers) {
        AbstractLauncher.main(application, args, launchers);
    }

    public static void main(Class<?> application, Class<?> submodule, String[] args, Class<? extends AbstractLauncher> ... launchers) {
        JPService.setApplicationName(application);
        JPService.setSubmoduleName(submodule);
        AbstractLauncher.main(application, args, launchers);
    }

    public static void main(Class<?> application, String submoduleName, String[] args, Class<? extends AbstractLauncher> ... launchers) {
        JPService.setApplicationName(application);
        JPService.setSubmoduleName((String)submoduleName);
        AbstractLauncher.main(application, args, launchers);
    }

    /*
     * Exception decompiling
     */
    public static void main(Class<?> application, String[] args, Class<? extends AbstractLauncher> ... launchers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushToVerificationExceptionStack(Object source, Exception ex) {
        SyncObject syncObject = VERIFICATION_STACK_LOCK;
        synchronized (syncObject) {
            verificationExceptionStack = MultiException.push((Object)source, (Exception)ex, (MultiException.ExceptionStack)verificationExceptionStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushToErrorExceptionStack(Object source, Exception ex) {
        SyncObject syncObject = ERROR_STACK_LOCK;
        synchronized (syncObject) {
            errorExceptionStack = MultiException.push((Object)source, (Exception)ex, (MultiException.ExceptionStack)errorExceptionStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopWaiting() {
        SyncObject syncObject = WAITING_TASK_LIST_LOCK;
        synchronized (syncObject) {
            for (Future waitingTask : waitingTaskList) {
                if (waitingTask.isDone()) continue;
                waitingTask.cancel(true);
            }
        }
    }

    private static void interruptLauncherBoot(Map<Class<? extends AbstractLauncher>, AbstractLauncher> launcherMap) {
        AbstractLauncher.stopWaiting();
        for (Map.Entry<Class<? extends AbstractLauncher>, AbstractLauncher> launcherEntryToStop : launcherMap.entrySet()) {
            launcherEntryToStop.getValue().interruptBoot();
        }
    }

    private static void forceStopLauncher(Map<Class<? extends AbstractLauncher>, AbstractLauncher> launcherMap) {
        AbstractLauncher.interruptLauncherBoot(launcherMap);
        for (Map.Entry<Class<? extends AbstractLauncher>, AbstractLauncher> launcherEntryToStop : launcherMap.entrySet()) {
            launcherEntryToStop.getValue().stop();
        }
    }

    private static String generateName() {
        return JPService.getApplicationName() + (String)(JPService.getSubmoduleName().isEmpty() ? "" : "-" + JPService.getSubmoduleName());
    }

    private static void printSummary(Class application, Logger logger, String errorMessage) {
        try {
            MultiException.ExceptionStack exceptionStack = null;
            try {
                MultiException.checkAndThrow(() -> "Errors during startup phase!", (MultiException.ExceptionStack)errorExceptionStack);
            }
            catch (MultiException ex) {
                exceptionStack = MultiException.push((Object)application, (Exception)((Object)ex), exceptionStack);
            }
            try {
                MultiException.checkAndThrow(() -> "Verification process not passed!", (MultiException.ExceptionStack)verificationExceptionStack);
            }
            catch (MultiException ex) {
                exceptionStack = MultiException.push((Object)application, (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
            }
            if (Thread.currentThread().isInterrupted()) {
                logger.info(AbstractLauncher.generateName() + " was interrupted.");
                return;
            }
            MultiException.checkAndThrow(() -> errorMessage, (MultiException.ExceptionStack)exceptionStack);
            logger.info(AbstractLauncher.generateName() + " successfully started.");
        }
        catch (MultiException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
        }
    }

    public void registerMethods(RPCServer server) {
    }

    private static /* synthetic */ Object lambda$main$2(Map.Entry launcherEntry, Class application, Logger logger, Map launcherMap) throws Exception {
        while (!Thread.interrupted()) {
            try {
                try {
                    ((AbstractLauncher)((Object)launcherEntry.getValue())).getLauncherTask().get(60000L, TimeUnit.MILLISECONDS);
                    if (!((AbstractLauncher)((Object)launcherEntry.getValue())).isVerified()) {
                        AbstractLauncher.pushToVerificationExceptionStack(application, (Exception)new CouldNotPerformException("Could not verify " + ((Class)launcherEntry.getKey()).getSimpleName() + "!", (Throwable)((AbstractLauncher)((Object)launcherEntry.getValue())).getVerificationFailedCause()));
                    }
                    break;
                }
                catch (CancellationException cancellationException) {
                    break;
                }
                catch (ExecutionException ex) {
                    Throwable initialCause = ExceptionProcessor.getInitialCause((Throwable)ex);
                    if (initialCause instanceof InterruptedException) {
                        throw (InterruptedException)initialCause;
                    }
                    throw ex;
                }
            }
            catch (TimeoutException ex) {
                logger.warn("Launcher " + ((Class)launcherEntry.getKey()).getSimpleName() + " startup delay detected!");
            }
            catch (InterruptedException ex) {
                if (!((AbstractLauncher)((Object)launcherEntry.getValue())).isCoreLauncher()) continue;
                AbstractLauncher.forceStopLauncher(launcherMap);
                return null;
            }
            catch (Exception ex) {
                CouldNotPerformException exx = new CouldNotPerformException("Could not launch " + ((Class)launcherEntry.getKey()).getSimpleName() + "!", (Throwable)ex);
                if (((AbstractLauncher)((Object)launcherEntry.getValue())).isCoreLauncher()) {
                    AbstractLauncher.pushToErrorExceptionStack(application, (Exception)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)exx, (Logger)logger));
                    AbstractLauncher.forceStopLauncher(launcherMap);
                }
                AbstractLauncher.pushToErrorExceptionStack(application, (Exception)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)exx, (Logger)logger));
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$main$1(Thread mainThread) {
        mainThread.interrupt();
    }

    public static enum LauncherState {
        INITIALIZING,
        LAUNCHING,
        RUNNING,
        STOPPING,
        STOPPED,
        ERROR,
        INTERRUPTED;

    }
}

