/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.visual.javafx.execution;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.schedule.FutureProcessor;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;

public class JFXTaskExecutor {
    private <V> Future<V> executeTask(Callable<V> callable, TargetThread targetThread, Logger logger) throws CouldNotPerformException {
        try {
            switch (targetThread) {
                case GUI_THREAD: {
                    if (Platform.isFxApplicationThread()) {
                        return CompletableFuture.completedFuture(callable.call());
                    }
                    FutureTask<Object> future = new FutureTask<Object>(() -> {
                        try {
                            return callable.call();
                        }
                        catch (Exception ex) {
                            throw (Exception)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)logger);
                        }
                    });
                    Platform.runLater(future);
                    return future;
                }
                case NON_GUI_THREAD: {
                    if (Platform.isFxApplicationThread()) {
                        return GlobalCachedExecutorService.submit(callable);
                    }
                    return CompletableFuture.completedFuture(callable.call());
                }
            }
            throw new EnumNotSupportedException((Enum)targetThread, (Object)this);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return FutureProcessor.canceledFuture((Exception)ex);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not perform task!", (Throwable)ex);
        }
    }

    public static enum TargetThread {
        GUI_THREAD,
        NON_GUI_THREAD;

    }
}

