/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.visual.javafx.geometry;

import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.paint.Material;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;

public class Line3D
extends Group {
    private static final Point3D UP = new Point3D(0.0, 1.0, 0.0);
    private final LineType type;
    private Box box;
    private Cylinder cylinder;

    public Line3D(LineType type, double width, Material material) {
        this.type = type;
        super.setVisible(false);
        switch (type) {
            case BOX: {
                this.box = new Box(width, 0.0, width);
                this.box.setMaterial(material);
                super.getChildren().add((Object)this.box);
                break;
            }
            case CYLINDER: {
                this.cylinder = new Cylinder(width * 0.5, 0.0);
                this.cylinder.setMaterial(material);
                super.getChildren().add((Object)this.cylinder);
                break;
            }
        }
    }

    public Line3D(LineType type, double width, Material material, Point3D start, Point3D end) {
        this(type, width, material);
        this.setStartEndPoints(start, end);
    }

    public final void setStartEndPoints(Point3D start, Point3D end) {
        Point3D direction = start.subtract(end);
        Point3D position = start.midpoint(end);
        this.setLength(direction.magnitude());
        Point3D axis = UP.crossProduct(direction.normalize());
        super.setVisible(true);
        super.setTranslateX(position.getX());
        super.setTranslateY(position.getY());
        super.setTranslateZ(position.getZ());
        super.setRotationAxis(axis);
        super.setRotate(UP.angle(direction.normalize()));
    }

    public void setMaterial(Material material) {
        switch (this.type) {
            case BOX: {
                this.box.setMaterial(material);
                break;
            }
            case CYLINDER: {
                this.cylinder.setMaterial(material);
                break;
            }
        }
    }

    public void setWidth(double width) {
        switch (this.type) {
            case BOX: {
                this.box.setWidth(width);
                this.box.setDepth(width);
                break;
            }
            case CYLINDER: {
                this.cylinder.setRadius(width * 0.5);
                break;
            }
        }
    }

    private void setLength(double length) {
        switch (this.type) {
            case BOX: {
                this.box.setHeight(length);
                break;
            }
            case CYLINDER: {
                this.cylinder.setHeight(length);
                break;
            }
        }
    }

    public static enum LineType {
        BOX,
        CYLINDER;

    }
}

