/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.visual.javafx.geometry;

import javafx.geometry.Point3D;
import javafx.scene.paint.Material;
import org.openbase.jul.visual.javafx.geometry.Line3D;
import rst.geometry.Ray3DFloatType;
import rst.math.Vec3DFloatType;

public class Ray3D
extends Line3D {
    private static final double DEFAULT_LENGTH = 10.0;
    private static final double DEFAULT_WIDTH = 0.02;
    private final double rayLength;

    private Point3D VecToPoint(Vec3DFloatType.Vec3DFloat vector) {
        return new Point3D((double)vector.getX(), (double)vector.getY(), (double)vector.getZ());
    }

    public Ray3D(Material material) {
        super(Line3D.LineType.CYLINDER, 0.02, material);
        this.rayLength = 10.0;
    }

    public Ray3D(Material material, double rayLength) {
        super(Line3D.LineType.CYLINDER, 0.02, material);
        this.rayLength = rayLength;
    }

    public void update(Ray3DFloatType.Ray3DFloat ray) {
        Point3D origin = this.VecToPoint(ray.getOrigin());
        Point3D direction = this.VecToPoint(ray.getDirection());
        Point3D end = origin.add(direction.normalize().multiply(this.rayLength));
        super.setStartEndPoints(origin, end);
    }
}

