/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.visual.javafx.transform;

import javafx.scene.paint.Color;
import org.openbase.jul.exception.CouldNotTransformException;
import rst.vision.HSBColorType;

public class JFXColorToHSBColorTransformer {
    public static Color transform(HSBColorType.HSBColor hsbColor) throws CouldNotTransformException {
        try {
            return Color.hsb((double)hsbColor.getHue(), (double)(hsbColor.getSaturation() / 100.0), (double)(hsbColor.getBrightness() / 100.0));
        }
        catch (IllegalArgumentException ex) {
            throw new CouldNotTransformException((Object)hsbColor, Color.class, (Throwable)ex);
        }
    }

    public static HSBColorType.HSBColor transform(Color color) throws CouldNotTransformException {
        return HSBColorType.HSBColor.newBuilder().setHue(color.getHue()).setSaturation(color.getSaturation() * 100.0).setBrightness(color.getBrightness() * 100.0).build();
    }
}

