/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.animate.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.opencastproject.animate.api.AnimateService;
import org.opencastproject.animate.api.AnimateServiceException;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AnimateService.class, ManagedService.class}, property={"service.description=Animation Service", "service.pid=org.opencastproject.animate.impl.AnimateServiceImpl"})
public class AnimateServiceImpl
extends AbstractJobProducer
implements AnimateService,
ManagedService {
    private static final String SYNFIG_BINARY_CONFIG = "synfig.path";
    public static final String SYNFIG_BINARY_DEFAULT = "synfig";
    private String synfigBinary = "synfig";
    private static final String JOB_LOAD_CONFIG = "job.load.animate";
    private static final float JOB_LOAD_DEFAULT = 0.8f;
    private float jobLoad = 0.8f;
    private static final Logger logger = LoggerFactory.getLogger(AnimateServiceImpl.class);
    private static final String OPERATION = "animate";
    private Workspace workspace;
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private OrganizationDirectoryService organizationDirectoryService;
    private static final Type stringMapType = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type stringListType = new TypeToken<List<String>>(){}.getType();

    public AnimateServiceImpl() {
        super("org.opencastproject.animate");
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.debug("Activated animate service");
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        logger.debug("Start updating animate service");
        this.synfigBinary = (String)StringUtils.defaultIfBlank((CharSequence)((String)properties.get(SYNFIG_BINARY_CONFIG)), (CharSequence)SYNFIG_BINARY_DEFAULT);
        logger.debug("Set synfig binary path to {}", (Object)this.synfigBinary);
        this.jobLoad = LoadUtil.getConfiguredLoadValue((Dictionary)properties, (String)JOB_LOAD_CONFIG, (Float)Float.valueOf(0.8f), (ServiceRegistry)this.serviceRegistry);
        logger.debug("Set animate job load to {}", (Object)Float.valueOf(this.jobLoad));
        logger.debug("Finished updating animate service");
    }

    protected String process(Job job) throws Exception {
        logger.debug("Started processing job {}", (Object)job.getId());
        if (!OPERATION.equals(job.getOperation())) {
            throw new ServiceRegistryException(String.format("This service can't handle operations of type '%s'", job.getOperation()));
        }
        List arguments = job.getArguments();
        URI animation = new URI((String)arguments.get(0));
        Gson gson = new Gson();
        Map metadata = (Map)gson.fromJson((String)arguments.get(1), stringMapType);
        List options = (List)gson.fromJson((String)arguments.get(2), stringListType);
        File input = this.customAnimation(job, animation, metadata);
        File output = new File(this.workspace.rootDirectory(), String.format("animate/%d/%s.%s", job.getId(), FilenameUtils.getBaseName((String)animation.getPath()), "mkv"));
        FileUtils.forceMkdirParent((File)output);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.synfigBinary);
        command.add("-i");
        command.add(input.getAbsolutePath());
        command.add("-o");
        command.add(output.getAbsolutePath());
        command.addAll(options);
        logger.info("Executing animation command: {}", command);
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    logger.debug("Synfig: {}", (Object)line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new AnimateServiceException(String.format("Synfig exited abnormally with status %d (command: %s)", exitCode, command));
            }
            if (!output.isFile()) {
                throw new AnimateServiceException("Synfig produced no output");
            }
            logger.info("Animation generated successfully: {}", (Object)output);
        }
        catch (Exception e) {
            try {
                FileUtils.deleteQuietly((File)output.getParentFile());
                logger.debug("Removed output directory of failed animation process: {}", (Object)output.getParentFile());
                throw new AnimateServiceException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(process);
                FileUtils.deleteQuietly((File)input);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)process);
        FileUtils.deleteQuietly((File)input);
        URI uri = this.workspace.putInCollection("animate-" + job.getId(), output.getName(), (InputStream)new FileInputStream(output));
        FileUtils.deleteQuietly((File)new File(this.workspace.rootDirectory(), String.format("animate/%d", job.getId())));
        return uri.toString();
    }

    private File customAnimation(Job job, URI input, Map<String, String> metadata) throws IOException, NotFoundException {
        String animation;
        logger.debug("Start customizing the animation");
        File output = new File(this.workspace.rootDirectory(), String.format("animate/%d/%s.%s", job.getId(), FilenameUtils.getBaseName((String)input.getPath()), FilenameUtils.getExtension((String)input.getPath())));
        FileUtils.forceMkdirParent((File)output);
        try {
            animation = FileUtils.readFileToString((File)new File(input), (String)"UTF-8");
        }
        catch (IOException e) {
            logger.debug("Falling back to workspace to read {}", (Object)input);
            try (InputStream in = this.workspace.read(input);){
                animation = IOUtils.toString((InputStream)in, (String)"UTF-8");
            }
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String value = StringEscapeUtils.escapeXml11((String)entry.getValue());
            animation = animation.replaceAll("\\{\\{" + entry.getKey() + "\\}\\}", value);
        }
        FileUtils.write((File)output, (CharSequence)animation, (String)"utf-8");
        return output;
    }

    public Job animate(URI animation, Map<String, String> metadata, List<String> arguments) throws AnimateServiceException {
        Gson gson = new Gson();
        List<String> jobArguments = Arrays.asList(animation.toString(), gson.toJson(metadata), gson.toJson(arguments));
        try {
            logger.debug("Create animate service job");
            return this.serviceRegistry.createJob("org.opencastproject.animate", OPERATION, jobArguments, Float.valueOf(this.jobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new AnimateServiceException((Throwable)e);
        }
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry jobManager) {
        this.serviceRegistry = jobManager;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }
}

