/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.animate.impl.endpoint;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.animate.api.AnimateService;
import org.opencastproject.animate.api.AnimateServiceException;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="animate", title="Animate Service", abstractText="Create animated video clips using Synfig.", notes={"Use <a href=https://www.synfig.org/>Synfig Studio</a> to create animation files"})
@Component(immediate=true, service={AnimateServiceRestEndpoint.class}, property={"service.description=Animate Service REST Endpoint", "opencast.service.type=org.opencastproject.animate", "opencast.service.path=/animate", "opencast.service.jobproducer=true"})
public class AnimateServiceRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(AnimateServiceRestEndpoint.class);
    private AnimateService animateService;
    private ServiceRegistry serviceRegistry = null;
    private static final Type stringMapType = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type stringListType = new TypeToken<List<String>>(){}.getType();

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setAnimateService(AnimateService animateService) {
        this.animateService = animateService;
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="animate")
    @RestQuery(name="animate", description="Create animates video clip", restParameters={@RestParameter(name="animation", isRequired=true, type=RestParameter.Type.STRING, description="Location of to the animation"), @RestParameter(name="arguments", isRequired=true, type=RestParameter.Type.STRING, description="Synfig command line arguments as JSON array"), @RestParameter(name="metadata", isRequired=true, type=RestParameter.Type.STRING, description="Metadata for replacement as JSON object")}, responses={@RestResponse(description="Animation created successfully", responseCode=200), @RestResponse(description="Invalid data", responseCode=400), @RestResponse(description="Internal error", responseCode=500)}, returnDescription="Returns the path to the generated animation video")
    public Response animate(@FormParam(value="animation") String animation, @FormParam(value="arguments") String argumentsString, @FormParam(value="metadata") String metadataString) {
        Gson gson = new Gson();
        try {
            Map metadata = (Map)gson.fromJson(metadataString, stringMapType);
            List arguments = (List)gson.fromJson(argumentsString, stringListType);
            logger.debug("Start animation");
            Job job = this.animateService.animate(new URI(animation), metadata, arguments);
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (JsonSyntaxException | NullPointerException | URISyntaxException e) {
            logger.debug("Invalid data passed to REST endpoint:\nanimation: {}\nmetadata: {}\narguments: {})", new Object[]{animation, metadataString, argumentsString});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (AnimateServiceException e) {
            logger.error("Error animating file {}", (Object)animation, (Object)e);
            return Response.serverError().build();
        }
    }

    public JobProducer getService() {
        if (this.animateService instanceof JobProducer) {
            logger.debug("get animate service");
            return (JobProducer)this.animateService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

