/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.animate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.animate.api.AnimateService;
import org.opencastproject.animate.api.AnimateServiceException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Animate Workflow Operation Handler", "workflow.operation=animate"})
public class AnimateWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnimateWorkflowOperationHandler.class);
    private static final String ANIMATION_FILE_PROPERTY = "animation-file";
    private static final String COMMANDLINE_ARGUMENTS_PROPERTY = "cmd-args";
    private static final String WIDTH_PROPERTY = "width";
    private static final String HEIGHT_PROPERTY = "height";
    private static final String FPS_PROPERTY = "fps";
    private AnimateService animateService = null;
    private Workspace workspace = null;
    private MediaInspectionService mediaInspectionService;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering animate workflow operation handler");
    }

    private void addArgumentIfExists(WorkflowOperationInstance operation, List<String> arguments, String property, String option) {
        String value = StringUtils.trimToNull((String)operation.getConfiguration(property));
        if (value != null) {
            arguments.add(option);
            arguments.add(value);
        }
    }

    private Map<String, String> getMetadata(MediaPackage mediaPackage) {
        MediaPackageElementFlavor[] flavors;
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (MediaPackageElementFlavor flavor : flavors = new MediaPackageElementFlavor[]{MediaPackageElements.EPISODE, MediaPackageElements.SERIES}) {
            for (Catalog catalog : mediaPackage.getCatalogs(flavor)) {
                DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
                for (Map.Entry entry : dc.getValues().entrySet()) {
                    String key = String.format("%s.%s", flavor.getSubtype(), ((EName)entry.getKey()).getLocalName());
                    String value = ((DublinCoreValue)((List)entry.getValue()).get(0)).getValue();
                    metadata.put(key, value);
                    logger.debug("metadata: {} -> {}", (Object)key, (Object)value);
                }
            }
        }
        return metadata;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Job job;
        List<String> arguments;
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Start animate workflow operation for media package {}", (Object)mediaPackage);
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        File animationFile = new File(StringUtils.trimToEmpty((String)operation.getConfiguration(ANIMATION_FILE_PROPERTY)));
        if (!animationFile.isFile()) {
            throw new WorkflowOperationException(String.format("Animation file `%s` does not exist", animationFile));
        }
        URI animation = animationFile.toURI();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        List targetTagsProperty = tagsAndFlavors.getTargetTags();
        String cmd = operation.getConfiguration(COMMANDLINE_ARGUMENTS_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)cmd)) {
            arguments = Arrays.asList(StringUtils.split((String)cmd));
        } else {
            arguments = new ArrayList<String>();
            arguments.add("-t");
            arguments.add("ffmpeg");
            arguments.add("--video-codec");
            arguments.add("libx264-lossless");
            arguments.add("--video-bitrate");
            arguments.add("10000");
            this.addArgumentIfExists(operation, arguments, WIDTH_PROPERTY, "-w");
            this.addArgumentIfExists(operation, arguments, HEIGHT_PROPERTY, "-h");
            this.addArgumentIfExists(operation, arguments, FPS_PROPERTY, "--fps");
        }
        Map<String, String> metadata = this.getMetadata(mediaPackage);
        try {
            job = this.animateService.animate(animation, metadata, arguments);
        }
        catch (AnimateServiceException e) {
            throw new WorkflowOperationException(String.format("Rendering animation from '%s' in media package '%s' failed", animation, mediaPackage), (Throwable)e);
        }
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException(String.format("Animate job for media package '%s' failed", mediaPackage));
        }
        try {
            URI output = new URI(job.getPayload());
            String id = UUID.randomUUID().toString();
            InputStream in = this.workspace.read(output);
            URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), id, FilenameUtils.getName((String)output.getPath()), in);
            TrackImpl track = new TrackImpl();
            track.setIdentifier(id);
            track.setFlavor(targetFlavor);
            track.setURI(uri);
            Job inspection = this.mediaInspectionService.enrich((MediaPackageElement)track, true);
            if (!this.waitForStatus(new Job[]{inspection}).isSuccess()) {
                throw new AnimateServiceException(String.format("Animating %s failed", animation));
            }
            track = (TrackImpl)MediaPackageElementParser.getFromXml((String)inspection.getPayload());
            for (String tag : targetTagsProperty) {
                track.addTag(tag);
            }
            mediaPackage.add((Track)track);
            this.workspace.delete(output);
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Error handling animation service output", (Throwable)e);
        }
        try {
            this.workspace.cleanup(mediaPackage.getIdentifier());
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        logger.info("Animate workflow operation for media package {} completed", (Object)mediaPackage);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setAnimateService(AnimateService animateService) {
        this.animateService = animateService;
    }

    @Reference
    public void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.mediaInspectionService = mediaInspectionService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

