/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.storage;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.data.Opt;
import java.io.Serializable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.assetmanager.api.Version;

@ParametersAreNonnullByDefault
@Immutable
public final class DeletionSelector
implements Serializable {
    private static final long serialVersionUID = 217139112650188934L;
    private final String mediaPackageId;
    private final String organizationId;
    private final Opt<Version> version;

    public DeletionSelector(String organizationId, String mediaPackageId, Opt<Version> version) {
        this.mediaPackageId = mediaPackageId;
        this.organizationId = organizationId;
        this.version = version;
    }

    public static DeletionSelector delete(String organizationId, String mediaPackageId, Version version) {
        return new DeletionSelector(organizationId, mediaPackageId, (Opt<Version>)Opt.some((Object)version));
    }

    public static DeletionSelector deleteAll(String organizationId, String mediaPackageId) {
        return new DeletionSelector(organizationId, mediaPackageId, (Opt<Version>)Opt.none());
    }

    public String getMediaPackageId() {
        return this.mediaPackageId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Opt<Version> getVersion() {
        return this.version;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DeletionSelector && this.eqFields((DeletionSelector)that);
    }

    private boolean eqFields(DeletionSelector that) {
        return Equality.eq((Object)this.mediaPackageId, (Object)that.mediaPackageId) && Equality.eq((Object)this.organizationId, (Object)that.organizationId) && Equality.eq(this.version, that.version);
    }

    public int hashCode() {
        return Equality.hash((Object[])new Object[]{this.mediaPackageId, this.organizationId, this.version});
    }

    public String toString() {
        return String.format("DeletionSelector(org=%s,mp=%s,v=%s)", this.organizationId, this.mediaPackageId, this.version);
    }
}

