/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.storage;

import com.entwinemedia.fn.data.Opt;
import java.net.URI;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.util.MimeType;

@ParametersAreNonnullByDefault
public final class Source {
    private final URI uri;
    private final Opt<Long> size;
    private final Opt<MimeType> mimeType;

    public Source(URI uri, Opt<Long> size, Opt<MimeType> mimeType) {
        this.uri = uri;
        this.size = size;
        this.mimeType = mimeType;
    }

    public static Source mk(URI uri) {
        return new Source(uri, (Opt<Long>)Opt.none(), (Opt<MimeType>)Opt.none());
    }

    public static Source mk(URI uri, Long size) {
        return new Source(uri, (Opt<Long>)Opt.some((Object)size), (Opt<MimeType>)Opt.none());
    }

    public static Source mk(URI uri, Long size, MimeType mimeType) {
        return new Source(uri, (Opt<Long>)Opt.some((Object)size), (Opt<MimeType>)Opt.some((Object)mimeType));
    }

    public static Source mk(URI uri, Opt<Long> size, Opt<MimeType> mimeType) {
        return new Source(uri, size, mimeType);
    }

    public URI getUri() {
        return this.uri;
    }

    public Opt<Long> getSize() {
        return this.size;
    }

    public Opt<MimeType> getMimeType() {
        return this.mimeType;
    }
}

