/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api.fn;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Pred;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.StreamFold;
import com.entwinemedia.fn.StreamOp;
import com.entwinemedia.fn.data.Opt;
import java.util.Date;
import java.util.Iterator;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.PropertyName;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.fn.ARecords;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.PropertyField;
import org.opencastproject.mediapackage.MediaPackage;

public final class Properties {
    public static final Fn<Property, Value> getValue = new Fn<Property, Value>(){

        public Value apply(Property p) {
            return p.getValue();
        }
    };

    private Properties() {
    }

    public static Stream<Property> getProperties(AResult result) {
        return result.getRecords().bind(ARecords.getProperties);
    }

    public static Pred<Property> byMediaPackageId(final String id) {
        return new Pred<Property>(){

            public Boolean apply(Property p) {
                return Equality.eq((Object)p.getId().getMediaPackageId(), (Object)id);
            }
        };
    }

    public static Pred<Property> byNamespace(final String namespace) {
        return new Pred<Property>(){

            public Boolean apply(Property p) {
                return Equality.eq((Object)p.getId().getNamespace(), (Object)namespace);
            }
        };
    }

    public static Pred<Property> byPropertyName(final String propertyName) {
        return new Pred<Property>(){

            public Boolean apply(Property p) {
                return Equality.eq((Object)p.getId().getName(), (Object)propertyName);
            }
        };
    }

    public static Pred<Property> byFqnName(PropertyName name) {
        return Properties.byNamespace(name.getNamespace()).and(Properties.byPropertyName(name.getName()));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, String value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, Date value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, Long value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, boolean value) {
        return Properties.setProperty(am, mpId, namespace, propertyName, Value.mk(value));
    }

    public static boolean setProperty(AssetManager am, String mpId, String namespace, String propertyName, Value value) {
        return am.setProperty(Property.mk(PropertyId.mk(mpId, namespace, propertyName), value));
    }

    public static long removeProperties(AssetManager am, String owner, String orgId, String mpId, String namespace) {
        AQueryBuilder q = am.createQuery();
        return q.delete(owner, q.propertiesOf(namespace)).where(q.organizationId(orgId).and(q.mediaPackageId(mpId))).run();
    }

    public static Opt<Property> getProperty(AssetManager am, String mpId, String namespace, String propertyName) {
        AQueryBuilder q = am.createQuery();
        return q.select(q.properties(PropertyName.mk(namespace, propertyName))).where(q.mediaPackageId(mpId).and(q.property(Value.UNTYPED, namespace, propertyName).exists())).run().getRecords().bind(ARecords.getProperties).head();
    }

    public static <A> Fn<Property, A> getValue(final Value.ValueType<A> ev) {
        return new Fn<Property, A>(){

            public A apply(Property p) {
                return p.getValue().get(ev);
            }
        };
    }

    public static <A> StreamFold<Property, A> getValue(Value.ValueType<A> ev, String propertyName) {
        return StreamFold.find(Properties.byPropertyName(propertyName)).fmap(Properties.get(propertyName)).fmap(Properties.getValue(ev));
    }

    public static <A> StreamFold<Property, A> getValue(Value.ValueType<A> ev, PropertyName name) {
        return StreamFold.find(Properties.byFqnName(name)).fmap(Properties.get(name)).fmap(Properties.getValue(ev));
    }

    public static <A> StreamFold<Property, Opt<A>> getValueOpt(Value.ValueType<A> ev, String propertyName) {
        return StreamFold.find(Properties.byPropertyName(propertyName)).fmap(Properties.lift(Properties.getValue(ev)));
    }

    public static <A> StreamFold<Property, Opt<A>> getValueOpt(Value.ValueType<A> ev, PropertyName name) {
        return StreamFold.find(Properties.byFqnName(name)).fmap(Properties.lift(Properties.getValue(ev)));
    }

    public static Fn<Opt<Property>, Property> get(final String propertyName) {
        return new Fn<Opt<Property>, Property>(){

            public Property apply(Opt<Property> p) {
                Iterator iterator = p.iterator();
                if (iterator.hasNext()) {
                    Property pp = (Property)iterator.next();
                    return pp;
                }
                throw new RuntimeException(String.format("Property [%s] does not exist", propertyName));
            }
        };
    }

    public static Fn<Opt<Property>, Property> get(PropertyName name) {
        return Properties.get(name.toString());
    }

    public static <A> Property mkProperty(PropertyField<A> f, MediaPackage mp, A value) {
        return f.mk(mp.getIdentifier().toString(), value);
    }

    public static <A> Property mkProperty(PropertyField<A> f, Snapshot e, A value) {
        return f.mk(e.getMediaPackage().getIdentifier().toString(), value);
    }

    public static Property mkProperty(String mpId, String namespace, String name, Value value) {
        return Property.mk(PropertyId.mk(mpId, namespace, name), value);
    }

    public static StreamFold<Property, Boolean> getBoolean(String propertyName) {
        return Properties.getValue(Value.BOOLEAN, propertyName);
    }

    public static StreamFold<Property, Boolean> getBoolean(PropertyName name) {
        return Properties.getValue(Value.BOOLEAN, name);
    }

    public static StreamFold<Property, String> getString(String propertyName) {
        return Properties.getValue(Value.STRING, propertyName);
    }

    public static StreamFold<Property, String> getString(PropertyName name) {
        return Properties.getValue(Value.STRING, name);
    }

    public static StreamOp<Property, String> getStrings(final String propertyName) {
        return new StreamOp<Property, String>(){

            public Stream<String> apply(Stream<? extends Property> s) {
                return s.filter(Properties.byPropertyName(propertyName)).map(Properties.getValue(Value.STRING));
            }
        };
    }

    public static StreamOp<Property, String> getStrings(final PropertyName name) {
        return new StreamOp<Property, String>(){

            public Stream<String> apply(Stream<? extends Property> s) {
                return s.filter(Properties.byFqnName(name)).map(Properties.getValue(Value.STRING));
            }
        };
    }

    public static StreamFold<Property, Date> getDate(String propertyName) {
        return Properties.getValue(Value.DATE, propertyName);
    }

    public static StreamFold<Property, Date> getDate(PropertyName name) {
        return Properties.getValue(Value.DATE, name);
    }

    public static StreamFold<Property, Long> getLong(String propertyName) {
        return Properties.getValue(Value.LONG, propertyName);
    }

    public static StreamFold<Property, Long> getLong(PropertyName name) {
        return Properties.getValue(Value.LONG, name);
    }

    public static StreamFold<Property, Opt<String>> getStringOpt(String propertyName) {
        return Properties.getValueOpt(Value.STRING, propertyName);
    }

    public static StreamFold<Property, Opt<String>> getStringOpt(PropertyName name) {
        return Properties.getValueOpt(Value.STRING, name);
    }

    public static StreamFold<Property, Opt<Date>> getDateOpt(String propertyName) {
        return Properties.getValueOpt(Value.DATE, propertyName);
    }

    public static StreamFold<Property, Opt<Date>> getDateOpt(PropertyName name) {
        return Properties.getValueOpt(Value.DATE, name);
    }

    public static StreamFold<Property, Opt<Long>> getLongOpt(String propertyName) {
        return Properties.getValueOpt(Value.LONG, propertyName);
    }

    public static StreamFold<Property, Opt<Long>> getLongOpt(PropertyName name) {
        return Properties.getValueOpt(Value.LONG, name);
    }

    private static <A, B> Fn<Opt<A>, Opt<B>> lift(final Fn<? super A, ? extends B> f) {
        return new Fn<Opt<A>, Opt<B>>(){

            public Opt<B> apply(Opt<A> as) {
                return as.map(f);
            }
        };
    }
}

