/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api;

import com.entwinemedia.fn.Equality;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.assetmanager.api.Version;

@ParametersAreNonnullByDefault
public final class AssetId {
    private final String mpId;
    private final String mpeId;
    private final Version version;

    public AssetId(Version version, String mpId, String mpeId) {
        this.version = version;
        this.mpId = mpId;
        this.mpeId = mpeId;
    }

    public static AssetId mk(Version version, String mpId, String mpeId) {
        return new AssetId(version, mpId, mpeId);
    }

    public String getMediaPackageId() {
        return this.mpId;
    }

    public String getMediaPackageElementId() {
        return this.mpeId;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Equality.hash((Object[])new Object[]{this.version, this.mpId, this.mpeId});
    }

    public boolean equals(Object that) {
        return this == that || that instanceof AssetId && this.eqFields((AssetId)that);
    }

    private boolean eqFields(AssetId that) {
        return Equality.eq((Object)this.mpId, (Object)that.mpId) && Equality.eq((Object)this.mpeId, (Object)that.mpeId) && Equality.eq((Object)this.version, (Object)that.version);
    }

    public String toString() {
        return String.format("AssetId(mpId=%s, mpeId=%s, version=%s)", this.mpId, this.mpeId, this.version);
    }
}

