/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.api;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.P1;
import com.entwinemedia.fn.Prelude;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.assetmanager.api.Version;

@ParametersAreNonnullByDefault
public abstract class Value {
    public static final StringType STRING = new StringType();
    public static final DateType DATE = new DateType();
    public static final LongType LONG = new LongType();
    public static final BooleanType BOOLEAN = new BooleanType();
    public static final VersionType VERSION = new VersionType();
    public static final UntypedType UNTYPED = new UntypedType();

    private Value() {
    }

    public abstract Object get();

    public final <A> A get(ValueType<A> ev) {
        if (this.getType().getClass().equals(ev.getClass())) {
            return (A)this.get();
        }
        throw new RuntimeException(this + " is not a " + ev.getClass().getSimpleName());
    }

    public final ValueType<?> getType() {
        return (ValueType)this.decompose(new Fn<String, ValueType<?>>(){

            public ValueType<?> apply(String a) {
                return STRING;
            }
        }, new Fn<Date, ValueType<?>>(){

            public ValueType<?> apply(Date a) {
                return DATE;
            }
        }, new Fn<Long, ValueType<?>>(){

            public ValueType<?> apply(Long a) {
                return LONG;
            }
        }, new Fn<Boolean, ValueType<?>>(){

            public ValueType<?> apply(Boolean a) {
                return BOOLEAN;
            }
        }, new Fn<Version, ValueType<?>>(){

            public ValueType<?> apply(Version a) {
                return VERSION;
            }
        });
    }

    public final <A> A decompose(Fn<? super String, ? extends A> stringValue, Fn<? super Date, ? extends A> dateValue, Fn<? super Long, ? extends A> longValue, Fn<? super Boolean, ? extends A> booleanValue, Fn<? super Version, ? extends A> versionValue) {
        if (this instanceof StringValue) {
            return (A)stringValue.apply(((StringValue)this).get());
        }
        if (this instanceof DateValue) {
            return (A)dateValue.apply(((DateValue)this).get());
        }
        if (this instanceof LongValue) {
            return (A)longValue.apply(((LongValue)this).get());
        }
        if (this instanceof BooleanValue) {
            return (A)booleanValue.apply(((BooleanValue)this).get());
        }
        if (this instanceof VersionValue) {
            return (A)versionValue.apply(((VersionValue)this).get());
        }
        return (A)Prelude.unexhaustiveMatch((Object)this);
    }

    public static <B> Fn<Object, B> doNotMatch() {
        return new Fn<Object, B>(){

            public B apply(Object a) {
                return Prelude.unexhaustiveMatch((Object)a);
            }
        };
    }

    public static StringValue mk(String value) {
        return new StringValue(value);
    }

    public static DateValue mk(Date value) {
        return new DateValue(value);
    }

    public static LongValue mk(Long value) {
        return new LongValue(value);
    }

    public static BooleanValue mk(Boolean value) {
        return new BooleanValue(value);
    }

    public static VersionValue mk(Version value) {
        return new VersionValue(value);
    }

    public static <A> TypedValue<A> mk(ValueType<A> mk, A a) {
        return mk.mk(a);
    }

    @Immutable
    public static final class VersionValue
    extends TypedValue<Version> {
        public VersionValue(@Nonnull Version value) {
            super(value);
        }
    }

    @Immutable
    public static final class BooleanValue
    extends TypedValue<Boolean> {
        public BooleanValue(@Nonnull Boolean value) {
            super(value);
        }
    }

    @Immutable
    public static final class LongValue
    extends TypedValue<Long> {
        public LongValue(@Nonnull Long value) {
            super(value);
        }
    }

    public static final class DateValue
    extends TypedValue<Date> {
        public DateValue(@Nonnull Date value) {
            super(value);
        }
    }

    @Immutable
    public static final class StringValue
    extends TypedValue<String> {
        public StringValue(@Nonnull String value) {
            super(value);
        }
    }

    public static class TypedValue<A>
    extends Value {
        private final A value;

        private TypedValue(@Nonnull A value) {
            this.value = value;
        }

        public A get() {
            return this.value;
        }

        public int hashCode() {
            return Equality.hash((Object[])new Object[]{this.value});
        }

        public boolean equals(Object that) {
            return this == that || that instanceof TypedValue && this.eqFields((TypedValue)that);
        }

        private boolean eqFields(TypedValue that) {
            return Equality.eq(this.value, that.value);
        }

        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.value);
        }
    }

    public static final class UntypedType
    extends ValueType<Object> {
        @Override
        public TypedValue<Object> mk(Object a) {
            throw new RuntimeException("Cannot create an untyped value");
        }

        @Override
        public <B> B match(P1<? extends B> stringType, P1<? extends B> dateType, P1<? extends B> longType, P1<? extends B> booleanType, P1<? extends B> versionType) {
            throw new RuntimeException("Cannot match an untyped value type");
        }
    }

    public static final class VersionType
    extends ValueType<Version> {
        @Override
        public TypedValue<Version> mk(Version a) {
            return Value.mk(a);
        }

        @Override
        public <B> B match(P1<? extends B> stringType, P1<? extends B> dateType, P1<? extends B> longType, P1<? extends B> booleanType, P1<? extends B> versionType) {
            return (B)versionType.get1();
        }
    }

    public static final class BooleanType
    extends ValueType<Boolean> {
        @Override
        public TypedValue<Boolean> mk(Boolean a) {
            return Value.mk(a);
        }

        @Override
        public <B> B match(P1<? extends B> stringType, P1<? extends B> dateType, P1<? extends B> longType, P1<? extends B> booleanType, P1<? extends B> versionType) {
            return (B)booleanType.get1();
        }
    }

    public static final class LongType
    extends ValueType<Long> {
        @Override
        public TypedValue<Long> mk(Long a) {
            return Value.mk(a);
        }

        @Override
        public <B> B match(P1<? extends B> stringType, P1<? extends B> dateType, P1<? extends B> longType, P1<? extends B> booleanType, P1<? extends B> versionType) {
            return (B)longType.get1();
        }
    }

    public static final class DateType
    extends ValueType<Date> {
        @Override
        public TypedValue<Date> mk(Date a) {
            return Value.mk(a);
        }

        @Override
        public <B> B match(P1<? extends B> stringType, P1<? extends B> dateType, P1<? extends B> longType, P1<? extends B> booleanType, P1<? extends B> versionType) {
            return (B)dateType.get1();
        }
    }

    public static final class StringType
    extends ValueType<String> {
        @Override
        public TypedValue<String> mk(String a) {
            return Value.mk(a);
        }

        @Override
        public <B> B match(P1<? extends B> stringType, P1<? extends B> dateType, P1<? extends B> longType, P1<? extends B> booleanType, P1<? extends B> versionType) {
            return (B)stringType.get1();
        }
    }

    public static abstract class ValueType<A> {
        private ValueType() {
        }

        public abstract TypedValue<A> mk(A var1);

        public abstract <B> B match(P1<? extends B> var1, P1<? extends B> var2, P1<? extends B> var3, P1<? extends B> var4, P1<? extends B> var5);
    }
}

