/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.api.EncodingProfileBuilder;
import org.opencastproject.composer.api.EncodingProfileList;
import org.opencastproject.composer.api.LaidOutElement;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.composer.layout.Layout;
import org.opencastproject.composer.layout.Serializer;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.util.data.Option;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composer (Encoder) Remote Service Proxy"}, immediate=true, service={ComposerService.class})
public class ComposerServiceRemoteImpl
extends RemoteBase
implements ComposerService {
    private static final Logger logger = LoggerFactory.getLogger(ComposerServiceRemoteImpl.class);

    public ComposerServiceRemoteImpl() {
        super("org.opencastproject.composer");
    }

    @Reference(name="trustedHttpClient")
    public void setTrustedHttpClient(TrustedHttpClient client) {
        this.client = client;
    }

    @Reference(name="remoteServiceManager")
    public void setRemoteServiceManager(ServiceRegistry remoteServiceManager) {
        this.remoteServiceManager = remoteServiceManager;
    }

    public Job encode(Track sourceTrack, String profileId) throws EncoderException {
        HttpPost post = new HttpPost("/encode");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException("Unable to assemble a remote composer request for track " + sourceTrack, (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job r = JobParser.parseJob((String)content);
                logger.info("Encoding job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException("Unable to encode track " + sourceTrack + " using a remote composer service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to encode track " + sourceTrack + " using a remote composer service");
    }

    public Job parallelEncode(Track sourceTrack, String profileId) throws EncoderException {
        HttpPost post = new HttpPost("/parallelencode");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException("Unable to assemble a remote composer request for track " + sourceTrack, (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job r = JobParser.parseJob((String)content);
                logger.info("Encoding job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException("Unable to encode track " + sourceTrack + " using a remote composer service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to encode track " + sourceTrack + " using a remote composer service");
    }

    public Job trim(Track sourceTrack, String profileId, long start, long duration) throws EncoderException {
        HttpPost post = new HttpPost("/trim");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            params.add(new BasicNameValuePair("start", Long.toString(start)));
            params.add(new BasicNameValuePair("duration", Long.toString(duration)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException("Unable to assemble a remote composer request for track " + sourceTrack, (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job r = JobParser.parseJob((String)content);
                logger.info("Trimming job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException("Unable to trim track " + sourceTrack + " using a remote composer service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to trim track " + sourceTrack + " using a remote composer service");
    }

    public Job mux(Track sourceVideoTrack, Track sourceAudioTrack, String profileId) throws EncoderException {
        HttpPost post = new HttpPost("/mux");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("videoSourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceVideoTrack)));
            params.add(new BasicNameValuePair("audioSourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceAudioTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException("Unable to assemble a remote composer request", (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job r = JobParser.parseJob((String)content);
                logger.info("Muxing job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to mux tracks " + sourceVideoTrack + " and " + sourceAudioTrack + " using a remote composer");
    }

    public EncodingProfile getProfile(String profileId) {
        EncodingProfile encodingProfile;
        HttpResponse response;
        block5: {
            HttpGet get = new HttpGet("/profile/" + profileId + ".xml");
            response = null;
            response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404});
            if (response == null || response.getStatusLine().getStatusCode() != 200) break block5;
            EncodingProfile encodingProfile2 = EncodingProfileBuilder.getInstance().parseProfile(response.getEntity().getContent());
            this.closeConnection(response);
            return encodingProfile2;
        }
        try {
            encodingProfile = null;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
        return encodingProfile;
    }

    public Job image(Track sourceTrack, String profileId, double ... times) throws EncoderException {
        HttpPost post = new HttpPost("/image");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            params.add(new BasicNameValuePair("time", this.buildTimeArray(times)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Image extraction job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to compose an image from track " + sourceTrack + " using the remote composer service proxy");
    }

    public List<Attachment> imageSync(Track sourceTrack, String profileId, double ... times) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/imagesync");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            params.add(new BasicNameValuePair("time", this.buildTimeArray(times)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e2) {
            throw new EncoderException((Throwable)e2);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String xml = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.forName("utf-8"));
                List<Attachment> list = MediaPackageElementParser.getArrayFromXml((String)xml).stream().map(e -> (Attachment)e).collect(Collectors.toList());
                return list;
            }
        }
        catch (Exception e3) {
            throw new EncoderException((Throwable)e3);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to compose an image from track " + sourceTrack + " using the remote composer service proxy");
    }

    public Job image(Track sourceTrack, String profileId, Map<String, String> properties) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/image");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            if (properties != null) {
                params.add(new BasicNameValuePair("properties", this.mapToString(properties)));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Image extraction job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to compose an image from track " + sourceTrack + " using the remote composer service proxy");
    }

    public Job convertImage(Attachment image, String ... profileIds) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/convertimage");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceImage", MediaPackageElementParser.getAsXml((MediaPackageElement)image)));
            params.add(new BasicNameValuePair("profileId", StringUtils.join((Object[])profileIds, (char)',')));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Image conversion job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to convert image at " + image + " using the remote composer service proxy");
    }

    public List<Attachment> convertImageSync(Attachment image, String ... profileIds) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/convertimagesync");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceImage", MediaPackageElementParser.getAsXml((MediaPackageElement)image)));
            params.add(new BasicNameValuePair("profileIds", StringUtils.join((Object[])profileIds, (char)',')));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String xml = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.forName("utf-8"));
                List<Attachment> list = MediaPackageElementParser.getArrayFromXml((String)xml).stream().map(a -> (Attachment)a).collect(Collectors.toList());
                return list;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to convert image at " + image + " using the remote composer service proxy");
    }

    public EncodingProfile[] listProfiles() {
        HttpGet get = new HttpGet("/profiles.xml");
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)get);
            if (response != null) {
                EncodingProfileList profileList = EncodingProfileBuilder.getInstance().parseProfileList(response.getEntity().getContent());
                List list = profileList.getProfiles();
                EncodingProfile[] encodingProfileArray = list.toArray(new EncodingProfile[list.size()]);
                return encodingProfileArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to list the encoding profiles registered with the remote composer service proxy", e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new RuntimeException("Unable to list the encoding profiles registered with the remote composer service proxy");
    }

    protected String buildTimeArray(double[] times) {
        if (times.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Double.toString(times[0]));
        for (int i = 1; i < times.length; ++i) {
            builder.append(";" + Double.toString(times[i]));
        }
        return builder.toString();
    }

    public Job composite(Dimension compositeTrackSize, Option<LaidOutElement<Track>> upperTrack, LaidOutElement<Track> lowerTrack, Option<LaidOutElement<Attachment>> watermark, String profileId, String background, String sourceAudioName) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/composite");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("compositeSize", Serializer.json((Dimension)compositeTrackSize).toJson()));
            params.add(new BasicNameValuePair("lowerTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)lowerTrack.getElement())));
            params.add(new BasicNameValuePair("lowerLayout", Serializer.json((Layout)lowerTrack.getLayout()).toJson()));
            if (upperTrack.isSome()) {
                params.add(new BasicNameValuePair("upperTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)((LaidOutElement)upperTrack.get()).getElement())));
                params.add(new BasicNameValuePair("upperLayout", Serializer.json((Layout)((LaidOutElement)upperTrack.get()).getLayout()).toJson()));
            }
            if (watermark.isSome()) {
                params.add(new BasicNameValuePair("watermarkAttachment", MediaPackageElementParser.getAsXml((MediaPackageElement)((LaidOutElement)watermark.get()).getElement())));
                params.add(new BasicNameValuePair("watermarkLayout", Serializer.json((Layout)((LaidOutElement)watermark.get()).getLayout()).toJson()));
            }
            params.add(new BasicNameValuePair("profileId", profileId));
            params.add(new BasicNameValuePair("background", background));
            params.add(new BasicNameValuePair("sourceAudioName", sourceAudioName));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Composite video job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        if (upperTrack.isSome()) {
            throw new EncoderException("Unable to composite video from track " + lowerTrack.getElement() + " and " + ((LaidOutElement)upperTrack.get()).getElement() + " using the remote composer service proxy");
        }
        throw new EncoderException("Unable to composite video from track " + lowerTrack.getElement() + " using the remote composer service proxy");
    }

    public Job concat(String profileId, Dimension outputDimension, boolean sameCodec, Track ... tracks) throws EncoderException, MediaPackageException {
        return this.concat(profileId, outputDimension, -1.0f, sameCodec, tracks);
    }

    public Job concat(String profileId, Dimension outputDimension, float outputFrameRate, boolean sameCodec, Track ... tracks) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/concat");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("profileId", profileId));
            if (outputDimension != null) {
                params.add(new BasicNameValuePair("outputDimension", Serializer.json((Dimension)outputDimension).toJson()));
            }
            params.add(new BasicNameValuePair("outputFrameRate", String.format(Locale.US, "%f", Float.valueOf(outputFrameRate))));
            params.add(new BasicNameValuePair("sourceTracks", MediaPackageElementParser.getArrayAsXml(Arrays.asList(tracks))));
            if (sameCodec) {
                params.add(new BasicNameValuePair("sameCodec", "true"));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Concat video job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to concat videos from tracks " + tracks + " using the remote composer service proxy");
    }

    public Job imageToVideo(Attachment sourceImageAttachment, String profileId, double time) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/imagetovideo");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceAttachment", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceImageAttachment)));
            params.add(new BasicNameValuePair("profileId", profileId));
            params.add(new BasicNameValuePair("time", Double.toString(time)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Image to video converting job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to convert an image to a video from attachment " + sourceImageAttachment + " using the remote composer service proxy");
    }

    public Job demux(Track sourceTrack, String profileId) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/demux");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileId", profileId));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException("Unable to assemble a remote demux request for track " + sourceTrack, (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job r = JobParser.parseJob((String)content);
                logger.info("Demuxing job {} started on a remote service ", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException("Unable to demux track " + sourceTrack + " using a remote composer service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to demux track " + sourceTrack + " using a remote composer service");
    }

    public Job processSmil(Smil smil, String trackParamGroupId, String mediaType, List<String> profileIds) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/processsmil");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("smilAsXml", smil.toXML()));
            params.add(new BasicNameValuePair("trackId", trackParamGroupId));
            params.add(new BasicNameValuePair("mediaType", mediaType));
            params.add(new BasicNameValuePair("profileIds", StringUtils.join(profileIds, (String)",")));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                Job r = JobParser.parseJob((InputStream)response.getEntity().getContent());
                logger.info("Concat video job {} started on a remote composer", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to edit video group(" + trackParamGroupId + ") from smil " + smil + " using the remote composer service proxy");
    }

    public Job multiEncode(Track sourceTrack, List<String> profileIds) throws EncoderException, MediaPackageException {
        HttpPost post = new HttpPost("/multiencode");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("sourceTrack", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("profileIds", StringUtils.join(profileIds, (String)",")));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new EncoderException("Unable to assemble a remote demux request for track " + sourceTrack, (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job job = JobParser.parseJob((String)content);
                logger.info("Encoding job {} started on a remote multiencode", (Object)job.getId());
                Job job2 = job;
                return job2;
            }
        }
        catch (Exception e) {
            throw new EncoderException("Unable to multiencode track " + sourceTrack + " using a remote composer service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new EncoderException("Unable to multiencode track " + sourceTrack + " using a remote composer service");
    }

    private String mapToString(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

