/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ComposeWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running compose workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.encode(workflowInstance.getMediaPackage(), workflowInstance.getCurrentOperation());
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult encode(MediaPackage src, WorkflowOperationInstance operation) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        EncodingProfile profile;
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        String sourceTagsOption = StringUtils.trimToNull((String)operation.getConfiguration("source-tags"));
        String targetTagsOption = StringUtils.trimToNull((String)operation.getConfiguration("target-tags"));
        String sourceFlavorOption = StringUtils.trimToNull((String)operation.getConfiguration("source-flavor"));
        String sourceFlavorsOption = StringUtils.trimToNull((String)operation.getConfiguration("source-flavors"));
        String targetFlavorOption = StringUtils.trimToNull((String)operation.getConfiguration("target-flavor"));
        boolean tagsAndFlavorsOption = Boolean.parseBoolean(StringUtils.trimToNull((String)operation.getConfiguration("tags-and-flavors")));
        TrackSelector elementSelector = new TrackSelector();
        if (StringUtils.isBlank((CharSequence)sourceTagsOption) && StringUtils.isBlank((CharSequence)sourceFlavorOption) && StringUtils.isBlank((CharSequence)sourceFlavorsOption)) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        for (String flavor : this.asList(sourceFlavorsOption)) {
            try {
                elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Source flavor '" + flavor + "' is malformed");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sourceFlavorOption)) {
            String flavor = StringUtils.trim((String)sourceFlavorOption);
            try {
                elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Source flavor '" + (String)flavor + "' is malformed");
            }
        }
        for (String tag : this.asList(sourceTagsOption)) {
            elementSelector.addTag(tag);
        }
        String profilesOption = StringUtils.trimToNull((String)operation.getConfiguration("encoding-profiles"));
        ArrayList<EncodingProfile> profiles = new ArrayList<EncodingProfile>();
        for (String profileName : this.asList(profilesOption)) {
            profile = this.composerService.getProfile(profileName);
            if (profile == null) {
                throw new WorkflowOperationException("Encoding profile '" + profileName + "' was not found");
            }
            profiles.add(profile);
        }
        String profileOption = StringUtils.trimToNull((String)operation.getConfiguration("encoding-profile"));
        if (StringUtils.isNotBlank((CharSequence)profileOption)) {
            String profileId = StringUtils.trim((String)profileOption);
            profile = this.composerService.getProfile(profileId);
            if (profile == null) {
                throw new WorkflowOperationException("Encoding profile '" + profileId + "' was not found");
            }
            profiles.add(profile);
        }
        if (profiles.isEmpty()) {
            throw new WorkflowOperationException("No encoding profile was specified");
        }
        String audioOnlyConfig = StringUtils.trimToNull((String)operation.getConfiguration("audio-only"));
        String videoOnlyConfig = StringUtils.trimToNull((String)operation.getConfiguration("video-only"));
        boolean audioOnly = audioOnlyConfig != null && Boolean.parseBoolean(audioOnlyConfig);
        boolean videoOnly = videoOnlyConfig != null && Boolean.parseBoolean(videoOnlyConfig);
        List targetTags = this.asList(targetTagsOption);
        MediaPackageElementFlavor targetFlavor = null;
        if (StringUtils.isNotBlank((CharSequence)targetFlavorOption)) {
            try {
                targetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetFlavorOption);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Target flavor '" + targetFlavorOption + "' is malformed");
            }
        }
        Collection elements = elementSelector.select(mediaPackage, tagsAndFlavorsOption);
        String processOnlyOneConfig = StringUtils.trimToNull((String)operation.getConfiguration("process-first-match-only"));
        boolean processOnlyOne = processOnlyOneConfig != null && Boolean.parseBoolean(processOnlyOneConfig);
        long totalTimeInQueue = 0L;
        HashMap<Job, JobInformation> encodingJobs = new HashMap<Job, JobInformation>();
        block9: for (Track track : elements) {
            if (audioOnly && track.hasVideo()) {
                logger.info("Skipping encoding of '{}', since it contains a video stream", (Object)track);
                continue;
            }
            if (videoOnly && track.hasAudio()) {
                logger.info("Skipping encoding of '{}', since it containsa an audio stream", (Object)track);
                continue;
            }
            for (EncodingProfile profile2 : profiles) {
                EncodingProfile.MediaType outputType = profile2.getOutputType();
                if (outputType.equals((Object)EncodingProfile.MediaType.Audio) && !track.hasAudio()) {
                    logger.info("Skipping encoding of '{}', since it lacks an audio stream", (Object)track);
                    continue;
                }
                if (outputType.equals((Object)EncodingProfile.MediaType.Visual) && !track.hasVideo()) {
                    logger.info("Skipping encoding of '{}', since it lacks a video stream", (Object)track);
                    continue;
                }
                logger.info("Encoding track {} using encoding profile '{}'", (Object)track, (Object)profile2);
                encodingJobs.put(this.composerService.encode(track, profile2.getIdentifier()), new JobInformation(track, profile2));
                if (!processOnlyOne) continue;
                continue block9;
            }
        }
        if (encodingJobs.isEmpty()) {
            logger.info("No matching tracks found");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        if (!this.waitForStatus(encodingJobs.keySet().toArray(new Job[encodingJobs.size()])).isSuccess()) {
            throw new WorkflowOperationException("One of the encoding jobs did not complete successfully");
        }
        for (Map.Entry entry : encodingJobs.entrySet()) {
            Job job = (Job)entry.getKey();
            Track track = ((JobInformation)entry.getValue()).getTrack();
            totalTimeInQueue += job.getQueueTime().longValue();
            if (job.getPayload().length() <= 0) continue;
            Track composedTrack = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
            for (String tag : targetTags) {
                logger.trace("Tagging composed track with '{}'", (Object)tag);
                composedTrack.addTag(tag);
            }
            if (targetFlavor != null) {
                String flavorType = targetFlavor.getType();
                String flavorSubtype = targetFlavor.getSubtype();
                if ("*".equals(flavorType)) {
                    flavorType = track.getFlavor().getType();
                }
                if ("*".equals(flavorSubtype)) {
                    flavorSubtype = track.getFlavor().getSubtype();
                }
                composedTrack.setFlavor(new MediaPackageElementFlavor(flavorType, flavorSubtype));
                logger.debug("Composed track has flavor '{}'", (Object)composedTrack.getFlavor());
            }
            mediaPackage.addDerived((MediaPackageElement)composedTrack, (MediaPackageElement)track);
            String fileName = this.getFileNameFromElements((MediaPackageElement)track, (MediaPackageElement)composedTrack);
            composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
        logger.debug("Compose operation completed");
        return result;
    }

    private static final class JobInformation {
        private Track track = null;
        private EncodingProfile profile = null;

        JobInformation(Track track, EncodingProfile profile) {
            this.track = track;
            this.profile = profile;
        }

        public Track getTrack() {
            return this.track;
        }

        public EncodingProfile getProfile() {
            return this.profile;
        }
    }
}

