/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.selector.AttachmentSelector;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.PathSupport;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageConvertWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ImageConvertWorkflowOperationHandler.class);
    private static final String CONFIG_KEY_SOURCE_FLAVOR = "source-flavor";
    private static final String CONFIG_KEY_SOURCE_FLAVORS = "source-flavors";
    private static final String CONFIG_KEY_SOURCE_TAGS = "source-tags";
    private static final String CONFIG_KEY_TARGET_FLAVOR = "target-flavor";
    private static final String CONFIG_KEY_TARGET_FLAVORS = "target-flavors";
    private static final String CONFIG_KEY_TARGET_TAGS = "target-tags";
    private static final String CONFIG_KEY_ENCODING_PROFILE = "encoding-profile";
    private static final String CONFIG_KEY_ENCODING_PROFILES = "encoding-profiles";
    private static final String CONFIG_KEY_TAGS_AND_FLAVORS = "tags-and-flavors";
    private ComposerService composerService = null;
    private Workspace workspace = null;

    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String sourceFlavorOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_SOURCE_FLAVOR));
        String sourceFlavorsOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_SOURCE_FLAVORS));
        String sourceTagsOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_SOURCE_TAGS));
        String targetFlavorOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_TARGET_FLAVOR));
        if (targetFlavorOption == null) {
            targetFlavorOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_TARGET_FLAVORS));
        }
        String targetTagsOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_TARGET_TAGS));
        String encodingProfileOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_ENCODING_PROFILE));
        if (encodingProfileOption == null) {
            encodingProfileOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_ENCODING_PROFILES));
        }
        String tagsAndFlavorsOption = StringUtils.trimToNull((String)operation.getConfiguration(CONFIG_KEY_TAGS_AND_FLAVORS));
        boolean tagsAndFlavors = BooleanUtils.toBoolean((String)tagsAndFlavorsOption);
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        if (StringUtils.isBlank((CharSequence)sourceFlavorOption) && StringUtils.isBlank((CharSequence)sourceFlavorsOption) && StringUtils.isBlank((CharSequence)sourceTagsOption)) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        MediaPackageElementFlavor targetFlavor = null;
        if (StringUtils.isNotBlank((CharSequence)targetFlavorOption)) {
            try {
                targetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetFlavorOption);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Target flavor '" + targetFlavorOption + "' is malformed");
            }
        }
        ArrayList<Object> fixedTags = new ArrayList<Object>();
        ArrayList<String> additionalTags = new ArrayList<String>();
        ArrayList<String> removingTags = new ArrayList<String>();
        for (Object targetTag : this.asList(targetTagsOption)) {
            if (!StringUtils.startsWithAny((CharSequence)targetTag, (CharSequence[])new CharSequence[]{"+", "-"})) {
                if (additionalTags.size() > 0 || removingTags.size() > 0) {
                    logger.warn("You may not mix fixed tags and tag changes. Please review target-tags option on image-convert operation of your workflow definition. The tag {} is not prefixed with '+' or '-'.", targetTag);
                }
                fixedTags.add(targetTag);
                continue;
            }
            if (StringUtils.startsWith((CharSequence)targetTag, (CharSequence)"+")) {
                additionalTags.add(StringUtils.substring((String)targetTag, (int)1));
                continue;
            }
            if (!StringUtils.startsWith((CharSequence)targetTag, (CharSequence)"-")) continue;
            removingTags.add(StringUtils.substring((String)targetTag, (int)1));
        }
        ArrayList profiles = new ArrayList();
        for (Object encodingProfileId : this.asList(encodingProfileOption)) {
            EncodingProfile profile = this.composerService.getProfile((String)encodingProfileId);
            if (profile == null) {
                throw new WorkflowOperationException("Encoding profile '" + (String)encodingProfileId + "' was not found");
            }
            profiles.add(encodingProfileId);
        }
        if (profiles.isEmpty()) {
            throw new WorkflowOperationException("No encoding profile was specified");
        }
        AttachmentSelector attachmentSelector = new AttachmentSelector();
        for (String sourceFlavor : this.asList(sourceFlavorsOption)) {
            attachmentSelector.addFlavor(sourceFlavor);
        }
        for (String sourceFlavor : this.asList(sourceFlavorOption)) {
            attachmentSelector.addFlavor(sourceFlavor);
        }
        for (String sourceTag : this.asList(sourceTagsOption)) {
            attachmentSelector.addTag(sourceTag);
        }
        Collection sourceElements = attachmentSelector.select(mediaPackage, tagsAndFlavors);
        Hashtable<Job, Attachment> jobs = new Hashtable<Job, Attachment>();
        try {
            Job job;
            for (Attachment attachment : sourceElements) {
                job = this.composerService.convertImage(attachment, profiles.toArray(new String[profiles.size()]));
                jobs.put(job, attachment);
            }
            if (!this.waitForStatus(jobs.keySet().toArray(new Job[jobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("At least one image conversation job did not succeed.");
            }
            for (Map.Entry entry : jobs.entrySet()) {
                job = (Job)entry.getKey();
                Attachment sourceElement = (Attachment)entry.getValue();
                List targetElements = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
                for (Attachment targetElement : targetElements) {
                    String targetFileName = PathSupport.toSafeName((String)FilenameUtils.getName((String)targetElement.getURI().getPath()));
                    URI newTargetElementUri = this.workspace.moveTo(targetElement.getURI(), mediaPackage.getIdentifier().compact(), targetElement.getIdentifier(), targetFileName);
                    targetElement.setURI(newTargetElementUri);
                    targetElement.setChecksum(null);
                    if (targetFlavor != null) {
                        targetElement.setFlavor(targetFlavor);
                        if (StringUtils.equalsAny((CharSequence)"*", (CharSequence[])new CharSequence[]{targetFlavor.getType()})) {
                            targetElement.setFlavor(MediaPackageElementFlavor.flavor((String)sourceElement.getFlavor().getType(), (String)targetElement.getFlavor().getSubtype()));
                        }
                        if (StringUtils.equalsAny((CharSequence)"*", (CharSequence[])new CharSequence[]{targetFlavor.getSubtype()})) {
                            targetElement.setFlavor(MediaPackageElementFlavor.flavor((String)targetElement.getFlavor().getType(), (String)sourceElement.getFlavor().getSubtype()));
                        }
                    }
                    targetElement.clearTags();
                    if (!(!fixedTags.isEmpty() || additionalTags.isEmpty() && removingTags.isEmpty())) {
                        for (String tag : sourceElement.getTags()) {
                            targetElement.addTag(tag);
                        }
                    }
                    for (String string : fixedTags) {
                        targetElement.addTag(string);
                    }
                    for (String string : additionalTags) {
                        targetElement.addTag(string);
                    }
                    for (String string : removingTags) {
                        targetElement.removeTag(string);
                    }
                    mediaPackage.addDerived((MediaPackageElement)targetElement, (MediaPackageElement)sourceElement);
                }
            }
            Iterator<Object> iterator = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            return iterator;
        }
        catch (WorkflowOperationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new WorkflowOperationException("Convert image operation failed", t);
        }
        finally {
            this.cleanupWorkspace(jobs.keySet());
        }
    }

    private void cleanupWorkspace(Collection<Job> jobs) {
        for (Job job : jobs) {
            try {
                List targetElements = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
                for (Attachment targetElement : targetElements) {
                    try {
                        this.workspace.delete(targetElement.getURI());
                    }
                    catch (NotFoundException ex) {
                        logger.trace("The image file {} not found", (Object)targetElement, (Object)ex);
                    }
                    catch (IOException ex) {
                        logger.warn("Unable to delete image file {} from workspace", (Object)targetElement, (Object)ex);
                    }
                }
            }
            catch (MediaPackageException ex) {
                logger.debug("Unable to parse job payload from job {}", (Object)job.getId(), (Object)ex);
            }
        }
    }
}

