/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Fn2;
import com.entwinemedia.fn.Fx;
import com.entwinemedia.fn.P2;
import com.entwinemedia.fn.Prelude;
import com.entwinemedia.fn.StreamFold;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Strings;
import com.entwinemedia.fn.parser.Parser;
import com.entwinemedia.fn.parser.Parsers;
import com.entwinemedia.fn.parser.Result;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobBarrier;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.AbstractMediaPackageElementSelector;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.JobUtil;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.PathSupport;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.util.data.Collections;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ImageWorkflowOperationHandler.class);
    public static final String OPT_SOURCE_FLAVOR = "source-flavor";
    public static final String OPT_SOURCE_FLAVORS = "source-flavors";
    public static final String OPT_SOURCE_TAGS = "source-tags";
    public static final String OPT_PROFILES = "encoding-profile";
    public static final String OPT_POSITIONS = "time";
    public static final String OPT_TARGET_FLAVOR = "target-flavor";
    public static final String OPT_TARGET_TAGS = "target-tags";
    public static final String OPT_TARGET_BASE_NAME_FORMAT_SECOND = "target-base-name-format-second";
    public static final String OPT_TARGET_BASE_NAME_FORMAT_PERCENT = "target-base-name-format-percent";
    public static final String OPT_END_MARGIN = "end-margin";
    private static final long END_MARGIN_DEFAULT = 100L;
    private ComposerService composerService = null;
    private Workspace workspace = null;

    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext ctx) throws WorkflowOperationException {
        logger.debug("Running image workflow operation on {}", (Object)wi);
        try {
            Extractor e = new Extractor(this, this.configure(wi.getMediaPackage(), wi.getCurrentOperation()));
            return e.main(MediaPackageSupport.copy((MediaPackage)wi.getMediaPackage()));
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    static String formatFileName(String format, double position, String suffix) {
        return PathSupport.toSafeName((String)String.format(format, position, suffix));
    }

    private static List<Job> concatJobs(List<Extraction> extractions) {
        return com.entwinemedia.fn.Stream.$(extractions).map((Fn)new Fn<Extraction, Job>(){

            public Job apply(Extraction extraction) {
                return extraction.job;
            }
        }).toList();
    }

    private static List<Attachment> getImages(Job job) {
        List images;
        try {
            images = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
        }
        catch (MediaPackageException e) {
            return (List)Prelude.chuck((Throwable)e);
        }
        if (!images.isEmpty()) {
            return images;
        }
        return (List)Prelude.chuck((Throwable)new WorkflowOperationException("Job did not extract any images"));
    }

    static List<MediaPosition> limit(Track track, List<MediaPosition> positions) {
        Long duration = track.getDuration();
        if (duration == null || track.getStreams() != null && Arrays.stream(track.getStreams()).filter(stream -> stream instanceof VideoStream).map(Stream::getFrameCount).allMatch(frameCount -> frameCount == null || frameCount == 1L)) {
            return java.util.Collections.singletonList(new MediaPosition(PositionType.Seconds, 0.0));
        }
        return positions.stream().filter(p -> PositionType.Seconds.equals((Object)((MediaPosition)p).type) && ((MediaPosition)p).position >= 0.0 && ((MediaPosition)p).position < (double)duration.longValue() || PositionType.Percentage.equals((Object)((MediaPosition)p).type) && ((MediaPosition)p).position >= 0.0 && ((MediaPosition)p).position <= 100.0).collect(Collectors.toList());
    }

    static double toSeconds(Track track, MediaPosition position, double endMarginMs) {
        double posMs;
        long durationMs = track.getDuration() == null ? 0L : track.getDuration();
        switch (position.type) {
            case Percentage: {
                posMs = (double)durationMs * position.position / 100.0;
                break;
            }
            case Seconds: {
                posMs = position.position * 1000.0;
                break;
            }
            default: {
                throw Prelude.unexhaustiveMatchError();
            }
        }
        return Math.abs((double)durationMs - posMs) >= endMarginMs ? posMs / 1000.0 : Math.max(0.0, (double)durationMs - endMarginMs) / 1000.0;
    }

    public static <E extends MediaPackageElement, S extends AbstractMediaPackageElementSelector<E>> StreamFold<MediaPackageElementFlavor, S> flavorFold(S selector) {
        return StreamFold.foldl(selector, (Fn2)new Fn2<S, MediaPackageElementFlavor, S>(){

            public S apply(S sum, MediaPackageElementFlavor flavor) {
                sum.addFlavor(flavor);
                return sum;
            }
        });
    }

    public static <E extends MediaPackageElement, S extends AbstractMediaPackageElementSelector<E>> StreamFold<String, S> tagFold(S selector) {
        return StreamFold.foldl(selector, (Fn2)new Fn2<S, String, S>(){

            public S apply(S sum, String tag) {
                sum.addTag(tag);
                return sum;
            }
        });
    }

    public static Fn<String, EncodingProfile> fetchProfile(final ComposerService composerService) {
        return new Fn<String, EncodingProfile>(){

            public EncodingProfile apply(String profileName) {
                EncodingProfile profile = composerService.getProfile(profileName);
                return profile != null ? profile : (EncodingProfile)Prelude.chuck((Throwable)new WorkflowOperationException("Encoding profile '" + profileName + "' was not found"));
            }
        };
    }

    private Cfg configure(MediaPackage mp, WorkflowOperationInstance woi) throws WorkflowOperationException {
        List profiles = this.getOptConfig(woi, OPT_PROFILES).toStream().bind(this.asList.toFn()).map(ImageWorkflowOperationHandler.fetchProfile(this.composerService)).toList();
        List targetImageTags = this.getOptConfig(woi, OPT_TARGET_TAGS).toStream().bind(this.asList.toFn()).toList();
        Opt targetImageFlavor = this.getOptConfig(woi, OPT_TARGET_FLAVOR).map(MediaPackageElementFlavor.parseFlavor.toFn());
        com.entwinemedia.fn.Stream sourceFlavors = this.getOptConfig(woi, OPT_SOURCE_FLAVORS).toStream().bind(Strings.splitCsv).append((Iterable)this.getOptConfig(woi, OPT_SOURCE_FLAVOR)).map(MediaPackageElementFlavor.parseFlavor.toFn());
        com.entwinemedia.fn.Stream sourceTags = this.getOptConfig(woi, OPT_SOURCE_TAGS).toStream().bind(Strings.splitCsv);
        TrackSelector trackSelector = (TrackSelector)sourceTags.apply(ImageWorkflowOperationHandler.tagFold((AbstractMediaPackageElementSelector)sourceFlavors.apply(ImageWorkflowOperationHandler.flavorFold(new TrackSelector()))));
        List<Track> sourceTracks = trackSelector.select(mp, true).stream().filter(Track::hasVideo).collect(Collectors.toList());
        List<MediaPosition> positions = this.parsePositions(this.getConfig(woi, OPT_POSITIONS));
        long endMargin = (Long)this.getOptConfig(woi, OPT_END_MARGIN).bind(Strings.toLong).getOr((Object)100L);
        return new Cfg(sourceTracks, positions, profiles, (Opt<MediaPackageElementFlavor>)targetImageFlavor, targetImageTags, this.getTargetBaseNameFormat(woi, OPT_TARGET_BASE_NAME_FORMAT_SECOND), this.getTargetBaseNameFormat(woi, OPT_TARGET_BASE_NAME_FORMAT_PERCENT), endMargin);
    }

    private Opt<String> getTargetBaseNameFormat(WorkflowOperationInstance woi, String formatName) {
        return this.getOptConfig(woi, formatName).each(ImageWorkflowOperationHandler.validateTargetBaseNameFormat(formatName));
    }

    static Fx<String> validateTargetBaseNameFormat(final String formatName) {
        return new Fx<String>(){

            public void apply(String format) {
                boolean valid;
                try {
                    String name = ImageWorkflowOperationHandler.formatFileName(format, 15.11, ".png");
                    valid = name.contains(".") && name.contains(".png");
                }
                catch (IllegalFormatException e) {
                    valid = false;
                }
                if (!valid) {
                    Prelude.chuck((Throwable)new WorkflowOperationException(String.format("%s is not a valid format string for config option %s", format, formatName)));
                }
            }
        };
    }

    private List<MediaPosition> parsePositions(String time) throws WorkflowOperationException {
        Result r = MediaPositionParser.positions.parse(time);
        if (r.isDefined() && r.getRest().isEmpty()) {
            return (List)r.getResult();
        }
        throw new WorkflowOperationException(String.format("Cannot parse time string %s.", time));
    }

    static final class MediaPosition {
        private final double position;
        private final PositionType type;

        MediaPosition(PositionType type, double position) {
            this.position = position;
            this.type = type;
        }

        public int hashCode() {
            return Equality.hash((Object[])new Object[]{this.position, this.type});
        }

        public boolean equals(Object that) {
            return this == that || that instanceof MediaPosition && this.eqFields((MediaPosition)that);
        }

        private boolean eqFields(MediaPosition that) {
            return this.position == that.position && EqualsUtil.eq((Object)((Object)this.type), (Object)((Object)that.type));
        }

        public String toString() {
            return String.format("MediaPosition(%s, %s)", new Object[]{this.type, this.position});
        }
    }

    static enum PositionType {
        Percentage,
        Seconds;

    }

    static final class MediaPositionParser {
        static final Parser<Double> number = Parsers.token((Parser)Parsers.dbl);
        static final Parser<MediaPosition> seconds = number.bind((Fn)new Fn<Double, Parser<MediaPosition>>(){

            public Parser<MediaPosition> apply(Double p) {
                return Parsers.yield((Object)new MediaPosition(PositionType.Seconds, p));
            }
        });
        static final Parser<MediaPosition> percentage = number.bind(Parsers.ignore((Parser)Parsers.symbol((String)"%"))).bind((Fn)new Fn<Double, Parser<MediaPosition>>(){

            public Parser<MediaPosition> apply(Double p) {
                return Parsers.yield((Object)new MediaPosition(PositionType.Percentage, p));
            }
        });
        static final Parser<Character> comma = Parsers.token((Parser)Parsers.character((Character)Character.valueOf(',')));
        static final Parser<Character> ws = Parsers.token((Parser)Parsers.space);
        static final Parser<MediaPosition> position = percentage.or(seconds);
        static final Parser<List<MediaPosition>> positions = position.bind((Fn)new Fn<MediaPosition, Parser<List<MediaPosition>>>(){

            public Parser<List<MediaPosition>> apply(final MediaPosition first) {
                return Parsers.many((Parser)Parsers.opt(comma).bind(Parsers.ignorePrevious(position))).bind((Fn)new Fn<List<MediaPosition>, Parser<List<MediaPosition>>>(){

                    public Parser<List<MediaPosition>> apply(List<MediaPosition> rest) {
                        return Parsers.yield((Object)com.entwinemedia.fn.Stream.$((Object[])new MediaPosition[]{first}).append(rest).toList());
                    }
                });
            }
        });

        private MediaPositionParser() {
        }
    }

    static final class Cfg {
        private final List<Track> sourceTracks;
        private final List<MediaPosition> positions;
        private final List<EncodingProfile> profiles;
        private final Opt<MediaPackageElementFlavor> targetImageFlavor;
        private final List<String> targetImageTags;
        private final Opt<String> targetBaseNameFormatSecond;
        private final Opt<String> targetBaseNameFormatPercent;
        private final long endMargin;

        Cfg(List<Track> sourceTracks, List<MediaPosition> positions, List<EncodingProfile> profiles, Opt<MediaPackageElementFlavor> targetImageFlavor, List<String> targetImageTags, Opt<String> targetBaseNameFormatSecond, Opt<String> targetBaseNameFormatPercent, long endMargin) {
            this.sourceTracks = sourceTracks;
            this.positions = positions;
            this.profiles = profiles;
            this.targetImageFlavor = targetImageFlavor;
            this.targetImageTags = targetImageTags;
            this.endMargin = endMargin;
            this.targetBaseNameFormatSecond = targetBaseNameFormatSecond;
            this.targetBaseNameFormatPercent = targetBaseNameFormatPercent;
        }
    }

    static final class Extraction {
        private final Job job;
        private final Track track;
        private final EncodingProfile profile;
        private final List<MediaPosition> positions;

        private Extraction(Job job, Track track, EncodingProfile profile, List<MediaPosition> positions) {
            this.job = job;
            this.track = track;
            this.profile = profile;
            this.positions = positions;
        }
    }

    static final class Extractor {
        private final ImageWorkflowOperationHandler handler;
        private final Cfg cfg;

        Extractor(ImageWorkflowOperationHandler handler, Cfg cfg) {
            this.handler = handler;
            this.cfg = cfg;
        }

        WorkflowOperationResult main(MediaPackage mp) throws WorkflowOperationException {
            if (this.cfg.sourceTracks.size() == 0) {
                logger.info("No source tracks found in media package {}, skipping operation", (Object)mp.getIdentifier());
                return this.handler.createResult(mp, WorkflowOperationResult.Action.SKIP);
            }
            List extractions = com.entwinemedia.fn.Stream.$((Iterable)this.cfg.sourceTracks).bind((Fn)new Fn<Track, com.entwinemedia.fn.Stream<Extraction>>(){

                public com.entwinemedia.fn.Stream<Extraction> apply(final Track t) {
                    final List<MediaPosition> p = ImageWorkflowOperationHandler.limit(t, cfg.positions);
                    if (p.size() != cfg.positions.size()) {
                        logger.warn("Could not apply all configured positions to track " + t);
                    } else {
                        logger.info(String.format("Extracting images from %s at position %s", t, com.entwinemedia.fn.Stream.$(p).mkString(", ")));
                    }
                    return com.entwinemedia.fn.Stream.$((Iterable)cfg.profiles).map((Fn)new Fn<EncodingProfile, Extraction>(){

                        public Extraction apply(EncodingProfile profile) {
                            return new Extraction(this.extractImages(t, profile, p), t, profile, p);
                        }
                    });
                }
            }).toList();
            List extractionJobs = ImageWorkflowOperationHandler.concatJobs(extractions);
            JobBarrier.Result extractionResult = JobUtil.waitForJobs((ServiceRegistry)this.handler.serviceRegistry, (Collection)extractionJobs);
            if (extractionResult.isSuccess()) {
                for (Extraction extraction : extractions) {
                    List images = ImageWorkflowOperationHandler.getImages(extraction.job);
                    int expectedNrOfImages = extraction.positions.size();
                    if (images.size() == expectedNrOfImages) {
                        for (P2 image : com.entwinemedia.fn.Stream.$((Iterable)images).zip((Iterable)extraction.positions)) {
                            this.adjustMetadata(extraction, (Attachment)image.get1());
                            if (((Attachment)image.get1()).getIdentifier() == null) {
                                ((Attachment)image.get1()).setIdentifier(UUID.randomUUID().toString());
                            }
                            mp.addDerived((MediaPackageElement)image.get1(), (MediaPackageElement)extraction.track);
                            String fileName = this.createFileName(extraction.profile.getSuffix(), extraction.track.getURI(), (MediaPosition)image.get2());
                            this.moveToWorkspace(mp, (Attachment)image.get1(), fileName);
                        }
                        continue;
                    }
                    throw new WorkflowOperationException(String.format("Only %s of %s images have been extracted from track %s", images.size(), expectedNrOfImages, extraction.track));
                }
                return this.handler.createResult(mp, WorkflowOperationResult.Action.CONTINUE, JobUtil.sumQueueTime((List)extractionJobs));
            }
            throw new WorkflowOperationException("Image extraction failed");
        }

        void adjustMetadata(Extraction extraction, Attachment image) {
            for (MediaPackageElementFlavor flavor : this.cfg.targetImageFlavor) {
                String flavorType = EqualsUtil.eq((Object)"*", (Object)flavor.getType()) ? extraction.track.getFlavor().getType() : flavor.getType();
                String flavorSubtype = EqualsUtil.eq((Object)"*", (Object)flavor.getSubtype()) ? extraction.track.getFlavor().getSubtype() : flavor.getSubtype();
                image.setFlavor(new MediaPackageElementFlavor(flavorType, flavorSubtype));
                logger.debug("Resulting image has flavor '{}'", (Object)image.getFlavor());
            }
            try {
                image.setMimeType(MimeTypes.fromURI((URI)image.getURI()));
            }
            catch (UnknownFileTypeException e) {
                logger.warn("Mime type unknown for file {}. Setting none.", (Object)image.getURI(), (Object)e);
            }
            for (String tag : this.cfg.targetImageTags) {
                logger.trace("Tagging image with '{}'", (Object)tag);
                image.addTag(tag);
            }
        }

        String createFileName(String suffix, URI trackUri, MediaPosition pos) {
            String format;
            String trackBaseName = FilenameUtils.getBaseName((String)trackUri.getPath());
            switch (pos.type) {
                case Seconds: {
                    format = (String)this.cfg.targetBaseNameFormatSecond.getOr((Object)(trackBaseName + "_%.3fs%s"));
                    break;
                }
                case Percentage: {
                    format = (String)this.cfg.targetBaseNameFormatPercent.getOr((Object)(trackBaseName + "_%.1fp%s"));
                    break;
                }
                default: {
                    throw Prelude.unexhaustiveMatchError();
                }
            }
            return ImageWorkflowOperationHandler.formatFileName(format, pos.position, suffix);
        }

        private void moveToWorkspace(MediaPackage mp, Attachment image, String fileName) {
            try {
                image.setURI(this.handler.workspace.moveTo(image.getURI(), mp.getIdentifier().toString(), image.getIdentifier(), fileName));
            }
            catch (Exception e) {
                Prelude.chuck((Throwable)new WorkflowOperationException((Throwable)e));
            }
        }

        private Job extractImages(final Track track, EncodingProfile profile, List<MediaPosition> positions) {
            List p = com.entwinemedia.fn.Stream.$(positions).map((Fn)new Fn<MediaPosition, Double>(){

                public Double apply(MediaPosition mediaPosition) {
                    return ImageWorkflowOperationHandler.toSeconds(track, mediaPosition, cfg.endMargin);
                }
            }).toList();
            try {
                return this.handler.composerService.image(track, profile.getIdentifier(), Collections.toDoubleArray((Collection)p));
            }
            catch (Exception e) {
                return (Job)Prelude.chuck((Throwable)new WorkflowOperationException("Error starting image extraction job", (Throwable)e));
            }
        }
    }
}

