/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParamGroup;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.PathSupport;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSmilWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    static final String SEPARATOR = ";";
    private static final Logger logger = LoggerFactory.getLogger(ProcessSmilWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private SmilService smilService;
    private Workspace workspace = null;

    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    protected void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        try {
            return this.processSmil(workflowInstance.getMediaPackage(), workflowInstance.getCurrentOperation());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private String[] getConfigAsArray(WorkflowOperationInstance operation, String name) {
        String sourceOption = StringUtils.trimToNull((String)operation.getConfiguration(name));
        String[] options = sourceOption != null ? sourceOption.split(SEPARATOR) : null;
        return options;
    }

    private String[] collapseConfig(WorkflowOperationInstance operation, String name) {
        String[] stringArray;
        String targetOption = StringUtils.trimToNull((String)operation.getConfiguration(name));
        if (targetOption != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = targetOption.replaceAll(SEPARATOR, ",");
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private WorkflowOperationResult processSmil(MediaPackage src, WorkflowOperationInstance operation) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        boolean tagWithProfile;
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        String smilFlavorOption = StringUtils.trimToEmpty((String)operation.getConfiguration("smil-flavor"));
        String[] srcFlavors = this.getConfigAsArray(operation, "source-flavors");
        Object[] targetFlavors = this.getConfigAsArray(operation, "target-flavors");
        Object[] targetTags = this.getConfigAsArray(operation, "target-tags");
        Object[] profilesSections = this.getConfigAsArray(operation, "encoding-profiles");
        String tagWithProfileConfig = StringUtils.trimToNull((String)operation.getConfiguration("tag-with-profile"));
        boolean bl = tagWithProfile = tagWithProfileConfig != null && Boolean.parseBoolean(tagWithProfileConfig);
        if (StringUtils.isBlank((CharSequence)smilFlavorOption)) {
            logger.info("No smil flavor has been specified, no src to process");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        if (srcFlavors == null) {
            logger.info("No source flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        if (profilesSections == null) {
            throw new WorkflowOperationException("No encoding profile was specified");
        }
        if (srcFlavors.length > 1) {
            if (targetFlavors != null && srcFlavors.length != targetFlavors.length && targetFlavors.length != 1) {
                String mesg = "Number of target flavor sections " + targetFlavors + " must either match that of src flavor " + srcFlavors + " or equal 1 ";
                throw new WorkflowOperationException(mesg);
            }
            if (srcFlavors.length != profilesSections.length) {
                if (profilesSections.length != 1) {
                    String mesg = "Number of encoding profile sections " + profilesSections + " must either match that of src flavor " + srcFlavors + " or equal 1 ";
                    throw new WorkflowOperationException(mesg);
                }
                Object[] array = new String[srcFlavors.length];
                Arrays.fill(array, 0, srcFlavors.length, profilesSections[0]);
                profilesSections = array;
            }
            if (targetTags != null && srcFlavors.length != targetTags.length && targetTags.length != 1) {
                String mesg = "Number of target Tags sections " + targetTags + " must either match that of src flavor " + srcFlavors + " or equal 1 ";
                throw new WorkflowOperationException(mesg);
            }
        } else {
            targetFlavors = this.collapseConfig(operation, "target-flavors");
            targetTags = this.collapseConfig(operation, "target-tags");
            profilesSections = this.collapseConfig(operation, "encoding-profiles");
            if (profilesSections.length != 1) {
                throw new WorkflowOperationException("No matching src flavors " + srcFlavors + " for encoding profiles sections " + profilesSections);
            }
            logger.debug("Single input flavor: output= " + Arrays.toString(targetFlavors) + " tag: " + Arrays.toString(targetTags) + " profile:" + Arrays.toString(profilesSections));
        }
        HashMap<Job, JobInformation> encodingJobs = new HashMap<Job, JobInformation>();
        for (int i = 0; i < profilesSections.length; ++i) {
            this.processSection(encodingJobs, mediaPackage, srcFlavors.length > 1 ? srcFlavors[i] : srcFlavors[0], (String)(targetFlavors != null ? (targetFlavors.length > 1 ? targetFlavors[i] : targetFlavors[0]) : null), (String)(targetTags != null ? (targetTags.length > 1 ? targetTags[i] : targetTags[0]) : null), (String)(profilesSections.length > 0 ? profilesSections[i] : profilesSections[0]), smilFlavorOption, tagWithProfile);
        }
        if (encodingJobs.isEmpty()) {
            logger.info("Failed to process any tracks");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        if (!this.waitForStatus(encodingJobs.keySet().toArray(new Job[encodingJobs.size()])).isSuccess()) {
            throw new WorkflowOperationException("One of the encoding jobs did not complete successfully");
        }
        ResultTally allResults = this.parseResults(encodingJobs, mediaPackage);
        WorkflowOperationResult result = this.createResult(allResults.getMediaPackage(), WorkflowOperationResult.Action.CONTINUE, allResults.getTotalTimeInQueue());
        logger.debug("ProcessSmil operation completed");
        return result;
    }

    private void processSection(Map<Job, JobInformation> encodingJobs, MediaPackage mediaPackage, String srcFlavors, String targetFlavors, String targetTags, String encodingProfiles, String smilFlavor, boolean tagWithProfile) throws WorkflowOperationException, EncoderException, MediaPackageException, IllegalArgumentException, NotFoundException, IOException {
        List<TrackSection> smilgroups;
        TrackSelector elementSelector = new TrackSelector();
        for (String flavor : this.asList(srcFlavors)) {
            try {
                elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Source flavor '" + flavor + "' is malformed");
            }
        }
        Smil smil = this.getSmil(mediaPackage, smilFlavor);
        try {
            smilgroups = this.selectTracksFromMP(mediaPackage, smil, srcFlavors);
        }
        catch (URISyntaxException e1) {
            logger.info("Smil contains bad URI {}", (Throwable)e1);
            throw new WorkflowOperationException("Smil contains bad URI - cannot process", (Throwable)e1);
        }
        if (smilgroups.size() == 0 || smilgroups.get(0).sourceTracks.size() == 0) {
            logger.info("Smil does not contain any tracks of {} source flavor", (Object)srcFlavors);
            return;
        }
        MediaPackageElementFlavor targetFlavor = null;
        if (StringUtils.isNotBlank((CharSequence)targetFlavors)) {
            try {
                targetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetFlavors);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Target flavor '" + targetFlavors + "' is malformed");
            }
        }
        HashSet<EncodingProfile> profiles = new HashSet<EncodingProfile>();
        HashSet<String> profileNames = new HashSet<String>();
        for (TrackSection ts : smilgroups) {
            for (Track track : ts.getSourceTracks()) {
                for (String profileName : this.asList(encodingProfiles)) {
                    EncodingProfile profile = this.composerService.getProfile(profileName);
                    if (profile == null) {
                        throw new WorkflowOperationException("Encoding profile '" + profileName + "' was not found");
                    }
                    EncodingProfile.MediaType outputType = profile.getOutputType();
                    if (outputType.equals((Object)EncodingProfile.MediaType.Audio) && !track.hasAudio()) {
                        logger.info("Skipping encoding of '{}' with " + profileName + ", since the track lacks an audio stream", (Object)track);
                        continue;
                    }
                    if (outputType.equals((Object)EncodingProfile.MediaType.Visual) && !track.hasVideo()) {
                        logger.info("Skipping encoding of '{}' " + profileName + ", since the track lacks a video stream", (Object)track);
                        continue;
                    }
                    if (outputType.equals((Object)EncodingProfile.MediaType.AudioVisual) && !track.hasAudio() && !track.hasVideo()) {
                        logger.info("Skipping encoding of '{}' (audiovisual)" + profileName + ", since it lacks a audio or video stream", (Object)track);
                        continue;
                    }
                    profiles.add(profile);
                    profileNames.add(profileName);
                }
            }
        }
        if (profiles.isEmpty()) {
            throw new WorkflowOperationException("No encoding profile was specified");
        }
        List tags = targetTags != null ? this.asList(targetTags) : null;
        for (TrackSection trackGroup : smilgroups) {
            encodingJobs.put(this.composerService.processSmil(smil, trackGroup.paramGroupId, trackGroup.mediaType, new ArrayList(profileNames)), new JobInformation(trackGroup.paramGroupId, trackGroup.sourceTracks, new ArrayList<EncodingProfile>(profiles), tags, targetFlavor, tagWithProfile));
            logger.info("Edit and encode {} target flavors: {} tags: {} profile {}", new Object[]{trackGroup, targetFlavor, tags, profileNames});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultTally parseResults(Map<Job, JobInformation> encodingJobs, MediaPackage mediaPackage) throws IllegalArgumentException, NotFoundException, IOException, MediaPackageException {
        long totalTimeInQueue = 0L;
        for (Map.Entry<Job, JobInformation> entry : encodingJobs.entrySet()) {
            Job job = entry.getKey();
            List<Track> tracks = entry.getValue().getTracks();
            Track track = tracks.get(0);
            totalTimeInQueue += job.getQueueTime().longValue();
            List composedTracks = null;
            if (job.getPayload().length() <= 0) continue;
            composedTracks = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
            for (Track composedTrack : composedTracks) {
                MediaPackageElementFlavor targetFlavor;
                if (entry.getValue().getTags() != null) {
                    for (String tag : entry.getValue().getTags()) {
                        composedTrack.addTag(tag);
                    }
                }
                if ((targetFlavor = entry.getValue().getFlavor()) != null) {
                    String flavorType = targetFlavor.getType();
                    String flavorSubtype = targetFlavor.getSubtype();
                    if ("*".equals(flavorType)) {
                        flavorType = track.getFlavor().getType();
                    }
                    if ("*".equals(flavorSubtype)) {
                        flavorSubtype = track.getFlavor().getSubtype();
                    }
                    composedTrack.setFlavor(new MediaPackageElementFlavor(flavorType, flavorSubtype));
                    logger.debug("Composed track has flavor '{}'", (Object)composedTrack.getFlavor());
                }
                String fileName = composedTrack.getURI().getRawPath();
                if (entry.getValue().getTagProfile()) {
                    List<EncodingProfile> eps = entry.getValue().getProfiles();
                    for (EncodingProfile ep : eps) {
                        String suffix = ep.getSuffix();
                        if ((suffix = PathSupport.toSafeName((String)suffix)).length() <= 0 || !fileName.endsWith(suffix)) continue;
                        composedTrack.addTag(ep.getIdentifier());
                        logger.debug("Tagging composed track {} with '{}'", (Object)composedTrack.getURI(), (Object)ep.getIdentifier());
                        break;
                    }
                }
                composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
                MediaPackage mediaPackage2 = mediaPackage;
                synchronized (mediaPackage2) {
                    mediaPackage.addDerived((MediaPackageElement)composedTrack, (MediaPackageElement)track);
                }
            }
        }
        return new ResultTally(mediaPackage, totalTimeInQueue);
    }

    private boolean trackMatchesFlavor(MediaPackageElementFlavor trackFlavor, MediaPackageElementFlavor sourceFlavor) {
        return trackFlavor.getType().equals(sourceFlavor.getType()) && trackFlavor.getSubtype().equals(sourceFlavor.getSubtype()) || "*".equals(sourceFlavor.getType()) && trackFlavor.getSubtype().equals(sourceFlavor.getSubtype()) || trackFlavor.getType().equals(sourceFlavor.getType()) && "*".equals(sourceFlavor.getSubtype());
    }

    private List<TrackSection> selectTracksFromMP(MediaPackage mediaPackage, Smil smil, String srcFlavors) throws WorkflowOperationException, URISyntaxException {
        ArrayList<TrackSection> sourceTrackList = new ArrayList<TrackSection>();
        Collection<TrackSection> smilFlavors = this.parseSmil(smil);
        for (TrackSection ts : smilFlavors) {
            for (String f : StringUtils.split((String)srcFlavors, (String)",")) {
                String sourceFlavorStr = StringUtils.trimToNull((String)f);
                if (sourceFlavorStr == null) continue;
                MediaPackageElementFlavor sourceFlavor = MediaPackageElementFlavor.parseFlavor((String)sourceFlavorStr);
                MediaPackageElementFlavor trackFlavor = MediaPackageElementFlavor.parseFlavor((String)ts.getFlavor());
                if (!this.trackMatchesFlavor(trackFlavor, sourceFlavor)) continue;
                sourceTrackList.add(ts);
                Track[] elements = null;
                ArrayList<Track> sourceTracks = new ArrayList<Track>();
                elements = mediaPackage.getTracks(sourceFlavor);
                for (String t : ts.getSmilTrackList()) {
                    URI turi = new URI(t);
                    for (Track e : elements) {
                        if (!e.getURI().equals(turi)) continue;
                        sourceTracks.add(e);
                    }
                }
                if (sourceTracks.isEmpty()) {
                    logger.info("ProcessSmil - No tracks in mediapackage matching the URI in the smil- cannot process");
                    throw new WorkflowOperationException("Smil has no matching tracks in the mediapackage");
                }
                ts.setSourceTracks(sourceTracks);
            }
        }
        return sourceTrackList;
    }

    private Smil getSmil(MediaPackage mp, String smilFlavorOption) throws WorkflowOperationException {
        MediaPackageElementFlavor smilFlavor = MediaPackageElementFlavor.parseFlavor((String)smilFlavorOption);
        Catalog[] catalogs = mp.getCatalogs(smilFlavor);
        if (catalogs.length == 0) {
            throw new WorkflowOperationException("MediaPackage does not contain a SMIL document.");
        }
        Smil smil = null;
        try {
            File smilFile = this.workspace.get(catalogs[0].getURI());
            SmilResponse response = this.smilService.fromXml(FileUtils.readFileToString((File)smilFile, (String)"UTF-8"));
            smil = response.getSmil();
            return smil;
        }
        catch (NotFoundException ex) {
            throw new WorkflowOperationException("MediaPackage does not contain a smil catalog.");
        }
        catch (IOException ex) {
            throw new WorkflowOperationException("Failed to read smil catalog.", (Throwable)ex);
        }
        catch (SmilException ex) {
            throw new WorkflowOperationException((Throwable)ex);
        }
    }

    private Collection<TrackSection> parseSmil(Smil smil) {
        ArrayList<TrackSection> trackGroups = new ArrayList<TrackSection>();
        for (SmilMediaParamGroup paramGroup : smil.getHead().getParamGroups()) {
            TrackSection ts = null;
            ArrayList<String> src = new ArrayList<String>();
            for (SmilMediaParam param : paramGroup.getParams()) {
                if ("track-flavor".matches(param.getName())) {
                    ts = new TrackSection(paramGroup.getId(), param.getValue());
                    trackGroups.add(ts);
                }
                if (!"track-src".matches(param.getName())) continue;
                src.add(param.getValue());
            }
            if (ts == null) continue;
            ts.setSmilTrackList(src);
        }
        return trackGroups;
    }

    private static final class JobInformation {
        private final List<EncodingProfile> profiles;
        private final List<Track> tracks;
        private String grp = null;
        private MediaPackageElementFlavor flavor = null;
        private List<String> tags = null;
        private boolean tagProfile;

        JobInformation(String paramgroup, List<Track> tracks, List<EncodingProfile> profiles, List<String> tags, MediaPackageElementFlavor flavor, boolean tagWithProfile) {
            this.tracks = tracks;
            this.grp = paramgroup;
            this.profiles = profiles;
            this.tags = tags;
            this.flavor = flavor;
            this.tagProfile = tagWithProfile;
        }

        public List<Track> getTracks() {
            return this.tracks;
        }

        public MediaPackageElementFlavor getFlavor() {
            return this.flavor;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public boolean getTagProfile() {
            return this.tagProfile;
        }

        public String getGroups() {
            return this.grp;
        }

        public List<EncodingProfile> getProfiles() {
            return this.profiles;
        }
    }

    private class ResultTally {
        private final MediaPackage mediaPackage;
        private final long totalTimeInQueue;

        ResultTally(MediaPackage mediaPackage, long totalTimeInQueue) {
            this.mediaPackage = mediaPackage;
            this.totalTimeInQueue = totalTimeInQueue;
        }

        public MediaPackage getMediaPackage() {
            return this.mediaPackage;
        }

        public long getTotalTimeInQueue() {
            return this.totalTimeInQueue;
        }
    }

    private class TrackSection {
        private final String paramGroupId;
        private List<Track> sourceTracks;
        private List<String> smilTracks;
        private final String flavor;
        private String mediaType = "";

        TrackSection(String id, String flavor) {
            this.flavor = flavor;
            this.paramGroupId = id;
        }

        public List<Track> getSourceTracks() {
            return this.sourceTracks;
        }

        public void setSourceTracks(List<Track> sourceTracks) {
            boolean hasVideo = true;
            boolean hasAudio = true;
            this.sourceTracks = sourceTracks;
            for (Track track : sourceTracks) {
                if (!track.hasVideo()) {
                    hasVideo = false;
                }
                if (track.hasAudio()) continue;
                hasAudio = false;
            }
            if (!hasVideo) {
                this.mediaType = "a";
            }
            if (!hasAudio) {
                this.mediaType = "v";
            }
        }

        public String getFlavor() {
            return this.flavor;
        }

        public String toString() {
            return this.paramGroupId + " " + this.flavor + " " + this.sourceTracks.toString();
        }

        public void setSmilTrackList(List<String> smilSourceTracks) {
            this.smilTracks = smilSourceTracks;
        }

        public List<String> getSmilTrackList() {
            return this.smilTracks;
        }
    }
}

