/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.MediaPackageReferenceImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogService;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.opencastproject.metadata.mpeg7.Video;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreviewsWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SegmentPreviewsWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Mpeg7CatalogService mpeg7CatalogService = null;
    private Workspace workspace = null;

    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    protected void setMpeg7CatalogService(Mpeg7CatalogService catalogService) {
        this.mpeg7CatalogService = catalogService;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running segments preview workflow operation on {}", (Object)workflowInstance);
        MediaPackage src = (MediaPackage)workflowInstance.getMediaPackage().clone();
        Catalog[] segmentCatalogs = src.getCatalogs(MediaPackageElements.SEGMENTS);
        if (segmentCatalogs.length == 0) {
            logger.info("Media package {} does not contain segment information", (Object)src);
            return this.createResult(WorkflowOperationResult.Action.CONTINUE);
        }
        try {
            return this.createPreviews(src, workflowInstance.getCurrentOperation());
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult createPreviews(MediaPackage mediaPackage, WorkflowOperationInstance operation) throws EncoderException, InterruptedException, ExecutionException, NotFoundException, MediaPackageException, IOException, WorkflowOperationException {
        long totalTimeInQueue = 0L;
        String sourceVideoFlavor = StringUtils.trimToNull((String)operation.getConfiguration("source-flavor"));
        String sourceTags = StringUtils.trimToNull((String)operation.getConfiguration("source-tags"));
        String targetImageTags = StringUtils.trimToNull((String)operation.getConfiguration("target-tags"));
        String targetImageFlavor = StringUtils.trimToNull((String)operation.getConfiguration("target-flavor"));
        String encodingProfileName = StringUtils.trimToNull((String)operation.getConfiguration("encoding-profile"));
        String referenceFlavor = StringUtils.trimToNull((String)operation.getConfiguration("reference-flavor"));
        String referenceTags = StringUtils.trimToNull((String)operation.getConfiguration("reference-tags"));
        EncodingProfile profile = this.composerService.getProfile(encodingProfileName);
        if (profile == null) {
            throw new IllegalStateException("Encoding profile '" + encodingProfileName + "' was not found");
        }
        List sourceTagSet = this.asList(sourceTags);
        HashSet<Track> videoTrackSet = new HashSet<Track>();
        for (Track track : mediaPackage.getTracksByTags((Collection)sourceTagSet)) {
            if (sourceVideoFlavor != null && (track.getFlavor() == null || !sourceVideoFlavor.equals(track.getFlavor().toString())) || !track.hasVideo()) continue;
            videoTrackSet.add(track);
        }
        if (videoTrackSet.size() == 0) {
            logger.debug("Mediapackage {} has no suitable tracks to extract images based on tags {} and flavor {}", new Object[]{mediaPackage, sourceTags, sourceVideoFlavor});
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        List referenceTagSet = this.asList(referenceTags);
        for (Track t : videoTrackSet) {
            MediaPackageReferenceImpl trackReference = new MediaPackageReferenceImpl((MediaPackageElement)t);
            Catalog[] segmentCatalogs = mediaPackage.getCatalogs(MediaPackageElements.SEGMENTS, (MediaPackageReference)trackReference);
            Mpeg7Catalog mpeg7 = null;
            if (segmentCatalogs.length > 0) {
                mpeg7 = this.loadMpeg7Catalog(segmentCatalogs[0]);
                if (segmentCatalogs.length > 1) {
                    logger.warn("More than one segments catalog found for track {}. Resuming with the first one ({})", (Object)t, (Object)mpeg7);
                }
            } else {
                logger.debug("No segments catalog found for track {}", (Object)t);
                continue;
            }
            if (mpeg7.videoContent() == null || mpeg7.videoContent().next() == null) {
                logger.info("Segments catalog {} contains no video content", (Object)mpeg7);
                continue;
            }
            Video videoContent = (Video)mpeg7.videoContent().next();
            TemporalDecomposition decomposition = videoContent.getTemporalDecomposition();
            if (decomposition == null || !decomposition.hasSegments()) {
                logger.info("Segments catalog {} contains no video content", (Object)mpeg7);
                continue;
            }
            MediaPackageElement referenceMaster = this.getReferenceMaster(mediaPackage, t, referenceFlavor, referenceTagSet);
            if (!t.hasVideo() || mpeg7 == null) continue;
            Iterator segmentIterator = decomposition.segments();
            LinkedList<MediaTimePoint> timePointList = new LinkedList<MediaTimePoint>();
            while (segmentIterator.hasNext()) {
                Segment segment = (Segment)segmentIterator.next();
                MediaTimePoint tp = segment.getMediaTime().getMediaTimePoint();
                timePointList.add(tp);
            }
            double[] timeArray = new double[timePointList.size()];
            for (int i = 0; i < timePointList.size(); ++i) {
                timeArray[i] = (double)((MediaTimePoint)timePointList.get(i)).getTimeInMilliseconds() / 1000.0;
            }
            Job job = this.composerService.image(t, profile.getIdentifier(), timeArray);
            if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
                throw new WorkflowOperationException("Extracting preview image from " + t + " failed");
            }
            try {
                job = this.serviceRegistry.getJob(job.getId());
            }
            catch (ServiceRegistryException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            totalTimeInQueue += job.getQueueTime().longValue();
            List composedImages = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
            Iterator it = timePointList.iterator();
            for (MediaPackageElement element : composedImages) {
                Attachment composedImage = (Attachment)element;
                if (composedImage == null) {
                    throw new IllegalStateException("Unable to compose image");
                }
                if (targetImageFlavor != null) {
                    composedImage.setFlavor(MediaPackageElementFlavor.parseFlavor((String)targetImageFlavor));
                    logger.debug("Preview image has flavor '{}'", (Object)composedImage.getFlavor());
                }
                try {
                    composedImage.setMimeType(MimeTypes.fromURI((URI)composedImage.getURI()));
                }
                catch (UnknownFileTypeException e) {
                    logger.warn("Mime type unknown for file {}. Setting none.", (Object)composedImage.getURI(), (Object)e);
                }
                for (String tag : this.asList(targetImageTags)) {
                    logger.trace("Tagging image with '{}'", (Object)tag);
                    composedImage.addTag(tag);
                }
                MediaPackageReferenceImpl ref = new MediaPackageReferenceImpl(referenceMaster);
                ref.setProperty("time", ((MediaTimePoint)it.next()).toString());
                composedImage.setReference((MediaPackageReference)ref);
                mediaPackage.add(composedImage);
                String fileName = this.getFileNameFromElements((MediaPackageElement)t, (MediaPackageElement)composedImage);
                composedImage.setURI(this.workspace.moveTo(composedImage.getURI(), mediaPackage.getIdentifier().toString(), composedImage.getIdentifier(), fileName));
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
    }

    private MediaPackageElement getReferenceMaster(MediaPackage mediaPackage, Track t, String referenceFlavor, Collection<String> referenceTagSet) {
        Track referenceMaster = t;
        if (referenceFlavor != null) {
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)referenceFlavor);
            block0: for (Track e : mediaPackage.getTracks(flavor)) {
                MediaPackageReference ref = e.getReference();
                while (ref != null) {
                    MediaPackageElement tr = mediaPackage.getElementByReference(ref);
                    if (tr == null) break block0;
                    if (tr.equals(t)) {
                        boolean matches = true;
                        for (String tag : referenceTagSet) {
                            if (e.containsTag(tag)) continue;
                            matches = false;
                        }
                        if (matches) {
                            referenceMaster = e;
                            break block0;
                        }
                    }
                    ref = tr.getReference();
                }
            }
        }
        return referenceMaster;
    }

    protected Mpeg7Catalog loadMpeg7Catalog(Catalog catalog) throws IOException {
        Mpeg7Catalog mpeg7Catalog;
        FileInputStream in = null;
        try {
            File f = this.workspace.get(catalog.getURI());
            in = new FileInputStream(f);
            mpeg7Catalog = this.mpeg7CatalogService.load((InputStream)in);
        }
        catch (NotFoundException e) {
            try {
                throw new IOException("Unable to open catalog " + catalog + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return mpeg7Catalog;
    }
}

