/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationTagUtil;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStreamsWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SelectStreamsWorkflowOperationHandler.class);
    private static final String PREPARE_VIDEO_ONLY_PROFILE = "video-only.work";
    private static final String PREPARE_AUDIO_ONLY_PROFILE = "audio-only.work";
    private static final String MUX_AV_PROFILE = "mux-av.work";
    private ComposerService composerService = null;
    private Workspace workspace = null;
    private static final String CONFIG_AUDIO_MUXING = "audio-muxing";
    private static final String CONFIG_FORCE_TARGET = "force-target";
    private static final String FORCE_TARGET_DEFAULT = "presenter";

    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private EncodingProfile getProfile(String identifier) throws WorkflowOperationException {
        EncodingProfile profile = this.composerService.getProfile(identifier);
        if (profile == null) {
            throw new WorkflowOperationException(String.format("couldn't find encoding profile \"%s\"", identifier));
        }
        return profile;
    }

    private static Optional<String> getConfiguration(WorkflowInstance instance, String key) {
        return Optional.ofNullable(instance.getCurrentOperation().getConfiguration(key)).map(StringUtils::trimToNull);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        try {
            return this.doStart(workflowInstance);
        }
        catch (IOException | EncoderException | MediaPackageException | NotFoundException e) {
            throw new WorkflowOperationException(e);
        }
    }

    private WorkflowOperationResult doStart(WorkflowInstance workflowInstance) throws WorkflowOperationException, EncoderException, MediaPackageException, NotFoundException, IOException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        MediaPackageElementFlavor sourceFlavor = SelectStreamsWorkflowOperationHandler.getConfiguration(workflowInstance, "source-flavor").map(MediaPackageElementFlavor::parseFlavor).orElseThrow(() -> new IllegalStateException("Source flavor must be specified"));
        MediaPackageElementFlavor targetTrackFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.trimToNull((String)SelectStreamsWorkflowOperationHandler.getConfiguration(workflowInstance, "target-flavor").orElseThrow(() -> new IllegalStateException("Target flavor not specified"))));
        Track[] tracks = mediaPackage.getTracks(sourceFlavor);
        if (tracks.length == 0) {
            logger.info("No audio/video tracks with flavor '{}' found to prepare", (Object)sourceFlavor);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        List<AugmentedTrack> augmentedTracks = this.createAugmentedTracks(tracks, workflowInstance);
        MuxResult result = MuxResult.empty();
        if (this.allNonHidden(augmentedTracks, SubTrack.VIDEO)) {
            boolean multipleVideo;
            AudioMuxing audioMuxing = SelectStreamsWorkflowOperationHandler.getConfiguration(workflowInstance, CONFIG_AUDIO_MUXING).map(AudioMuxing::fromConfigurationString).orElse(AudioMuxing.NONE);
            Optional<AugmentedTrack> singleAudioTrackOpt = this.findSingleAudioTrack(augmentedTracks);
            boolean bl = multipleVideo = augmentedTracks.size() > 1;
            if (multipleVideo && audioMuxing == AudioMuxing.DUPLICATE && singleAudioTrackOpt.isPresent()) {
                logger.debug("Duplicate the audio stream of track {} into all tracks", (Object)singleAudioTrackOpt.get());
                AugmentedTrack singleAudioTrack = singleAudioTrackOpt.get();
                for (AugmentedTrack t2 : augmentedTracks) {
                    if (t2.track != singleAudioTrack.track) {
                        TrackJobResult jobResult = this.mux(t2.track, singleAudioTrack.track, mediaPackage);
                        result.add(jobResult);
                        continue;
                    }
                    result.add(this.copyTrack(t2.track));
                }
            } else if (multipleVideo && audioMuxing == AudioMuxing.FORCE && singleAudioTrackOpt.isPresent()) {
                logger.debug("Enforce audio stream to be present in track {} only", (Object)singleAudioTrackOpt.get());
                AugmentedTrack singleAudioTrack = singleAudioTrackOpt.get();
                String forceTargetOpt = SelectStreamsWorkflowOperationHandler.getConfiguration(workflowInstance, CONFIG_FORCE_TARGET).orElse(FORCE_TARGET_DEFAULT);
                Optional<AugmentedTrack> forceTargetTrackOpt = this.findTrackByFlavorType(augmentedTracks, forceTargetOpt);
                if (!forceTargetTrackOpt.isPresent()) {
                    throw new IllegalStateException(String.format("\"%s\" set to \"%s\", but target flavor \"%s\" not found!", new Object[]{CONFIG_AUDIO_MUXING, AudioMuxing.FORCE, forceTargetOpt}));
                }
                AugmentedTrack forceTargetTrack = forceTargetTrackOpt.get();
                if (singleAudioTrack.track != forceTargetTrack.track) {
                    TrackJobResult muxResult = this.mux(forceTargetTrack.track, singleAudioTrack.track, mediaPackage);
                    result.add(muxResult);
                    TrackJobResult hideAudioResult = this.hideAudio(singleAudioTrack.track, mediaPackage);
                    result.add(hideAudioResult);
                } else {
                    result.add(this.copyTrack(singleAudioTrack.track));
                }
                for (AugmentedTrack augmentedTrack : augmentedTracks) {
                    if (augmentedTrack.track == singleAudioTrack.track || augmentedTrack.track == forceTargetTrack.track) continue;
                    if (augmentedTrack.hasAudio() && augmentedTrack.hide(SubTrack.AUDIO)) {
                        TrackJobResult hideAudioResult = this.hideAudio(augmentedTrack.track, mediaPackage);
                        result.add(hideAudioResult);
                        continue;
                    }
                    result.add(this.copyTrack(augmentedTrack.track));
                }
            } else {
                MuxResult muxResult = this.muxMultipleVideoTracks(mediaPackage, augmentedTracks);
                result.add(muxResult);
            }
        } else if (this.allHidden(augmentedTracks, SubTrack.VIDEO)) {
            for (AugmentedTrack t3 : augmentedTracks) {
                if (!t3.hasAudio()) continue;
                if (t3.hide(SubTrack.VIDEO)) {
                    TrackJobResult hideVideoResult = this.hideVideo(t3.track, mediaPackage);
                    result.add(hideVideoResult);
                    continue;
                }
                result.add(this.copyTrack(t3.track));
            }
        } else {
            MuxResult muxResult = this.muxSingleVideoTrack(mediaPackage, augmentedTracks);
            result.add(muxResult);
        }
        result.forEachTrack(t -> {
            t.setFlavor(new MediaPackageElementFlavor(t.getFlavor().getType(), targetTrackFlavor.getSubtype()));
            mediaPackage.add(t);
        });
        SelectStreamsWorkflowOperationHandler.getConfiguration(workflowInstance, "target-tags").ifPresent(tags -> {
            WorkflowOperationTagUtil.TagDiff tagDiff = WorkflowOperationTagUtil.createTagDiff((String)tags);
            result.forEachTrack(t -> WorkflowOperationTagUtil.applyTagDiff((WorkflowOperationTagUtil.TagDiff)tagDiff, (Track)t));
        });
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, result.queueTime);
    }

    private Optional<AugmentedTrack> findTrackByFlavorType(Collection<AugmentedTrack> augmentedTracks, String flavorType) {
        return augmentedTracks.stream().filter(augmentedTrack -> augmentedTrack.getFlavorType().equals(flavorType)).findAny();
    }

    private MuxResult muxSingleVideoTrack(MediaPackage mediaPackage, Collection<AugmentedTrack> augmentedTracks) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, IOException {
        long queueTime = 0L;
        ArrayList<Track> resultingTracks = new ArrayList<Track>(0);
        AugmentedTrack nonHiddenVideo = this.findNonHidden(augmentedTracks, SubTrack.VIDEO).orElseThrow(() -> new IllegalStateException("couldn't find a stream with non-hidden video"));
        Optional<AugmentedTrack> nonHiddenAudio = this.findNonHidden(augmentedTracks, SubTrack.AUDIO);
        if (nonHiddenVideo.hasAudio() && nonHiddenVideo.hideAudio && (!nonHiddenAudio.isPresent() || nonHiddenAudio.get() == nonHiddenVideo)) {
            TrackJobResult jobResult = this.hideAudio(nonHiddenVideo.track, mediaPackage);
            resultingTracks.add(jobResult.track);
            queueTime += jobResult.waitTime;
        } else if (!nonHiddenAudio.isPresent() || nonHiddenAudio.get() == nonHiddenVideo) {
            Track clonedTrack = (Track)nonHiddenVideo.track.clone();
            clonedTrack.setIdentifier(null);
            resultingTracks.add(clonedTrack);
        } else {
            TrackJobResult jobResult = this.mux(nonHiddenVideo.track, nonHiddenAudio.get().track, mediaPackage);
            resultingTracks.add(jobResult.track);
            queueTime += jobResult.waitTime;
        }
        return new MuxResult(queueTime, resultingTracks);
    }

    private MuxResult muxMultipleVideoTracks(MediaPackage mediaPackage, Iterable<AugmentedTrack> augmentedTracks) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, IOException {
        long queueTime = 0L;
        ArrayList<Track> resultingTracks = new ArrayList<Track>(0);
        for (AugmentedTrack t : augmentedTracks) {
            if (t.hasAudio() && t.hideAudio) {
                MediaPackageElementFlavor previousFlavor = t.track.getFlavor();
                TrackJobResult trackJobResult = this.hideAudio(t.track, mediaPackage);
                trackJobResult.track.setFlavor(previousFlavor);
                resultingTracks.add(trackJobResult.track);
                queueTime += trackJobResult.waitTime;
                continue;
            }
            logger.debug("Add clone of track {} to mediapackage {}", (Object)t.track.getIdentifier(), (Object)mediaPackage.getIdentifier());
            Track clonedTrack = (Track)t.track.clone();
            clonedTrack.setIdentifier(null);
            resultingTracks.add(clonedTrack);
        }
        return new MuxResult(queueTime, resultingTracks);
    }

    private Optional<AugmentedTrack> findSingleAudioTrack(Iterable<AugmentedTrack> augmentedTracks) {
        AugmentedTrack result = null;
        for (AugmentedTrack augmentedTrack : augmentedTracks) {
            if (!augmentedTrack.hasAudio() || augmentedTrack.hideAudio) continue;
            if (result != null) {
                return Optional.empty();
            }
            result = augmentedTrack;
        }
        return Optional.ofNullable(result);
    }

    private TrackJobResult mux(Track videoTrack, Track audioTrack, MediaPackage mediaPackage) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, IOException {
        logger.info("Mux video track {} and audio track {}", (Object)videoTrack, (Object)audioTrack);
        EncodingProfile profile = this.getProfile(MUX_AV_PROFILE);
        Job job = this.composerService.mux(videoTrack, audioTrack, profile.getIdentifier());
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException(String.format("Muxing video track %s and audio track %s failed", videoTrack, audioTrack));
        }
        MediaPackageElementFlavor previousFlavor = videoTrack.getFlavor();
        TrackJobResult trackJobResult = this.processJob(videoTrack, mediaPackage, job);
        trackJobResult.track.setFlavor(previousFlavor);
        return trackJobResult;
    }

    private TrackJobResult hideVideo(Track track, MediaPackage mediaPackage) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, IOException {
        logger.info("Remove video streams from track {}", (Object)track.getIdentifier());
        return this.hide(PREPARE_AUDIO_ONLY_PROFILE, track, mediaPackage);
    }

    private TrackJobResult hideAudio(Track track, MediaPackage mediaPackage) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, IOException {
        logger.info("Remove audio streams from track {}", (Object)track.getIdentifier());
        return this.hide(PREPARE_VIDEO_ONLY_PROFILE, track, mediaPackage);
    }

    private TrackJobResult hide(String encodingProfile, Track track, MediaPackage mediaPackage) throws MediaPackageException, EncoderException, WorkflowOperationException, NotFoundException, IOException {
        EncodingProfile profile = this.getProfile(encodingProfile);
        Job job = this.composerService.encode(track, profile.getIdentifier());
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException(String.format("Rewriting container for video track %s failed", track));
        }
        MediaPackageElementFlavor previousFlavor = track.getFlavor();
        TrackJobResult trackJobResult = this.processJob(track, mediaPackage, job);
        trackJobResult.track.setFlavor(previousFlavor);
        return trackJobResult;
    }

    private TrackJobResult processJob(Track track, MediaPackage mediaPackage, Job job) throws MediaPackageException, NotFoundException, IOException {
        Track composedTrack = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
        String fileName = this.getFileNameFromElements((MediaPackageElement)track, (MediaPackageElement)composedTrack);
        composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
        return new TrackJobResult(composedTrack, job.getQueueTime());
    }

    private Optional<AugmentedTrack> findNonHidden(Collection<AugmentedTrack> augmentedTracks, SubTrack st) {
        return augmentedTracks.stream().filter(t -> t.has(st) && !t.hide(st)).findAny();
    }

    private boolean allNonHidden(Collection<AugmentedTrack> augmentedTracks, SubTrack st) {
        return augmentedTracks.stream().noneMatch(t -> !t.has(st) || t.hide(st));
    }

    private boolean allHidden(Collection<AugmentedTrack> augmentedTracks, SubTrack st) {
        return augmentedTracks.stream().noneMatch(t -> t.has(st) && !t.hide(st));
    }

    private static String constructHideProperty(String s, SubTrack st) {
        return "hide_" + s + "_" + st.toString().toLowerCase();
    }

    private boolean trackHidden(WorkflowInstance instance, String subtype, SubTrack st) {
        String hideProperty = instance.getConfiguration(SelectStreamsWorkflowOperationHandler.constructHideProperty(subtype, st));
        return Boolean.parseBoolean(hideProperty);
    }

    private List<AugmentedTrack> createAugmentedTracks(Track[] tracks, WorkflowInstance instance) {
        return Arrays.stream(tracks).map(t -> {
            boolean hideAudio = this.trackHidden(instance, t.getFlavor().getType(), SubTrack.AUDIO);
            boolean hideVideo = this.trackHidden(instance, t.getFlavor().getType(), SubTrack.VIDEO);
            AugmentedTrack result = new AugmentedTrack((Track)t, hideAudio, hideVideo);
            logger.debug("AugmentedTrack {}", (Object)result);
            return result;
        }).collect(Collectors.toList());
    }

    private TrackJobResult copyTrack(Track track) throws WorkflowOperationException {
        logger.debug("Create copy of track {}", (Object)track);
        Track copiedTrack = (Track)track.clone();
        copiedTrack.setIdentifier(UUID.randomUUID().toString());
        try {
            String targetFilename = copiedTrack.getIdentifier();
            String extension = FilenameUtils.getExtension((String)track.getURI().getPath());
            if (!extension.isEmpty()) {
                targetFilename = targetFilename + "." + extension;
            }
            URI newUri = this.workspace.put(track.getMediaPackage().getIdentifier().toString(), copiedTrack.getIdentifier(), targetFilename, this.workspace.read(track.getURI()));
            copiedTrack.setURI(newUri);
        }
        catch (IOException | NotFoundException e) {
            throw new WorkflowOperationException(String.format("Error while copying track %s", track.getIdentifier()), e);
        }
        return new TrackJobResult(copiedTrack, 0L);
    }

    private static final class TrackJobResult {
        private final Track track;
        private final long waitTime;

        private TrackJobResult(Track track, long waitTime) {
            this.track = track;
            this.waitTime = waitTime;
        }
    }

    private static final class AugmentedTrack {
        private final Track track;
        private final boolean hideAudio;
        private final boolean hideVideo;

        private AugmentedTrack(Track track, boolean hideAudio, boolean hideVideo) {
            this.track = track;
            this.hideAudio = hideAudio;
            this.hideVideo = hideVideo;
        }

        boolean has(SubTrack t) {
            if (t == SubTrack.AUDIO) {
                return this.hasAudio();
            }
            return this.hasVideo();
        }

        boolean hide(SubTrack t) {
            if (t == SubTrack.AUDIO) {
                return this.hideAudio;
            }
            return this.hideVideo;
        }

        boolean hasAudio() {
            return this.track.hasAudio();
        }

        boolean hasVideo() {
            return this.track.hasVideo();
        }

        String getFlavorType() {
            return this.track.getFlavor().getType();
        }

        public String toString() {
            return String.format("ID: %s, Flavor: %s [hasAudio %s, hideAudio %s, hasVideo %s, hideVideo: %s]", this.track.getIdentifier(), this.track.getFlavor(), this.hasAudio(), this.hide(SubTrack.AUDIO), this.hasVideo(), this.hide(SubTrack.VIDEO));
        }
    }

    private static final class MuxResult {
        private long queueTime;
        private final Collection<Track> tracks;

        private MuxResult(long queueTime, Collection<Track> tracks) {
            this.queueTime = queueTime;
            this.tracks = tracks;
        }

        static MuxResult empty() {
            return new MuxResult(0L, new ArrayList<Track>(0));
        }

        void forEachTrack(Consumer<Track> trackConsumer) {
            this.tracks.forEach(trackConsumer);
        }

        public void add(TrackJobResult jobResult) {
            this.queueTime += jobResult.waitTime;
            this.tracks.add(jobResult.track);
        }

        public void add(MuxResult muxResult) {
            this.queueTime += muxResult.queueTime;
            this.tracks.addAll(muxResult.tracks);
        }
    }

    private static enum SubTrack {
        AUDIO,
        VIDEO;

    }

    private static enum AudioMuxing {
        NONE,
        FORCE,
        DUPLICATE;


        public String toString() {
            return super.toString().toLowerCase();
        }

        static AudioMuxing fromConfigurationString(String s) {
            return AudioMuxing.valueOf(s.toUpperCase());
        }
    }
}

