/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.coverimage.impl.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.coverimage.CoverImageException;
import org.opencastproject.coverimage.CoverImageService;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="coverimage", title="Cover Image Service", abstractText="This endpoint triggers generation of cover images", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={CoverImageEndpoint.class}, property={"service.description=Cover Image Service REST Endpoint", "opencast.service.type=org.opencastproject.coverimage", "opencast.service.path=/cover-image", "opencast.service.jobproducer=true"})
public class CoverImageEndpoint
extends AbstractJobProducerEndpoint {
    private ServiceRegistry serviceRegistry;
    private CoverImageService coverImageService;
    private static final Logger logger = LoggerFactory.getLogger(CoverImageEndpoint.class);

    public JobProducer getService() {
        if (this.coverImageService instanceof JobProducer) {
            return (JobProducer)this.coverImageService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @POST
    @Path(value="generate")
    @Produces(value={"text/xml"})
    @RestQuery(name="generate", description="Generates a cover image based on the given metadata", restParameters={@RestParameter(description="Metadata XML", isRequired=false, name="xml", type=RestParameter.Type.TEXT), @RestParameter(description="XSLT stylesheet", isRequired=true, name="xsl", type=RestParameter.Type.TEXT), @RestParameter(description="Width of the cover image", isRequired=true, name="width", type=RestParameter.Type.INTEGER, defaultValue="1600"), @RestParameter(description="Height of the cover image", isRequired=true, name="height", type=RestParameter.Type.INTEGER, defaultValue="900"), @RestParameter(description="URI of poster image", isRequired=false, name="posterimage", type=RestParameter.Type.STRING), @RestParameter(description="Flavor of target cover image", isRequired=true, name="targetflavor", type=RestParameter.Type.STRING, defaultValue="image/cover")}, responses={@RestResponse(description="Results in an xml document containing the job for the cover image generation task", responseCode=200), @RestResponse(description="If required parameters aren't set or not valid", responseCode=400)}, returnDescription="")
    public Response generateCoverImage(@FormParam(value="xml") String xml, @FormParam(value="xsl") String xsl, @FormParam(value="width") String width, @FormParam(value="height") String height, @FormParam(value="posterimage") String posterFlavor, @FormParam(value="targetflavor") String targetFlavor) {
        try {
            Job job = this.coverImageService.generateCoverImage(xml, xsl, width, height, posterFlavor, targetFlavor);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (CoverImageException e) {
            logger.warn("Error while creating cover image job via REST endpoint: {}", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    protected void setCoverImageService(CoverImageService coverImageService) {
        this.coverImageService = coverImageService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        logger.info("Cover Image REST Endpoint started");
    }
}

