/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.dictionary.regexp;

import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.dictionary.api.DictionaryService;
import org.opencastproject.metadata.mpeg7.Textual;
import org.opencastproject.metadata.mpeg7.TextualImpl;
import org.opencastproject.util.ReadinessIndicator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryServiceImpl
implements DictionaryService,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    public static final String PATTERN_CONFIG_KEY = "pattern";
    private String pattern = "\\w+";
    private Pattern compilesPattern = Pattern.compile(this.pattern);

    public void setPattern(String p) {
        try {
            this.compilesPattern = Pattern.compile(p);
            this.pattern = p;
        }
        catch (RuntimeException e) {
            logger.error("Failed to compile pattern '{}'", (Object)p);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public synchronized void updated(Dictionary<String, ?> properties) {
        if (properties != null && properties.get(PATTERN_CONFIG_KEY) != null) {
            String pattern = properties.get(PATTERN_CONFIG_KEY).toString();
            try {
                pattern = new String(pattern.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("Error decoding pattern string");
            }
            logger.info("Setting pattern for regexp based DictionaryService to '{}'", (Object)pattern);
            this.setPattern(pattern);
        }
    }

    void activate(BundleContext ctx) {
        logger.info("Activating regexp based DictionaryService");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("artifact", "dictionary");
        ctx.registerService(ReadinessIndicator.class.getName(), (Object)new ReadinessIndicator(), properties);
    }

    public Textual cleanUpText(String text) {
        logger.debug("Text input: \u201c{}\u201d", (Object)text);
        LinkedList<String> words = new LinkedList<String>();
        Matcher matcher = this.compilesPattern.matcher(text);
        while (matcher.find()) {
            words.add(matcher.group());
        }
        String result = StringUtils.join(words, (String)" ");
        logger.debug("Resulting text: \u201c{}\u201d", (Object)result);
        if ("".equals(result)) {
            return null;
        }
        return new TextualImpl(result);
    }
}

