/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.io.Serializable;
import java.util.Date;

public final class DCMIPeriod {
    private final Date start;
    private final Date end;
    private final String name;

    public DCMIPeriod(Date start, Date end) {
        this(start, end, null);
    }

    public DCMIPeriod(Date start, Date end, String name) {
        if (start == null && end == null) {
            throw new IllegalStateException("A period must be bounded at least at one end");
        }
        if (start != null && end != null && end.before(start)) {
            throw new IllegalStateException("The end date is before the start date");
        }
        this.start = start;
        this.end = end;
        this.name = name;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClosed() {
        return this.start != null && this.end != null;
    }

    public boolean hasStart() {
        return this.start != null;
    }

    public boolean hasEnd() {
        return this.end != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String toString() {
        return "DCMIPeriod{start=" + (Serializable)(this.start != null ? this.start : "]") + ", end=" + (Serializable)(this.end != null ? this.end : "[") + (String)(this.name != null ? ", name='" + this.name + "'" : "") + "}";
    }
}

