/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.Fns;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.ImmutableSetWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.XMLCatalogImpl;
import org.opencastproject.metadata.api.MetadataCatalog;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreJsonFormat;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.XmlNamespaceContext;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Function2;
import org.opencastproject.util.data.Monadics;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

@ParametersAreNonnullByDefault
public class DublinCoreCatalog
extends XMLCatalogImpl
implements DublinCore,
MetadataCatalog,
Cloneable {
    private static final long serialVersionUID = -4568663918115847488L;
    public static final MediaPackageElementFlavor ANY_DUBLINCORE = MediaPackageElementFlavor.parseFlavor((String)"dublincore/*");
    private EName rootTag;
    private final Function<XMLCatalogImpl.CatalogEntry, DublinCoreValue> toDublinCoreValue = new Function<XMLCatalogImpl.CatalogEntry, DublinCoreValue>(){

        public DublinCoreValue apply(XMLCatalogImpl.CatalogEntry e) {
            return DublinCoreCatalog.this.toDublinCoreValue(e);
        }
    };

    DublinCoreCatalog() {
    }

    public void setRootTag(EName rootTag) {
        this.rootTag = rootTag;
    }

    @Nullable
    public EName getRootTag() {
        return this.rootTag;
    }

    public void addBindings(XmlNamespaceContext ctx) {
        this.bindings = this.bindings.add(ctx);
    }

    public String toString() {
        return "DublinCore" + (String)(this.getIdentifier() != null ? "(" + this.getIdentifier() + ")" : "");
    }

    @Override
    public List<String> get(EName property, final String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)language, (String)"language");
        if ("**".equals(language)) {
            return (List)CollectionUtils.collect((Iterable)this.getValuesAsList(property), (Transformer)new Transformer(){

                public Object transform(Object o) {
                    return ((XMLCatalogImpl.CatalogEntry)o).getValue();
                }
            });
        }
        final ArrayList<String> values = new ArrayList<String>();
        final boolean langUndef = "__".equals(language);
        CollectionUtils.forAllDo((Iterable)this.getValuesAsList(property), (Closure)new Closure(){

            public void execute(Object o) {
                XMLCatalogImpl.CatalogEntry c = (XMLCatalogImpl.CatalogEntry)o;
                String lang = c.getAttribute(XMLCatalogImpl.XML_LANG_ATTR);
                if (langUndef && lang == null || language.equals(lang)) {
                    values.add(c.getValue());
                }
            }
        });
        return values;
    }

    @Override
    public List<DublinCoreValue> get(EName property) {
        RequireUtil.notNull((Object)property, (String)"property");
        return Monadics.mlist((List)this.getValuesAsList(property)).map(this.toDublinCoreValue).value();
    }

    private DublinCoreValue toDublinCoreValue(XMLCatalogImpl.CatalogEntry e) {
        String langRaw = e.getAttribute(XML_LANG_ATTR);
        String lang = langRaw != null ? langRaw : "__";
        String typeRaw = e.getAttribute(XSI_TYPE_ATTR);
        if (typeRaw != null) {
            return DublinCoreValue.mk(e.getValue(), lang, this.toEName(typeRaw));
        }
        return DublinCoreValue.mk(e.getValue(), lang);
    }

    @Override
    public Map<EName, List<DublinCoreValue>> getValues() {
        return (Map)Monadics.mlist(this.data.values().iterator()).foldl(new HashMap(), (Function2)new Function2<HashMap<EName, List<DublinCoreValue>>, List<XMLCatalogImpl.CatalogEntry>, HashMap<EName, List<DublinCoreValue>>>(){

            public HashMap<EName, List<DublinCoreValue>> apply(HashMap<EName, List<DublinCoreValue>> map, List<XMLCatalogImpl.CatalogEntry> entries) {
                if (entries.size() > 0) {
                    EName property = entries.get(0).getEName();
                    map.put(property, Monadics.mlist(entries).map(DublinCoreCatalog.this.toDublinCoreValue).value());
                }
                return map;
            }
        });
    }

    @Override
    public List<DublinCoreValue> getValuesFlat() {
        return Stream.$(this.data.values()).bind(Fns.id()).map(this.toDublinCoreValue.toFn()).toList();
    }

    @Override
    @Nullable
    public String getFirst(EName property, String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)language, (String)"language");
        XMLCatalogImpl.CatalogEntry f = this.getFirstCatalogEntry(property, language);
        return f != null ? f.getValue() : null;
    }

    @Override
    public String getFirst(EName property) {
        RequireUtil.notNull((Object)property, (String)"property");
        XMLCatalogImpl.CatalogEntry f = this.getFirstCatalogEntry(property, "**");
        return f != null ? f.getValue() : null;
    }

    @Override
    public DublinCoreValue getFirstVal(EName property) {
        XMLCatalogImpl.CatalogEntry f = this.getFirstCatalogEntry(property, "**");
        return f != null ? this.toDublinCoreValue(f) : null;
    }

    private XMLCatalogImpl.CatalogEntry getFirstCatalogEntry(EName property, String language) {
        XMLCatalogImpl.CatalogEntry entry = null;
        block4 : switch (language) {
            case "__": {
                entry = this.getFirstLocalizedValue(property, null);
                break;
            }
            case "**": {
                Iterator iterator = this.getValuesAsList(property).iterator();
                while (iterator.hasNext()) {
                    XMLCatalogImpl.CatalogEntry value;
                    entry = value = (XMLCatalogImpl.CatalogEntry)iterator.next();
                    if (value.hasAttribute(XML_LANG_ATTR)) continue;
                    break block4;
                }
                break;
            }
            default: {
                entry = this.getFirstLocalizedValue(property, language);
            }
        }
        return entry;
    }

    @Override
    public String getAsText(EName property, String language, String delimiter) {
        List values;
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)language, (String)"language");
        RequireUtil.notNull((Object)delimiter, (String)"delimiter");
        switch (language) {
            case "__": {
                values = this.getLocalizedValuesAsList(property, null);
                break;
            }
            case "**": {
                values = this.getValuesAsList(property);
                break;
            }
            default: {
                values = this.getLocalizedValuesAsList(property, language);
            }
        }
        return values.size() > 0 ? Stream.$((Iterable)values).mkString(delimiter) : null;
    }

    @Override
    public Set<String> getLanguages(EName property) {
        RequireUtil.notNull((Object)property, (String)"property");
        HashSet<String> languages = new HashSet<String>();
        for (XMLCatalogImpl.CatalogEntry entry : this.getValuesAsList(property)) {
            String language = entry.getAttribute(XML_LANG_ATTR);
            if (language != null) {
                languages.add(language);
                continue;
            }
            languages.add("__");
        }
        return languages;
    }

    @Override
    public boolean hasMultipleValues(EName property, String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)language, (String)"language");
        return this.hasMultiplePropertyValues(property, language);
    }

    @Override
    public boolean hasMultipleValues(EName property) {
        RequireUtil.notNull((Object)property, (String)"property");
        return this.hasMultiplePropertyValues(property, "**");
    }

    private boolean hasMultiplePropertyValues(EName property, String language) {
        if ("**".equals(language)) {
            return this.getValuesAsList(property).size() > 1;
        }
        int counter = 0;
        for (XMLCatalogImpl.CatalogEntry entry : this.getValuesAsList(property)) {
            if (this.equalLanguage(language, entry.getAttribute(XML_LANG_ATTR))) {
                ++counter;
            }
            if (counter <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasValue(EName property, String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)language, (String)"language");
        return this.hasPropertyValue(property, language);
    }

    @Override
    public boolean hasValue(EName property) {
        RequireUtil.notNull((Object)property, (String)"property");
        return this.hasPropertyValue(property, "**");
    }

    private boolean hasPropertyValue(EName property, final String language) {
        if ("**".equals(language)) {
            return this.getValuesAsList(property).size() > 0;
        }
        return CollectionUtils.find((Iterable)this.getValuesAsList(property), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                return DublinCoreCatalog.this.equalLanguage(((XMLCatalogImpl.CatalogEntry)o).getAttribute(XMLCatalogImpl.XML_LANG_ATTR), language);
            }
        }) != null;
    }

    @Override
    public void set(EName property, @Nullable String value, String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        if (language == null || "**".equals(language)) {
            throw new IllegalArgumentException("Language code may not be null or LANGUAGE_ANY");
        }
        this.setValue(property, value, language, null);
    }

    @Override
    public void set(EName property, String value) {
        RequireUtil.notNull((Object)property, (String)"property");
        this.setValue(property, value, "__", null);
    }

    @Override
    public void set(EName property, @Nullable DublinCoreValue value) {
        RequireUtil.notNull((Object)property, (String)"property");
        if (value != null) {
            this.setValue(property, value.getValue(), value.getLanguage(), (EName)value.getEncodingScheme().orNull());
        } else {
            this.removeValue(property, "**");
        }
    }

    @Override
    public void set(EName property, List<DublinCoreValue> values) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull(values, (String)"values");
        this.removeValue(property, "**");
        for (DublinCoreValue v : values) {
            this.add(property, v);
        }
    }

    private void setValue(EName property, @Nullable String value, String language, @Nullable EName encodingScheme) {
        if (value == null) {
            this.removeValue(property, language);
        } else {
            String lang = !"__".equals(language) ? language : null;
            this.removeLocalizedValues(property, lang);
            this.add(property, value, language, encodingScheme);
        }
    }

    @Override
    public void add(EName property, String value) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)value, (String)"value");
        this.add(property, value, "__", null);
    }

    @Override
    public void add(EName property, String value, String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)value, (String)"value");
        if (language == null || "**".equals(language)) {
            throw new IllegalArgumentException("Language code may not be null or LANGUAGE_ANY");
        }
        this.add(property, value, language, null);
    }

    @Override
    public void add(EName property, DublinCoreValue value) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)value, (String)"value");
        this.add(property, value.getValue(), value.getLanguage(), (EName)value.getEncodingScheme().orNull());
    }

    void add(EName property, String value, String language, @Nullable EName encodingScheme) {
        if ("__".equals(language) && !property.equals((Object)this.rootTag)) {
            if (encodingScheme == null) {
                this.addElement(property, value);
            } else {
                this.addTypedElement(property, value, encodingScheme);
            }
        } else if (encodingScheme == null) {
            this.addLocalizedElement(property, value, language);
        } else {
            this.addTypedLocalizedElement(property, value, language, encodingScheme);
        }
    }

    @Override
    public void remove(EName property, String language) {
        RequireUtil.notNull((Object)property, (String)"property");
        RequireUtil.notNull((Object)language, (String)"language");
        this.removeValue(property, language);
    }

    @Override
    public void remove(EName property) {
        RequireUtil.notNull((Object)property, (String)"property");
        this.removeValue(property, "**");
    }

    private void removeValue(EName property, String language) {
        switch (language) {
            case "**": {
                this.removeElement(property);
                break;
            }
            case "__": {
                this.removeLocalizedValues(property, null);
                break;
            }
            default: {
                this.removeLocalizedValues(property, language);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
    }

    public Object clone() {
        DublinCoreCatalog clone = new DublinCoreCatalog();
        clone.setIdentifier(this.getIdentifier());
        clone.setFlavor(this.getFlavor());
        clone.setSize(this.getSize());
        clone.setChecksum(this.getChecksum());
        clone.bindings = this.bindings;
        clone.rootTag = this.rootTag;
        for (Map.Entry entry : this.data.entrySet()) {
            EName elmName = (EName)entry.getKey();
            EName elmNameCopy = new EName(elmName.getNamespaceURI(), elmName.getLocalName());
            ArrayList<XMLCatalogImpl.CatalogEntry> elmsCopy = new ArrayList<XMLCatalogImpl.CatalogEntry>();
            for (XMLCatalogImpl.CatalogEntry catalogEntry : (List)entry.getValue()) {
                elmsCopy.add(new XMLCatalogImpl.CatalogEntry((XMLCatalogImpl)this, catalogEntry.getEName(), catalogEntry.getValue(), catalogEntry.getAttributes()));
            }
            clone.data.put(elmNameCopy, elmsCopy);
        }
        return clone;
    }

    @Override
    public Set<EName> getProperties() {
        return new ImmutableSetWrapper(this.data.keySet());
    }

    boolean equalLanguage(String a, String b) {
        return a == null && EqualsUtil.eq((Object)b, (Object)"__") || b == null && EqualsUtil.eq((Object)a, (Object)"__") || EqualsUtil.eq((Object)a, (Object)"**") || EqualsUtil.eq((Object)b, (Object)"**") || a != null && EqualsUtil.eq((Object)a, (Object)b);
    }

    public EName toEName(String qName) {
        return super.toEName(qName);
    }

    @Nonnull
    public String toQName(EName eName) {
        return super.toQName(eName);
    }

    public void addElement(EName element, String value, Attributes attributes) {
        if (!this.rootTag.equals((Object)element)) {
            super.addElement(element, value, attributes);
        }
    }

    public XMLCatalogImpl.CatalogEntry[] getValues(EName element) {
        return super.getValues(element);
    }

    public List<XMLCatalogImpl.CatalogEntry> getEntriesSorted() {
        return super.getEntriesSorted();
    }

    public Document toXml() throws ParserConfigurationException, TransformerException, IOException {
        return DublinCoreXmlFormat.writeDocument(this);
    }

    public String toJson() throws IOException {
        return DublinCoreJsonFormat.writeJsonObject(this).toJSONString();
    }
}

