/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreJsonFormat;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DublinCoreCatalogList {
    private List<DublinCoreCatalog> catalogList = new LinkedList<DublinCoreCatalog>();
    private long totalCatalogCount = 0L;
    private static final Logger logger = LoggerFactory.getLogger(DublinCoreCatalogList.class);

    public DublinCoreCatalogList(List<DublinCoreCatalog> catalogs, long totalCount) {
        if (totalCount < (long)catalogs.size()) {
            throw new IllegalArgumentException("total count is less than the number of catalogs passed");
        }
        this.catalogList.addAll(catalogs);
        this.totalCatalogCount = totalCount;
    }

    public List<DublinCoreCatalog> getCatalogList() {
        return new LinkedList<DublinCoreCatalog>(this.catalogList);
    }

    public long getTotalCount() {
        return this.totalCatalogCount;
    }

    public long size() {
        return this.catalogList.size();
    }

    public String getResultsAsXML() throws IOException {
        try {
            DocumentBuilder builder = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document doc = impl.createDocument(null, null, null);
            Element root = doc.createElement("dublincorelist");
            root.setAttribute("totalCount", String.valueOf(this.totalCatalogCount));
            doc.appendChild(root);
            for (DublinCoreCatalog series : this.catalogList) {
                Node node = doc.importNode(series.toXml().getDocumentElement(), true);
                root.appendChild(node);
            }
            Transformer tf = XmlSafeParser.newTransformerFactory().newTransformer();
            DOMSource xmlSource = new DOMSource(doc);
            StringWriter out = new StringWriter();
            tf.transform(xmlSource, new StreamResult(out));
            return out.toString();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DublinCoreCatalogList parse(String dcString) throws IOException {
        DublinCoreCatalogList dublinCoreCatalogList;
        ArrayList<DublinCoreCatalog> catalogs = new ArrayList<DublinCoreCatalog>();
        if (dcString.startsWith("{")) {
            try {
                JSONObject json = (JSONObject)new JSONParser().parse(dcString);
                long totalCount = Long.parseLong((String)json.get((Object)"totalCount"));
                JSONArray catalogsArray = (JSONArray)json.get((Object)"catalogs");
                for (Object catalog : catalogsArray) {
                    catalogs.add(DublinCoreJsonFormat.read((JSONObject)catalog));
                }
                return new DublinCoreCatalogList(catalogs, totalCount);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load dublin core catalog list, json parsing failed.", e);
            }
        }
        InputStream is = null;
        try {
            DocumentBuilderFactory docBuilderFactory = XmlSafeParser.newDocumentBuilderFactory();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            is = IOUtils.toInputStream((String)dcString, (String)"UTF-8");
            Document document = docBuilder.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Number totalCount = (Number)xPath.evaluate("/*[local-name() = 'dublincorelist']/@totalCount", document, XPathConstants.NUMBER);
            NodeList nodes = (NodeList)xPath.evaluate("//*[local-name() = 'dublincore']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                InputStream nodeIs = null;
                try {
                    nodeIs = DublinCoreCatalogList.nodeToString(nodes.item(i));
                    catalogs.add(DublinCoreXmlFormat.read(nodeIs));
                }
                catch (Throwable throwable) {
                    IoSupport.closeQuietly(nodeIs);
                    throw throwable;
                }
                IoSupport.closeQuietly((Closeable)nodeIs);
            }
            dublinCoreCatalogList = new DublinCoreCatalogList(catalogs, totalCount.longValue());
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(is);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Closeable)is);
        return dublinCoreCatalogList;
    }

    private static InputStream nodeToString(Node node) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Transformer t = XmlSafeParser.newTransformerFactory().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(outputStream));
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerException te) {
            logger.warn("nodeToString Transformer Exception", (Throwable)te);
            return null;
        }
    }

    public String getResultsAsJson() {
        JSONObject jsonObj = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (DublinCoreCatalog catalog : this.catalogList) {
            jsonArray.add((Object)DublinCoreJsonFormat.writeJsonObject(catalog));
        }
        jsonObj.put((Object)"totalCount", (Object)String.valueOf(this.totalCatalogCount));
        jsonObj.put((Object)"catalogs", (Object)jsonArray);
        return jsonObj.toJSONString();
    }
}

