/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.Stream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.metadata.api.CatalogService;
import org.opencastproject.metadata.api.MediaPackageMetadata;
import org.opencastproject.metadata.api.MediaPackageMetadataService;
import org.opencastproject.metadata.api.MediapackageMetadataImpl;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Dublin Core Catalog Service", "priority=1"}, immediate=true, service={CatalogService.class, MediaPackageMetadataService.class, DublinCoreCatalogService.class})
public class DublinCoreCatalogService
implements CatalogService<DublinCoreCatalog>,
MediaPackageMetadataService {
    private static final Logger logger = LoggerFactory.getLogger(DublinCoreCatalogService.class);
    protected int priority = 0;
    protected Workspace workspace = null;
    public static final Comparator<Catalog> COMPARE_BY_FLAVOR = new Comparator<Catalog>(){

        @Override
        public int compare(Catalog c1, Catalog c2) {
            if (MediaPackageElements.EPISODE.equals((Object)c1.getFlavor())) {
                return 1;
            }
            return -1;
        }
    };

    @Reference(name="workspace")
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Activate
    public void activate(Map<String, ?> properties) {
        String priorityString;
        logger.debug("activate()");
        if (properties != null && (priorityString = (String)properties.get("priority")) != null) {
            try {
                this.priority = Integer.parseInt(priorityString);
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to set priority to {}", (Object)priorityString);
                throw e;
            }
        }
    }

    public InputStream serialize(DublinCoreCatalog catalog) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        catalog.toXml((OutputStream)out, true);
        return new ByteArrayInputStream(out.toByteArray());
    }

    public MediaPackageMetadata getMetadata(MediaPackage mp) {
        MediapackageMetadataImpl metadata = new MediapackageMetadataImpl();
        for (Catalog catalog : Stream.$((Object[])mp.getCatalogs(DublinCoreCatalog.ANY_DUBLINCORE)).sort(COMPARE_BY_FLAVOR)) {
            DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore(this.workspace, (MediaPackageElement)catalog);
            if (MediaPackageElements.EPISODE.equals((Object)catalog.getFlavor())) {
                metadata.setTitle(dc.getFirst(DublinCore.PROPERTY_TITLE));
                if (dc.hasValue(DublinCore.PROPERTY_TEMPORAL) && dc.getFirst(DublinCore.PROPERTY_TEMPORAL) != null) {
                    DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod(dc.getFirst(DublinCore.PROPERTY_TEMPORAL));
                    metadata.setDate(period.getStart());
                } else if (dc.hasValue(DublinCore.PROPERTY_CREATED)) {
                    metadata.setDate(EncodingSchemeUtils.decodeDate(dc.get(DublinCore.PROPERTY_CREATED).get(0)));
                }
                if (dc.hasValue(DublinCore.PROPERTY_IS_PART_OF)) {
                    metadata.setSeriesIdentifier(dc.get(DublinCore.PROPERTY_IS_PART_OF).get(0).getValue());
                }
                if (dc.hasValue(DublinCore.PROPERTY_CREATOR)) {
                    ArrayList<String> creators = new ArrayList<String>();
                    for (DublinCoreValue creator : dc.get(DublinCore.PROPERTY_CREATOR)) {
                        creators.add(creator.getValue());
                    }
                    metadata.setCreators(creators.toArray(new String[creators.size()]));
                }
                if (dc.hasValue(DublinCore.PROPERTY_CONTRIBUTOR)) {
                    ArrayList<String> contributors = new ArrayList<String>();
                    for (DublinCoreValue contributor : dc.get(DublinCore.PROPERTY_CONTRIBUTOR)) {
                        contributors.add(contributor.getValue());
                    }
                    metadata.setContributors(contributors.toArray(new String[contributors.size()]));
                }
                if (dc.hasValue(DublinCore.PROPERTY_SUBJECT)) {
                    ArrayList<String> subjects = new ArrayList<String>();
                    for (DublinCoreValue subject : dc.get(DublinCore.PROPERTY_SUBJECT)) {
                        subjects.add(subject.getValue());
                    }
                    metadata.setSubjects(subjects.toArray(new String[subjects.size()]));
                }
                metadata.setLicense(dc.getFirst(DublinCore.PROPERTY_LICENSE));
                metadata.setLanguage(dc.getFirst(DublinCore.PROPERTY_LANGUAGE));
                continue;
            }
            if (MediaPackageElements.SERIES.equals((Object)catalog.getFlavor())) {
                metadata.setSeriesTitle(dc.getFirst(DublinCore.PROPERTY_TITLE));
                metadata.setSeriesIdentifier(dc.getFirst(DublinCore.PROPERTY_IDENTIFIER));
                continue;
            }
            logger.debug("Excluding unknown catalog flavor '{}' from the top level metadata of mediapackage '{}'", (Object)catalog.getFlavor(), (Object)mp.getIdentifier());
        }
        return metadata;
    }

    public DublinCoreCatalog load(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Stream must not be null");
        }
        return DublinCores.read(in);
    }

    public DublinCoreCatalog newInstance() {
        return DublinCores.mkOpencastEpisode().getCatalog();
    }

    public int getPriority() {
        return this.priority;
    }
}

