/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.data.Opt;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;

@ParametersAreNonnullByDefault
public final class DublinCoreJsonFormat {
    private DublinCoreJsonFormat() {
    }

    @Nonnull
    public static DublinCoreCatalog read(String json) throws IOException, ParseException {
        return DublinCoreJsonFormat.read((JSONObject)new JSONParser().parse(json));
    }

    @Nonnull
    public static DublinCoreCatalog read(JSONObject json) {
        DublinCoreCatalog dc = DublinCores.mkStandard();
        Set namespaceEntrySet = json.entrySet();
        for (Map.Entry namespaceEntry : namespaceEntrySet) {
            String namespace = (String)namespaceEntry.getKey();
            JSONObject namespaceObj = (JSONObject)namespaceEntry.getValue();
            Set entrySet = namespaceObj.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                JSONArray values = (JSONArray)entry.getValue();
                for (Object valueObject : values) {
                    JSONObject value = (JSONObject)valueObject;
                    String valueString = (String)value.get((Object)"value");
                    String l = (String)value.get((Object)"lang");
                    String lang = l != null ? l : "__";
                    String s = (String)value.get((Object)"type");
                    EName encodingScheme = s != null ? dc.toEName(s) : null;
                    dc.add(new EName(namespace, key), valueString, lang, encodingScheme);
                }
            }
        }
        return dc;
    }

    @Nonnull
    public static JSONObject writeJsonObject(DublinCoreCatalog dc) {
        JSONObject json = new JSONObject();
        TreeSet<String> namespaces = new TreeSet<String>();
        Set<Map.Entry<EName, List<DublinCoreValue>>> values = dc.getValues().entrySet();
        for (Map.Entry<EName, List<DublinCoreValue>> entry : values) {
            namespaces.add(entry.getKey().getNamespaceURI());
        }
        for (String string : namespaces) {
            json.put((Object)string, (Object)new JSONObject());
        }
        for (Map.Entry<Object, List<DublinCoreValue>> entry : values) {
            JSONArray localNameArray;
            EName ename = (EName)entry.getKey();
            String namespace = ename.getNamespaceURI();
            String localName = ename.getLocalName();
            JSONObject namespaceObject = (JSONObject)json.get((Object)namespace);
            JSONArray ns = (JSONArray)namespaceObject.get((Object)localName);
            if (ns != null) {
                localNameArray = ns;
            } else {
                localNameArray = new JSONArray();
                namespaceObject.put((Object)localName, (Object)localNameArray);
            }
            for (DublinCoreValue value : entry.getValue()) {
                String lang = value.getLanguage();
                Opt<EName> encScheme = value.getEncodingScheme();
                JSONObject v = new JSONObject();
                v.put((Object)"value", (Object)value.getValue());
                if (Equality.ne((Object)"__", (Object)lang)) {
                    v.put((Object)"lang", (Object)lang);
                }
                for (EName e : encScheme) {
                    v.put((Object)"type", (Object)dc.toQName(e));
                }
                localNameArray.add((Object)v);
            }
        }
        return json;
    }
}

