/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DublinCoreMetadataCollection {
    private static final Logger logger = LoggerFactory.getLogger(DublinCoreMetadataCollection.class);
    private List<MetadataField> fieldsInOrder = new ArrayList<MetadataField>();
    private final Map<String, MetadataField> outputFields = new HashMap<String, MetadataField>();

    public DublinCoreMetadataCollection() {
        this(Collections.emptyList());
    }

    public DublinCoreMetadataCollection(Iterable<MetadataField> fields) {
        for (MetadataField field : fields) {
            this.addField(field);
        }
    }

    public DublinCoreMetadataCollection(DublinCoreMetadataCollection c) {
        this(c.fieldsInOrder);
    }

    public DublinCoreMetadataCollection readOnlyCopy() {
        return new DublinCoreMetadataCollection(this.fieldsInOrder.stream().map(MetadataField::readOnlyCopy).collect(Collectors.toList()));
    }

    public Map<String, MetadataField> getOutputFields() {
        return this.outputFields;
    }

    public void addField(MetadataField metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("The metadata must not be null.");
        }
        this.addFieldInOrder(metadata);
        this.outputFields.put(metadata.getOutputID(), metadata);
    }

    private void addFieldInOrder(MetadataField metadata) {
        this.removeFieldIfExists(metadata);
        ArrayList<MetadataField> orderedFields = new ArrayList<MetadataField>();
        ArrayList<MetadataField> unorderedFields = new ArrayList<MetadataField>();
        for (MetadataField field : this.fieldsInOrder) {
            if (field.getOrder() != null) {
                orderedFields.add(field);
                continue;
            }
            unorderedFields.add(field);
        }
        if (metadata.getOrder() != null) {
            orderedFields.add(metadata);
        } else {
            unorderedFields.add(metadata);
        }
        orderedFields.sort(Comparator.comparingInt(MetadataField::getOrder));
        this.fieldsInOrder = new ArrayList<MetadataField>(unorderedFields);
        for (MetadataField orderedField : orderedFields) {
            int index = orderedField.getOrder() < this.fieldsInOrder.size() ? orderedField.getOrder().intValue() : this.fieldsInOrder.size();
            this.fieldsInOrder.add(index, orderedField);
        }
    }

    public void addEmptyField(MetadataField metadataField, ListProvidersService listProvidersService) {
        this.addField(metadataField, Collections.emptyList(), listProvidersService);
    }

    public void addField(MetadataField metadataField, String value, ListProvidersService listProvidersService) {
        this.addField(metadataField, Collections.singletonList(value), listProvidersService);
    }

    private static void setValueFromDCCatalog(List<String> filteredValues, MetadataField metadataField) {
        if (filteredValues.isEmpty()) {
            throw new IllegalArgumentException("Values cannot be empty");
        }
        if (filteredValues.size() > 1 && metadataField.getType() != MetadataField.Type.MIXED_TEXT && metadataField.getType() != MetadataField.Type.ITERABLE_TEXT) {
            logger.warn("Cannot put multiple values into a single-value field, only the last value is used. {}", (Object)Arrays.toString(filteredValues.toArray()));
        }
        switch (metadataField.getType()) {
            case BOOLEAN: {
                metadataField.setValue(Boolean.parseBoolean((String)Iterables.getLast(filteredValues)), false);
                break;
            }
            case DATE: {
                if (metadataField.getPattern() == null) {
                    metadataField.setPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                }
                metadataField.setValue(EncodingSchemeUtils.decodeDate((String)Iterables.getLast(filteredValues)), false);
                break;
            }
            case DURATION: {
                String value = (String)Iterables.getLast(filteredValues);
                DCMIPeriod period = EncodingSchemeUtils.decodePeriod(value);
                if (period == null) {
                    throw new IllegalArgumentException("period couldn't be parsed: " + value);
                }
                long longValue = period.getEnd().getTime() - period.getStart().getTime();
                metadataField.setValue(Long.toString(longValue), false);
                break;
            }
            case ITERABLE_TEXT: 
            case MIXED_TEXT: {
                metadataField.setValue(filteredValues, false);
                break;
            }
            case LONG: {
                metadataField.setValue(Long.parseLong((String)Iterables.getLast(filteredValues)), false);
                break;
            }
            case START_DATE: {
                if (metadataField.getPattern() == null) {
                    metadataField.setPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                }
                metadataField.setValue(Iterables.getLast(filteredValues), false);
                break;
            }
            case TEXT: 
            case ORDERED_TEXT: 
            case TEXT_LONG: {
                metadataField.setValue(Iterables.getLast(filteredValues), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown metadata type! " + metadataField.getType());
            }
        }
    }

    public void addField(MetadataField metadataField, List<String> values, ListProvidersService listProvidersService) {
        List<String> filteredValues = values.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (!filteredValues.isEmpty()) {
            DublinCoreMetadataCollection.setValueFromDCCatalog(filteredValues, metadataField);
        }
        metadataField.setIsTranslatable(DublinCoreMetadataCollection.getCollectionIsTranslatable(metadataField, listProvidersService));
        metadataField.setCollection(DublinCoreMetadataCollection.getCollection(metadataField, listProvidersService));
        this.addField(metadataField);
    }

    private static Boolean getCollectionIsTranslatable(MetadataField metadataField, ListProvidersService listProvidersService) {
        if (listProvidersService != null && metadataField.getListprovider() != null) {
            try {
                return listProvidersService.isTranslatable(metadataField.getListprovider());
            }
            catch (ListProviderException listProviderException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Map<String, String> getCollection(MetadataField metadataField, ListProvidersService listProvidersService) {
        try {
            if (listProvidersService != null && metadataField.getListprovider() != null) {
                return listProvidersService.getList(metadataField.getListprovider(), (ResourceListQuery)new ResourceListQueryImpl(), true);
            }
            return null;
        }
        catch (ListProviderException e) {
            logger.warn("Unable to set collection on metadata because", (Throwable)e);
            return null;
        }
    }

    private void removeFieldIfExists(MetadataField metadata) {
        int index = -1;
        for (MetadataField field : this.fieldsInOrder) {
            if (!field.getInputID().equalsIgnoreCase(metadata.getInputID()) || !field.getOutputID().equalsIgnoreCase(metadata.getOutputID())) continue;
            index = this.fieldsInOrder.indexOf(field);
        }
        if (index >= 0) {
            this.fieldsInOrder.remove(index);
        }
    }

    public void removeField(MetadataField metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("The metadata must not be null.");
        }
        this.fieldsInOrder.remove(metadata);
        this.outputFields.remove(metadata.getOutputID());
    }

    public List<MetadataField> getFields() {
        return this.fieldsInOrder;
    }

    public void updateStringField(MetadataField current, String value) {
        if (current.getValue() != null && !(current.getValue() instanceof String)) {
            throw new IllegalArgumentException("Unable to update a field to a different type than String with this method!");
        }
        this.removeField(current);
        MetadataField field = new MetadataField(current);
        field.setValue(value);
        this.addField(field);
    }

    public boolean isUpdated() {
        for (MetadataField field : this.fieldsInOrder) {
            if (!field.isUpdated()) continue;
            return true;
        }
        return false;
    }
}

