/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.Equality;
import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Fn2;
import com.entwinemedia.fn.Prelude;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.ImmutableListWrapper;
import com.entwinemedia.fn.data.Opt;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.XMLCatalogImpl;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.util.Checksum;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DublinCoreUtil {
    private static final Logger logger = LoggerFactory.getLogger(DublinCoreUtil.class);
    private static final Fn<Object, String> toString = new Fn<Object, String>(){

        public String apply(Object o) {
            return o.toString();
        }
    };

    private DublinCoreUtil() {
    }

    public static Opt<DublinCoreCatalog> loadEpisodeDublinCore(Workspace ws, MediaPackage mp) {
        return DublinCoreUtil.loadDublinCore(ws, mp, (Fn<MediaPackageElement, Boolean>)MediaPackageSupport.Filters.isEpisodeDublinCore.toFn());
    }

    public static Opt<DublinCoreCatalog> loadDublinCore(final Workspace ws, MediaPackage mp, Fn<MediaPackageElement, Boolean> p) {
        return Stream.$((Object[])mp.getElements()).filter(p).head().map((Fn)new Fn<MediaPackageElement, DublinCoreCatalog>(){

            public DublinCoreCatalog apply(MediaPackageElement mpe) {
                return DublinCoreUtil.loadDublinCore(ws, mpe);
            }
        });
    }

    public static DublinCoreCatalog loadDublinCore(Workspace workspace, MediaPackageElement mpe) {
        DublinCoreCatalog dublinCoreCatalog;
        block8: {
            URI uri = mpe.getURI();
            logger.debug("Loading DC catalog from {}", (Object)uri);
            InputStream in = workspace.read(uri);
            try {
                dublinCoreCatalog = DublinCores.read(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Unable to load metadata from catalog '{}'", (Object)mpe, (Object)e);
                    return (DublinCoreCatalog)Prelude.chuck((Throwable)e);
                }
            }
            in.close();
        }
        return dublinCoreCatalog;
    }

    public static boolean equals(DublinCoreCatalog a, DublinCoreCatalog b) {
        Map<EName, List<DublinCoreValue>> av = a.getValues();
        Map<EName, List<DublinCoreValue>> bv = b.getValues();
        if (av.size() == bv.size()) {
            for (Map.Entry<EName, List<DublinCoreValue>> ave : av.entrySet()) {
                if (Equality.eq(ave.getValue(), bv.get(ave.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<XMLCatalogImpl.CatalogEntry> getPropertiesSorted(DublinCoreCatalog dc) {
        ArrayList<EName> properties = new ArrayList<EName>(dc.getProperties());
        Collections.sort(properties);
        ArrayList entries = new ArrayList();
        for (EName property : properties) {
            Collections.addAll(entries, dc.getValues(property));
        }
        return new ImmutableListWrapper(entries);
    }

    public static Checksum calculateChecksum(DublinCoreCatalog dc) {
        final byte[] sep = new byte[]{0};
        MessageDigest md = (MessageDigest)Stream.$(DublinCoreUtil.getPropertiesSorted(dc)).bind((Fn)new Fn<XMLCatalogImpl.CatalogEntry, Stream<String>>(){

            public Stream<String> apply(XMLCatalogImpl.CatalogEntry entry) {
                Stream attributesSorted = Stream.$(entry.getAttributes().entrySet()).sort((Comparator)new Comparator<Map.Entry<EName, String>>(){

                    @Override
                    public int compare(Map.Entry<EName, String> o1, Map.Entry<EName, String> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                }).bind((Fn)new Fn<Map.Entry<EName, String>, Stream<String>>(){

                    public Stream<String> apply(Map.Entry<EName, String> attribute) {
                        return Stream.$((Object[])new String[]{attribute.getKey().toString(), attribute.getValue()});
                    }
                });
                return Stream.$((Object[])new String[]{entry.getEName().toString(), entry.getValue()}).append(attributesSorted);
            }
        }).append((Iterable)Opt.nul((Object)dc.getRootTag()).map(toString)).foldl((Object)DublinCoreUtil.mkMd5MessageDigest(), (Fn2)new Fn2<MessageDigest, String, MessageDigest>(){

            public MessageDigest apply(MessageDigest digest, String s) {
                digest.update(s.getBytes(StandardCharsets.UTF_8));
                digest.update(sep);
                return digest;
            }
        });
        try {
            return Checksum.create((String)"md5", (String)Checksum.convertToHex((byte[])md.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            return (Checksum)Prelude.chuck((Throwable)e);
        }
    }

    private static MessageDigest mkMd5MessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Unable to create md5 message digest");
            return (MessageDigest)Prelude.chuck((Throwable)e);
        }
    }
}

