/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.data.Opt;
import java.io.Serializable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.util.EqualsUtil;
import org.opencastproject.util.RequireUtil;

@ParametersAreNonnullByDefault
@Immutable
public final class DublinCoreValue
implements Serializable {
    private static final long serialVersionUID = 7660583858714438266L;
    private final String value;
    private final String language;
    private final Opt<EName> encodingScheme;

    public DublinCoreValue(String value, String language, Opt<EName> encodingScheme) {
        this.value = (String)RequireUtil.notNull((Object)value, (String)"value");
        this.language = (String)RequireUtil.notNull((Object)language, (String)"language");
        this.encodingScheme = (Opt)RequireUtil.notNull(encodingScheme, (String)"encodingScheme");
    }

    public static DublinCoreValue mk(String value, String language, Opt<EName> encodingScheme) {
        return new DublinCoreValue(value, language, encodingScheme);
    }

    public static DublinCoreValue mk(String value, String language, EName encodingScheme) {
        return new DublinCoreValue(value, language, (Opt<EName>)Opt.some((Object)encodingScheme));
    }

    public static DublinCoreValue mk(String value, String language) {
        return new DublinCoreValue(value, language, (Opt<EName>)Opt.none());
    }

    public static DublinCoreValue mk(String value) {
        return new DublinCoreValue(value, "__", (Opt<EName>)Opt.none());
    }

    public String getValue() {
        return this.value;
    }

    public String getLanguage() {
        return this.language;
    }

    public Opt<EName> getEncodingScheme() {
        return this.encodingScheme;
    }

    public boolean hasEncodingScheme() {
        return this.encodingScheme.isSome();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DublinCoreValue && this.eqFields((DublinCoreValue)that);
    }

    private boolean eqFields(DublinCoreValue that) {
        return EqualsUtil.eq((Object)this.value, (Object)that.value) && EqualsUtil.eq((Object)this.language, (Object)that.language) && EqualsUtil.eq(this.encodingScheme, that.encodingScheme);
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.value, this.language, this.encodingScheme});
    }

    public String toString() {
        return String.format("DublinCoreValue(%s,%s,%s)", this.value, this.language, this.encodingScheme);
    }
}

