/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.data.Opt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.XMLCatalogImpl;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.util.XmlNamespaceContext;
import org.opencastproject.util.XmlSafeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@ParametersAreNonnullByDefault
public final class DublinCoreXmlFormat
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(DublinCoreXmlFormat.class);
    private StringBuilder content = new StringBuilder();
    private Attributes attributes = null;
    private DublinCoreCatalog dc = DublinCores.mkSimple();

    private DublinCoreXmlFormat() {
    }

    private DublinCoreXmlFormat(boolean includeEmpty) {
        this.dc.includeEmpty(includeEmpty);
    }

    @Nonnull
    public static DublinCoreCatalog read(InputStream xml) throws IOException, SAXException, ParserConfigurationException {
        return new DublinCoreXmlFormat().readImpl(new InputSource(xml));
    }

    @Nonnull
    public static DublinCoreCatalog read(File xml) throws IOException, SAXException, ParserConfigurationException {
        try (FileInputStream in = new FileInputStream(xml);){
            DublinCoreCatalog dublinCoreCatalog = new DublinCoreXmlFormat().readImpl(new InputSource(in));
            return dublinCoreCatalog;
        }
    }

    @Nonnull
    public static DublinCoreCatalog read(String xml) throws IOException, SAXException, ParserConfigurationException {
        return new DublinCoreXmlFormat().readImpl(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
    }

    public static Opt<DublinCoreCatalog> readOpt(String xml) {
        try {
            return Opt.some((Object)DublinCoreXmlFormat.read(xml));
        }
        catch (Exception e) {
            return Opt.none();
        }
    }

    @Nonnull
    public static DublinCoreCatalog read(Node xml) throws TransformerException {
        return new DublinCoreXmlFormat().readImpl(xml);
    }

    @Nonnull
    public static DublinCoreCatalog read(File xml, boolean includeEmptiedElements) throws IOException, SAXException, ParserConfigurationException {
        try (FileInputStream in = new FileInputStream(xml);){
            DublinCoreCatalog dublinCoreCatalog = new DublinCoreXmlFormat(includeEmptiedElements).readImpl(new InputSource(in));
            return dublinCoreCatalog;
        }
    }

    public static DublinCoreCatalog merge(DublinCoreCatalog fromCatalog, DublinCoreCatalog intoCatalog) {
        if (fromCatalog == null) {
            return intoCatalog;
        }
        if (intoCatalog == null) {
            return fromCatalog;
        }
        DublinCoreCatalog mergedCatalog = (DublinCoreCatalog)intoCatalog.clone();
        List<XMLCatalogImpl.CatalogEntry> mergeEntries = fromCatalog.getEntriesSorted();
        for (XMLCatalogImpl.CatalogEntry mergeEntry : mergeEntries) {
            if (mergeEntry.getEName().equals((Object)intoCatalog.getRootTag())) continue;
            String lang = mergeEntry.getAttribute(XMLCatalogImpl.XML_LANG_ATTR);
            if (StringUtils.isNotEmpty((CharSequence)lang)) {
                mergedCatalog.set(mergeEntry.getEName(), StringUtils.trimToNull((String)mergeEntry.getValue()), lang);
                continue;
            }
            mergedCatalog.set(mergeEntry.getEName(), StringUtils.trimToNull((String)mergeEntry.getValue()));
        }
        return mergedCatalog;
    }

    public static Document writeDocument(DublinCoreCatalog dc) throws ParserConfigurationException, TransformerException, IOException {
        DocumentBuilderFactory docBuilderFactory = XmlSafeParser.newDocumentBuilderFactory();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().newDocument();
        if (dc.getRootTag() != null) {
            Element rootElement = doc.createElementNS(dc.getRootTag().getNamespaceURI(), dc.toQName(dc.getRootTag()));
            doc.appendChild(rootElement);
            for (XMLCatalogImpl.CatalogEntry element : dc.getEntriesSorted()) {
                rootElement.appendChild(element.toXml(doc));
            }
            return doc;
        }
        throw new RuntimeException("DublinCore catalog does not have a root tag.");
    }

    private DublinCoreCatalog readImpl(Node node) throws TransformerException {
        SAXResult outputTarget = new SAXResult(this);
        Transformer t = XmlSafeParser.newTransformerFactory().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new DOMSource(node), outputTarget);
        return this.dc;
    }

    private DublinCoreCatalog readImpl(InputSource in) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = XmlSafeParser.newSAXParserFactory();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.newSAXParser().parse(in, (DefaultHandler)this);
        return this.dc;
    }

    private String getAndResetContent() {
        String str = this.content.toString().trim();
        this.content = new StringBuilder();
        return str;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        this.content.append(ch, start, length);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.dc.addBindings(XmlNamespaceContext.mk((String)prefix, (String)uri));
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.dc.getRootTag() == null) {
            this.dc.setRootTag(new EName(uri, localName));
        }
        this.attributes = attributes;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.dc.getRootTag() != null) {
            this.dc.addElement(EName.mk((String)uri, (String)localName), this.getAndResetContent(), this.attributes);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        logger.warn("Error parsing DublinCore catalog: " + e.getMessage());
        super.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        logger.warn("Fatal error parsing DublinCore catalog: " + e.getMessage());
        super.fatalError(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        logger.warn("Warning parsing DublinCore catalog: " + e.getMessage());
        super.warning(e);
    }
}

