/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreJsonFormat;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.metadata.dublincore.OpencastDctermsDublinCore;
import org.opencastproject.util.XmlNamespaceBinding;
import org.opencastproject.util.XmlNamespaceContext;

@ParametersAreNonnullByDefault
public final class DublinCores {
    public static final String OC_DC_CATALOG_NS_URI = "http://www.opencastproject.org/xsd/1.0/dublincore/";
    public static final EName OC_DC_CATALOG_ROOT_ELEMENT = new EName("http://www.opencastproject.org/xsd/1.0/dublincore/", "dublincore");
    public static final String OC_PROPERTY_NS_URI = "http://www.opencastproject.org/matterhorn/";
    public static final String OC_PROPERTY_NS_PREFIX = "oc";
    public static final EName OC_PROPERTY_AGENT_TIMEZONE = new EName("http://www.opencastproject.org/matterhorn/", "agentTimezone");
    public static final EName OC_PROPERTY_RECURRENCE = new EName("http://www.opencastproject.org/matterhorn/", "recurrence");
    public static final EName OC_PROPERTY_ANNOTATION = new EName("http://www.opencastproject.org/matterhorn/", "annotation");
    public static final EName OC_PROPERTY_ADVERTISED = new EName("http://www.opencastproject.org/matterhorn/", "advertised");
    public static final EName OC_PROPERTY_PROMOTED = new EName("http://www.opencastproject.org/matterhorn/", "promoted");
    public static final EName OC_PROPERTY_DURATION = new EName("http://www.opencastproject.org/matterhorn/", "duration");

    private DublinCores() {
    }

    @Nonnull
    @Deprecated
    public static OpencastDctermsDublinCore.Episode mkOpencast() {
        return DublinCores.mkOpencastEpisode();
    }

    @Nonnull
    public static OpencastDctermsDublinCore.Episode mkOpencastEpisode() {
        return new OpencastDctermsDublinCore.Episode(DublinCores.mkOpencast(MediaPackageElements.EPISODE));
    }

    @Nonnull
    public static OpencastDctermsDublinCore.Episode mkOpencastEpisode(DublinCoreCatalog dc) {
        return new OpencastDctermsDublinCore.Episode(dc);
    }

    @Nonnull
    public static OpencastDctermsDublinCore.Series mkOpencastSeries() {
        return new OpencastDctermsDublinCore.Series(DublinCores.mkOpencast(MediaPackageElements.SERIES));
    }

    @Nonnull
    public static DublinCoreCatalog mkStandard() {
        DublinCoreCatalog dc = new DublinCoreCatalog();
        dc.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)"dc", (String)"http://purl.org/dc/elements/1.1/"), XmlNamespaceBinding.mk((String)"dcterms", (String)"http://purl.org/dc/terms/")}));
        return dc;
    }

    @Nonnull
    public static DublinCoreCatalog mkSimple() {
        return new DublinCoreCatalog();
    }

    @Nonnull
    public static DublinCoreCatalog read(InputStream in) {
        String ser;
        try {
            ser = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read DublinCore from stream", e);
        }
        if (ser.startsWith("{")) {
            try {
                return DublinCoreJsonFormat.read(ser);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read DublinCore catalog, JSON parsing failed.", e);
            }
        }
        try {
            return DublinCoreXmlFormat.read(ser);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read DublinCore catalog, XML parsing failed.", e);
        }
    }

    private static DublinCoreCatalog mkOpencast(MediaPackageElementFlavor flavor) {
        DublinCoreCatalog dc = DublinCores.mkStandard();
        dc.setFlavor(flavor);
        dc.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)OC_PROPERTY_NS_PREFIX, (String)OC_PROPERTY_NS_URI), XmlNamespaceBinding.mk((String)"", (String)OC_DC_CATALOG_NS_URI)}));
        XmlNamespaceBinding.mk((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        dc.setRootTag(OC_DC_CATALOG_ROOT_ELEMENT);
        return dc;
    }
}

