/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.data.Opt;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.metadata.dublincore.Temporal;

public final class EncodingSchemeUtils {
    private static final Map<Precision, String> formats = new HashMap<Precision, String>();
    private static final Pattern DCMI_PERIOD;
    private static final Pattern DCMI_PERIOD_SCHEME;

    private EncodingSchemeUtils() {
    }

    public static DublinCoreValue encodeDate(Date date, Precision precision) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (precision == null) {
            throw new IllegalArgumentException("The precision must not be null");
        }
        return DublinCoreValue.mk(EncodingSchemeUtils.formatDate(date, precision), "__", (Opt<EName>)Opt.some((Object)DublinCore.ENC_SCHEME_W3CDTF));
    }

    public static String formatDate(Date date, Precision precision) {
        SimpleDateFormat f = new SimpleDateFormat(formats.get((Object)precision));
        if (precision == Precision.Minute || precision == Precision.Second || precision == Precision.Fraction) {
            f.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return f.format(date);
    }

    public static DublinCoreValue encodePeriod(DCMIPeriod period, Precision precision) {
        if (period == null) {
            throw new IllegalArgumentException("The period must not be null");
        }
        if (precision == null) {
            throw new IllegalArgumentException("The precision must not be null");
        }
        StringBuilder b = new StringBuilder();
        if (period.hasStart()) {
            b.append("start=").append(EncodingSchemeUtils.formatDate(period.getStart(), precision)).append(";");
        }
        if (period.hasEnd()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append("end=").append(EncodingSchemeUtils.formatDate(period.getEnd(), precision)).append(";");
        }
        if (period.hasName()) {
            b.append(" ").append("name=").append(period.getName().replace(";", "")).append(";");
        }
        b.append(" ").append("scheme=W3C-DTF;");
        return DublinCoreValue.mk(b.toString(), "__", (Opt<EName>)Opt.some((Object)DublinCore.ENC_SCHEME_PERIOD));
    }

    public static DublinCoreValue encodeDuration(long duration) {
        return DublinCoreValue.mk(ISOPeriodFormat.standard().print((ReadablePeriod)new Duration(duration).toPeriod()), "__", (Opt<EName>)Opt.some((Object)DublinCore.ENC_SCHEME_ISO8601));
    }

    public static Long decodeDuration(String value) {
        try {
            return ISOPeriodFormat.standard().parsePeriod(value).toStandardDuration().getMillis();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String[] parts = value.split(":");
            try {
                if (parts.length == 1) {
                    return Long.parseLong(parts[0]) * 1000L;
                }
                if (parts.length == 2) {
                    return Long.parseLong(parts[0]) * 1000L * 60L + Long.parseLong(parts[1]) * 1000L;
                }
                if (parts.length == 3) {
                    return Long.parseLong(parts[0]) * 1000L * 60L * 60L + Long.parseLong(parts[1]) * 1000L * 60L + Long.parseLong(parts[2]) * 1000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
    }

    public static Long decodeDuration(DublinCoreValue value) {
        if (!value.hasEncodingScheme() || ((EName)value.getEncodingScheme().get()).equals((Object)DublinCore.ENC_SCHEME_ISO8601)) {
            return EncodingSchemeUtils.decodeDuration(value.getValue());
        }
        return null;
    }

    public static Long decodeMandatoryDuration(String value) {
        Long l = EncodingSchemeUtils.decodeDuration(value);
        if (l == null) {
            throw new IllegalArgumentException("Cannot decode duration: " + value);
        }
        return l;
    }

    public static Date decodeDate(DublinCoreValue value) {
        if (!value.hasEncodingScheme() || ((EName)value.getEncodingScheme().get()).equals((Object)DublinCore.ENC_SCHEME_W3CDTF)) {
            try {
                return EncodingSchemeUtils.parseW3CDTF(value.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            long timestamp = Long.parseLong(value.getValue());
            Date decoded = new Date(timestamp);
            return decoded;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Date decodeDate(String value) {
        try {
            return EncodingSchemeUtils.parseW3CDTF(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                long timestamp = Long.parseLong(value);
                Date decoded = new Date(timestamp);
                return decoded;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    public static Date decodeMandatoryDate(DublinCoreValue value) {
        Date date = EncodingSchemeUtils.decodeDate(value);
        if (date == null) {
            throw new IllegalArgumentException("Cannot decode to Date: " + value);
        }
        return date;
    }

    public static Date decodeMandatoryDate(String value) {
        Date date = EncodingSchemeUtils.decodeDate(value);
        if (date == null) {
            throw new IllegalArgumentException("Cannot decode to Date: " + value);
        }
        return date;
    }

    public static DCMIPeriod decodePeriod(DublinCoreValue value) {
        return EncodingSchemeUtils.decodePeriod(value.getValue());
    }

    public static DCMIPeriod decodePeriod(String value) {
        String schemeString;
        Matcher schemeMatcher = DCMI_PERIOD_SCHEME.matcher(value);
        boolean mayBeW3CDTFEncoded = true;
        if (schemeMatcher.find() && !"W3C-DTF".equalsIgnoreCase(schemeString = schemeMatcher.group(1)) && !"W3CDTF".equalsIgnoreCase(schemeString)) {
            mayBeW3CDTFEncoded = false;
        }
        try {
            if (mayBeW3CDTFEncoded) {
                Date start = null;
                Date end = null;
                String name = null;
                Matcher m = DCMI_PERIOD.matcher(value);
                while (m.find()) {
                    String field = m.group(1);
                    String fieldValue = m.group(2);
                    if ("start".equals(field)) {
                        if (start != null) {
                            return null;
                        }
                        start = EncodingSchemeUtils.parseW3CDTF(fieldValue);
                        continue;
                    }
                    if ("end".equals(field)) {
                        if (end != null) {
                            return null;
                        }
                        end = EncodingSchemeUtils.parseW3CDTF(fieldValue);
                        continue;
                    }
                    if (!"name".equals(field)) continue;
                    if (name != null) {
                        return null;
                    }
                    name = fieldValue;
                }
                if (start == null && end == null) {
                    return null;
                }
                return new DCMIPeriod(start, end, name);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static DCMIPeriod decodeMandatoryPeriod(DublinCoreValue value) {
        return EncodingSchemeUtils.decodeMandatoryPeriod(value.getValue());
    }

    public static DCMIPeriod decodeMandatoryPeriod(String value) {
        DCMIPeriod period = EncodingSchemeUtils.decodePeriod(value);
        if (period == null) {
            throw new IllegalArgumentException("Cannot decode to DCMIPeriod: " + value);
        }
        return period;
    }

    public static Temporal decodeTemporal(DublinCoreValue value) {
        Date instant = EncodingSchemeUtils.decodeDate(value);
        if (instant != null) {
            return Temporal.instant(instant);
        }
        DCMIPeriod period = EncodingSchemeUtils.decodePeriod(value);
        if (period != null) {
            return Temporal.period(period);
        }
        Long duration = EncodingSchemeUtils.decodeDuration(value);
        if (duration != null) {
            return Temporal.duration(duration);
        }
        return null;
    }

    public static Temporal decodeMandatoryTemporal(DublinCoreValue value) {
        Temporal temporal = EncodingSchemeUtils.decodeTemporal(value);
        if (value == null) {
            throw new IllegalArgumentException("Cannot decode to either Date or DCMIPeriod: " + value);
        }
        return temporal;
    }

    private static Date parseW3CDTF(String value) {
        return ISODateTimeFormat.dateTimeParser().parseDateTime(value).toDate();
    }

    static {
        formats.put(Precision.Year, "yyyy");
        formats.put(Precision.Month, "yyyy-MM");
        formats.put(Precision.Day, "yyyy-MM-dd");
        formats.put(Precision.Minute, "yyyy-MM-dd'T'HH:mm'Z'");
        formats.put(Precision.Second, "yyyy-MM-dd'T'HH:mm:ss'Z'");
        formats.put(Precision.Fraction, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        DCMI_PERIOD = Pattern.compile("(start|end|name)\\s*=\\s*(.*?)(?:;|\\s*$)");
        DCMI_PERIOD_SCHEME = Pattern.compile("scheme\\s*=\\s*(.*?)(?:;|\\s*$)");
    }
}

