/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataField {
    private static final Logger logger = LoggerFactory.getLogger(MetadataField.class);
    public static final String CONFIG_COLLECTION_ID_KEY = "collectionID";
    private static final String CONFIG_PATTERN_KEY = "pattern";
    private static final String CONFIG_DELIMITER_KEY = "delimiter";
    public static final String CONFIG_INPUT_ID_KEY = "inputID";
    public static final String CONFIG_LABEL_KEY = "label";
    public static final String CONFIG_LIST_PROVIDER_KEY = "listprovider";
    private static final String CONFIG_NAMESPACE_KEY = "namespace";
    private static final String CONFIG_ORDER_KEY = "order";
    private static final String CONFIG_OUTPUT_ID_KEY = "outputID";
    public static final String CONFIG_PROPERTY_PREFIX = "property";
    public static final String CONFIG_READ_ONLY_KEY = "readOnly";
    public static final String CONFIG_REQUIRED_KEY = "required";
    public static final String CONFIG_TYPE_KEY = "type";
    private String collectionID;
    private String pattern;
    private String delimiter;
    private final String inputID;
    private final String label;
    private final String listprovider;
    private final String namespace;
    private final Integer order;
    private final String outputID;
    private boolean readOnly;
    private final boolean required;
    private Type type;
    private Object value;
    private Boolean translatable;
    private boolean updated = false;
    private Map<String, String> collection;
    private Boolean hasDifferentValues = null;

    public MetadataField(MetadataField other) {
        this.inputID = other.inputID;
        this.outputID = other.outputID;
        this.label = other.label;
        this.readOnly = other.readOnly;
        this.required = other.required;
        this.value = other.value;
        this.translatable = other.translatable;
        this.hasDifferentValues = other.hasDifferentValues;
        this.type = other.type;
        this.collection = other.collection;
        this.collectionID = other.collectionID;
        this.order = other.order;
        this.namespace = other.namespace;
        this.updated = other.updated;
        this.pattern = other.pattern;
        this.delimiter = other.delimiter;
        this.listprovider = other.listprovider;
    }

    public MetadataField(String inputID, String outputID, String label, boolean readOnly, boolean required, Object value, Boolean translatable, Type type, Map<String, String> collection, String collectionID, Integer order, String namespace, String listprovider, String pattern, String delimiter) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)inputID)) {
            throw new IllegalArgumentException("The metadata input id must not be null.");
        }
        if (StringUtils.isBlank((CharSequence)label)) {
            throw new IllegalArgumentException("The metadata label must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The metadata type must not be null.");
        }
        this.inputID = inputID;
        this.outputID = outputID;
        this.label = label;
        this.readOnly = readOnly;
        this.required = required;
        this.value = value;
        this.translatable = translatable;
        this.type = type;
        this.collection = collection;
        this.collectionID = collectionID;
        this.order = order;
        this.namespace = namespace;
        this.listprovider = listprovider;
        this.pattern = pattern;
        this.delimiter = delimiter;
    }

    public void setCollection(Map<String, String> collection) {
        this.collection = collection;
    }

    public Map<String, String> getCollection() {
        return this.collection;
    }

    public Object getValue() {
        return this.value;
    }

    public Boolean isTranslatable() {
        return this.translatable;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object value, boolean setUpdated) {
        this.value = value;
        if (setUpdated) {
            this.updated = true;
        }
    }

    public void setIsTranslatable(Boolean translatable) {
        this.translatable = translatable;
    }

    public static SimpleDateFormat getSimpleDateFormatter(String pattern) {
        SimpleDateFormat dateFormat = StringUtils.isNotBlank((CharSequence)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static MetadataField createMetadataField(Map<String, String> configuration) {
        String inputID = configuration.get(CONFIG_INPUT_ID_KEY);
        String label = configuration.get(CONFIG_LABEL_KEY);
        String collectionID = configuration.get(CONFIG_COLLECTION_ID_KEY);
        String delimiter = configuration.get(CONFIG_DELIMITER_KEY);
        String outputID = configuration.get(CONFIG_OUTPUT_ID_KEY);
        String listprovider = configuration.get(CONFIG_LIST_PROVIDER_KEY);
        String namespace = configuration.get(CONFIG_NAMESPACE_KEY);
        Type type = configuration.containsKey(CONFIG_TYPE_KEY) ? Type.valueOf(configuration.get(CONFIG_TYPE_KEY).toUpperCase()) : null;
        boolean required = configuration.containsKey(CONFIG_REQUIRED_KEY) && Boolean.parseBoolean(configuration.get(CONFIG_REQUIRED_KEY).toUpperCase());
        boolean readOnly = configuration.containsKey(CONFIG_READ_ONLY_KEY) && Boolean.parseBoolean(configuration.get(CONFIG_READ_ONLY_KEY).toUpperCase());
        String pattern = configuration.getOrDefault(CONFIG_PATTERN_KEY, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Integer order = null;
        if (configuration.containsKey(CONFIG_ORDER_KEY)) {
            try {
                order = Integer.parseInt(configuration.get(CONFIG_ORDER_KEY));
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to parse order value {} of metadata field {}", new Object[]{configuration.get(CONFIG_ORDER_KEY), inputID, e});
            }
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        switch (type) {
            case BOOLEAN: {
                return new MetadataField(inputID, outputID, label, readOnly, required, null, null, type, null, null, order, namespace, listprovider, null, null);
            }
            case DATE: {
                return new MetadataField(inputID, outputID, label, readOnly, required, null, null, type, null, null, order, namespace, listprovider, StringUtils.isNotBlank((CharSequence)pattern) ? pattern : null, null);
            }
            case DURATION: 
            case TEXT: 
            case ORDERED_TEXT: 
            case TEXT_LONG: {
                return new MetadataField(inputID, outputID, label, readOnly, required, "", null, type, null, collectionID, order, namespace, listprovider, null, null);
            }
            case ITERABLE_TEXT: 
            case MIXED_TEXT: {
                return new MetadataField(inputID, outputID, label, readOnly, required, new ArrayList(), null, type, null, collectionID, order, namespace, listprovider, null, delimiter);
            }
            case LONG: {
                return new MetadataField(inputID, outputID, label, readOnly, required, 0L, null, Type.LONG, null, collectionID, order, namespace, listprovider, null, null);
            }
            case START_DATE: 
            case START_TIME: {
                if (StringUtils.isBlank((CharSequence)pattern)) {
                    throw new IllegalArgumentException("For temporal metadata field " + inputID + " of type " + type + " there needs to be a pattern.");
                }
                return new MetadataField(inputID, outputID, label, readOnly, required, null, null, type, null, null, order, namespace, listprovider, pattern, null);
            }
        }
        throw new IllegalArgumentException("Unknown metadata type! " + type);
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getInputID() {
        return this.inputID;
    }

    public String getLabel() {
        return this.label;
    }

    public String getListprovider() {
        return this.listprovider;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getOutputID() {
        if (this.outputID != null) {
            return this.outputID;
        }
        return this.inputID;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setDifferentValues() {
        this.value = null;
        this.hasDifferentValues = true;
    }

    public Boolean hasDifferentValues() {
        return this.hasDifferentValues;
    }

    public MetadataField readOnlyCopy() {
        MetadataField metadataField = new MetadataField(this);
        metadataField.setReadOnly(true);
        return metadataField;
    }

    public static enum Type {
        BOOLEAN,
        DATE,
        DURATION,
        ITERABLE_TEXT,
        MIXED_TEXT,
        ORDERED_TEXT,
        LONG,
        START_DATE,
        START_TIME,
        TEXT,
        TEXT_LONG;

    }
}

