/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataJson {
    private static final Logger logger = LoggerFactory.getLogger(MetadataJson.class);
    private static final String JSON_KEY_ID = "id";
    private static final String JSON_KEY_LABEL = "label";
    private static final String JSON_KEY_READONLY = "readOnly";
    private static final String JSON_KEY_REQUIRED = "required";
    private static final String JSON_KEY_TYPE = "type";
    private static final String JSON_KEY_VALUE = "value";
    private static final String JSON_KEY_COLLECTION = "collection";
    private static final String JSON_KEY_TRANSLATABLE = "translatable";
    private static final String JSON_KEY_DELIMITER = "delimiter";
    private static final String JSON_KEY_DIFFERENT_VALUES = "differentValues";
    private static final String KEY_METADATA_TITLE = "title";
    private static final String KEY_METADATA_FLAVOR = "flavor";
    private static final String KEY_METADATA_FIELDS = "fields";
    private static final String KEY_METADATA_LOCKED = "locked";
    private static final String KEY_METADATA_ID = "id";
    private static final String KEY_METADATA_VALUE = "value";
    private static final String PATTERN_DURATION = "HH:mm:ss";

    private static JObject mapToJson(Map<String, String> map) {
        Objects.requireNonNull(map);
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Map.Entry<String, String> item : map.entrySet()) {
            fields.add(Jsons.f((String)item.getKey(), (JValue)Jsons.v((Object)item.getValue(), (JValue)Jsons.BLANK)));
        }
        return Jsons.obj(fields);
    }

    private MetadataJson() {
    }

    private static SimpleDateFormat getSimpleDateFormatter(String pattern) {
        SimpleDateFormat dateFormat = StringUtils.isNotBlank((CharSequence)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat();
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    private static <T> JValue valueToJson(T rawValue, MetadataField.Type type, String pattern) {
        switch (type) {
            case BOOLEAN: {
                if (rawValue == null) {
                    return Jsons.BLANK;
                }
                return Jsons.v(rawValue, (JValue)Jsons.BLANK);
            }
            case DATE: {
                if (rawValue == null) {
                    return Jsons.BLANK;
                }
                SimpleDateFormat dateFormat = MetadataJson.getSimpleDateFormatter(pattern);
                return Jsons.v((Object)dateFormat.format((Date)rawValue), (JValue)Jsons.BLANK);
            }
            case DURATION: {
                if (rawValue == null) {
                    return Jsons.BLANK;
                }
                long returnValue = 0L;
                String value = (String)rawValue;
                DCMIPeriod period = EncodingSchemeUtils.decodePeriod(value);
                if (period != null && period.hasStart() && period.hasEnd()) {
                    returnValue = period.getEnd().getTime() - period.getStart().getTime();
                } else {
                    try {
                        returnValue = Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        logger.debug("Unable to parse duration '{}' as either period or millisecond duration.", (Object)value);
                    }
                }
                return Jsons.v((String)DurationFormatUtils.formatDuration((long)returnValue, (String)PATTERN_DURATION));
            }
            case ITERABLE_TEXT: 
            case MIXED_TEXT: {
                if (rawValue == null) {
                    return Jsons.arr();
                }
                ArrayList<JValue> list = new ArrayList<JValue>();
                if (rawValue instanceof String) {
                    String stringVal = (String)rawValue;
                    for (String entry : stringVal.split(",")) {
                        if (!StringUtils.isNotBlank((CharSequence)entry)) continue;
                        list.add(Jsons.v((Object)entry, (JValue)Jsons.BLANK));
                    }
                } else {
                    for (Object v : (Iterable)rawValue) {
                        list.add(Jsons.v(v, (JValue)Jsons.BLANK));
                    }
                }
                return Jsons.arr(list);
            }
            case ORDERED_TEXT: 
            case TEXT_LONG: 
            case TEXT: {
                return Jsons.v((String)(rawValue == null ? "" : (String)rawValue));
            }
            case LONG: {
                if (rawValue == null) {
                    return Jsons.BLANK;
                }
                return Jsons.v((String)rawValue.toString());
            }
            case START_DATE: {
                if (rawValue == null) {
                    return Jsons.BLANK;
                }
                String value = (String)rawValue;
                if (StringUtils.isBlank((CharSequence)value)) {
                    return Jsons.BLANK;
                }
                DCMIPeriod p = EncodingSchemeUtils.decodePeriod(value);
                SimpleDateFormat dateFormat = MetadataJson.getSimpleDateFormatter(pattern);
                if (p != null) {
                    return Jsons.v((Object)dateFormat.format(p.getStart()), (JValue)Jsons.BLANK);
                }
                try {
                    dateFormat.parse(value);
                    return Jsons.v((Object)value, (JValue)Jsons.BLANK);
                }
                catch (Exception e) {
                    logger.error("Unable to parse temporal metadata '{}' as either DCIM data or a formatted date using pattern {} because:", new Object[]{value, pattern, e});
                    throw new IllegalArgumentException(e);
                }
            }
            case START_TIME: {
                if (rawValue == null) {
                    return Jsons.BLANK;
                }
                String value = (String)rawValue;
                if (StringUtils.isBlank((CharSequence)value)) {
                    return Jsons.BLANK;
                }
                DCMIPeriod p = EncodingSchemeUtils.decodePeriod(value);
                if (p != null) {
                    SimpleDateFormat dateFormat = MetadataJson.getSimpleDateFormatter(pattern);
                    return Jsons.v((Object)dateFormat.format(p.getStart()), (JValue)Jsons.BLANK);
                }
                try {
                    SimpleDateFormat dateFormat = MetadataJson.getSimpleDateFormatter(pattern);
                    dateFormat.parse(value);
                    return Jsons.v((Object)value, (JValue)Jsons.BLANK);
                }
                catch (Exception e) {
                    logger.error("Unable to parse temporal metadata '{}' as either DCIM data or a formatted date using pattern {} because:", new Object[]{value, pattern, e});
                    throw new IllegalArgumentException(e);
                }
            }
        }
        throw new IllegalArgumentException("invalid metadata field of type '" + type + "'");
    }

    private static JsonType jsonType(MetadataField f, boolean withOrderedText) {
        switch (f.getType()) {
            case BOOLEAN: {
                return JsonType.BOOLEAN;
            }
            case DATE: 
            case START_DATE: {
                return JsonType.DATE;
            }
            case DURATION: 
            case ITERABLE_TEXT: 
            case TEXT: {
                return JsonType.TEXT;
            }
            case MIXED_TEXT: {
                return JsonType.MIXED_TEXT;
            }
            case ORDERED_TEXT: {
                return withOrderedText ? JsonType.ORDERED_TEXT : JsonType.TEXT;
            }
            case LONG: {
                return JsonType.NUMBER;
            }
            case START_TIME: {
                return JsonType.TIME;
            }
            case TEXT_LONG: {
                return JsonType.TEXT_LONG;
            }
        }
        throw new IllegalArgumentException("invalid field type '" + f.getType() + "'");
    }

    private static Object valueFromJson(Object value, MetadataField field) {
        switch (field.getType()) {
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    return value;
                }
                String stringValue = value.toString();
                if (StringUtils.isBlank((CharSequence)stringValue)) {
                    return null;
                }
                return Boolean.parseBoolean(stringValue);
            }
            case DATE: {
                SimpleDateFormat dateFormat = MetadataJson.getSimpleDateFormatter(field.getPattern());
                try {
                    String date = (String)value;
                    if (StringUtils.isBlank((CharSequence)date)) {
                        return null;
                    }
                    return dateFormat.parse(date);
                }
                catch (java.text.ParseException e) {
                    logger.error("Not able to parse date {}: {}", value, (Object)e.getMessage());
                    return null;
                }
            }
            case DURATION: {
                if (!(value instanceof String)) {
                    logger.warn("The given value for duration can not be parsed.");
                    return "";
                }
                String duration = (String)value;
                String[] durationParts = duration.split(":");
                if (durationParts.length < 3) {
                    return null;
                }
                long hours = Long.parseLong(durationParts[0]);
                long minutes = Long.parseLong(durationParts[1]);
                long seconds = Long.parseLong(durationParts[2]);
                long returnValue = ((hours * 60L + minutes) * 60L + seconds) * 1000L;
                return Long.toString(returnValue);
            }
            case ITERABLE_TEXT: {
                JSONArray array = (JSONArray)value;
                if (array == null) {
                    return null;
                }
                String[] arrayOut = new String[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    arrayOut[i] = (String)array.get(i);
                }
                return Arrays.asList(arrayOut);
            }
            case MIXED_TEXT: {
                JSONArray array;
                JSONParser parser = new JSONParser();
                if (value instanceof String) {
                    try {
                        array = (JSONArray)parser.parse((String)value);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Unable to parse Mixed Iterable value into a JSONArray:", e);
                    }
                } else {
                    array = (JSONArray)value;
                }
                if (array == null) {
                    return new ArrayList();
                }
                String[] arrayOut = new String[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    arrayOut[i] = (String)array.get(i);
                }
                return Arrays.asList(arrayOut);
            }
            case ORDERED_TEXT: 
            case TEXT_LONG: 
            case TEXT: {
                if (value == null) {
                    return "";
                }
                if (!(value instanceof String)) {
                    logger.warn("Value cannot be parsed as String. Expecting type 'String', but received type '{}'.", (Object)value.getClass().getName());
                    return null;
                }
                return value;
            }
            case LONG: {
                if (!(value instanceof String)) {
                    logger.warn("The given value for Long can not be parsed.");
                    return 0L;
                }
                String longString = (String)value;
                return Long.parseLong(longString);
            }
            case START_DATE: 
            case START_TIME: {
                String date = (String)value;
                if (StringUtils.isBlank((CharSequence)date)) {
                    return "";
                }
                try {
                    SimpleDateFormat dateFormat = MetadataJson.getSimpleDateFormatter(field.getPattern());
                    dateFormat.parse(date);
                }
                catch (java.text.ParseException e) {
                    logger.error("Not able to parse date string {}: {}", value, (Object)ExceptionUtils.getMessage((Throwable)e));
                    return null;
                }
                return date;
            }
        }
        throw new IllegalArgumentException("invalid field type '" + field.getType() + "'");
    }

    public static JObject fieldToJson(MetadataField f, boolean withOrderedText) {
        Objects.requireNonNull(f);
        HashMap<String, Field> values = new HashMap<String, Field>();
        values.put("id", Jsons.f((String)"id", (JValue)Jsons.v((Object)f.getOutputID(), (JValue)Jsons.BLANK)));
        values.put(JSON_KEY_LABEL, Jsons.f((String)JSON_KEY_LABEL, (JValue)Jsons.v((Object)f.getLabel(), (JValue)Jsons.BLANK)));
        values.put("value", Jsons.f((String)"value", (JValue)MetadataJson.valueToJson(f.getValue(), f.getType(), f.getPattern())));
        values.put(JSON_KEY_TYPE, Jsons.f((String)JSON_KEY_TYPE, (JValue)Jsons.v((Object)MetadataJson.jsonType(f, withOrderedText).toString().toLowerCase(), (JValue)Jsons.BLANK)));
        values.put(JSON_KEY_READONLY, Jsons.f((String)JSON_KEY_READONLY, (JValue)Jsons.v((Boolean)f.isReadOnly())));
        values.put(JSON_KEY_REQUIRED, Jsons.f((String)JSON_KEY_REQUIRED, (JValue)Jsons.v((Boolean)f.isRequired())));
        if (f.getCollection() != null) {
            values.put(JSON_KEY_COLLECTION, Jsons.f((String)JSON_KEY_COLLECTION, (JValue)MetadataJson.mapToJson(f.getCollection())));
        } else if (f.getCollectionID() != null) {
            values.put(JSON_KEY_COLLECTION, Jsons.f((String)JSON_KEY_COLLECTION, (JValue)Jsons.v((String)f.getCollectionID())));
        }
        if (f.isTranslatable() != null) {
            values.put(JSON_KEY_TRANSLATABLE, Jsons.f((String)JSON_KEY_TRANSLATABLE, (JValue)Jsons.v((Boolean)f.isTranslatable())));
        }
        if (f.getDelimiter() != null) {
            values.put(JSON_KEY_DELIMITER, Jsons.f((String)JSON_KEY_DELIMITER, (JValue)Jsons.v((String)f.getDelimiter())));
        }
        if (f.hasDifferentValues() != null) {
            values.put(JSON_KEY_DIFFERENT_VALUES, Jsons.f((String)JSON_KEY_DIFFERENT_VALUES, (JValue)Jsons.v((Boolean)f.hasDifferentValues())));
        }
        return Jsons.obj(values);
    }

    public static MetadataField copyWithDifferentJsonValue(MetadataField t, String v) {
        MetadataField copy = new MetadataField(t);
        copy.setValue(MetadataJson.valueFromJson(v, copy));
        return copy;
    }

    public static JValue collectionToJson(DublinCoreMetadataCollection collection, boolean withOrderedText) {
        return Jsons.arr((Iterable)collection.getFields().stream().map(field -> MetadataJson.fieldToJson(field, withOrderedText)).collect(Collectors.toList()));
    }

    public static JSONArray extractSingleCollectionfromListJson(JSONArray json) {
        if (json == null || json.size() != 1) {
            throw new IllegalArgumentException("Input has to be a JSONArray with one entry");
        }
        return (JSONArray)((JSONObject)json.get(0)).get((Object)KEY_METADATA_FIELDS);
    }

    public static void fillCollectionFromJson(DublinCoreMetadataCollection collection, Object json) {
        if (!(json instanceof JSONArray)) {
            throw new IllegalArgumentException("couldn't fill metadata collection, didn't get an array");
        }
        JSONArray metadataJson = (JSONArray)json;
        for (JSONObject item : metadataJson) {
            MetadataField target;
            Object value;
            String fieldId = (String)item.get((Object)"id");
            if (fieldId == null || (value = item.get((Object)"value")) == null || (target = collection.getOutputFields().get(fieldId)) == null) continue;
            Object o = MetadataJson.valueFromJson(value, target);
            target.setValue(o);
        }
    }

    public static void fillListFromJson(MetadataList metadataList, JSONArray json) {
        for (JSONObject item : json) {
            DublinCoreMetadataCollection collection;
            JSONArray value;
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)((String)item.get((Object)KEY_METADATA_FLAVOR)));
            String title = (String)item.get((Object)KEY_METADATA_TITLE);
            if (title == null || (value = (JSONArray)item.get((Object)KEY_METADATA_FIELDS)) == null || (collection = metadataList.getMetadataByFlavor(flavor.toString())) == null) continue;
            MetadataJson.fillCollectionFromJson(collection, value);
        }
    }

    public static JValue listToJson(MetadataList metadataList, boolean withOrderedText) {
        ArrayList<JObject> catalogs = new ArrayList<JObject>();
        for (Map.Entry<String, MetadataList.TitledMetadataCollection> metadata : metadataList.getMetadataList().entrySet()) {
            ArrayList<Field> fields = new ArrayList<Field>();
            DublinCoreMetadataCollection metadataCollection = metadata.getValue().getCollection();
            if (!MetadataList.Locked.NONE.equals((Object)metadataList.getLocked())) {
                fields.add(Jsons.f((String)KEY_METADATA_LOCKED, (JValue)Jsons.v((String)metadataList.getLocked().getValue())));
                metadataCollection = metadataCollection.readOnlyCopy();
            }
            fields.add(Jsons.f((String)KEY_METADATA_FLAVOR, (JValue)Jsons.v((String)metadata.getKey())));
            fields.add(Jsons.f((String)KEY_METADATA_TITLE, (JValue)Jsons.v((String)metadata.getValue().getTitle())));
            fields.add(Jsons.f((String)KEY_METADATA_FIELDS, (JValue)MetadataJson.collectionToJson(metadataCollection, withOrderedText)));
            catalogs.add(Jsons.obj(fields));
        }
        return Jsons.arr(catalogs);
    }

    public static enum JsonType {
        BOOLEAN,
        DATE,
        NUMBER,
        TEXT,
        MIXED_TEXT,
        ORDERED_TEXT,
        TEXT_LONG,
        TIME;

    }
}

