/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.util.HashMap;
import java.util.Map;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;

public final class MetadataList {
    private final Map<String, TitledMetadataCollection> metadataList = new HashMap<String, TitledMetadataCollection>();
    private Locked locked = Locked.NONE;

    public Locked getLocked() {
        return this.locked;
    }

    public Map<String, TitledMetadataCollection> getMetadataList() {
        return this.metadataList;
    }

    public DublinCoreMetadataCollection getMetadataByAdapter(SeriesCatalogUIAdapter catalogUIAdapter) {
        return this.getMetadataByFlavor(catalogUIAdapter.getFlavor().toString());
    }

    public DublinCoreMetadataCollection getMetadataByAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        return this.getMetadataByFlavor(catalogUIAdapter.getFlavor().toString());
    }

    public DublinCoreMetadataCollection getMetadataByFlavor(String flavor) {
        return this.metadataList.keySet().stream().filter(e -> e.equals(flavor)).map(this.metadataList::get).map(TitledMetadataCollection::getCollection).findAny().orElse(null);
    }

    public void add(EventCatalogUIAdapter adapter, DublinCoreMetadataCollection metadata) {
        this.metadataList.put(adapter.getFlavor().toString(), new TitledMetadataCollection(adapter.getUITitle(), metadata));
    }

    public void add(SeriesCatalogUIAdapter adapter, DublinCoreMetadataCollection metadata) {
        this.metadataList.put(adapter.getFlavor().toString(), new TitledMetadataCollection(adapter.getUITitle(), metadata));
    }

    public void add(String flavor, String title, DublinCoreMetadataCollection metadata) {
        this.metadataList.put(flavor, new TitledMetadataCollection(title, metadata));
    }

    public void setLocked(Locked locked) {
        this.locked = locked;
    }

    public static final class TitledMetadataCollection {
        private final String title;
        private final DublinCoreMetadataCollection collection;

        public TitledMetadataCollection(String title, DublinCoreMetadataCollection collection) {
            this.title = title;
            this.collection = collection;
        }

        public String getTitle() {
            return this.title;
        }

        public DublinCoreMetadataCollection getCollection() {
            return this.collection;
        }
    }

    public static enum Locked {
        NONE("NONE"),
        WORKFLOW_RUNNING("EVENTS.EVENTS.DETAILS.METADATA.LOCKED.RUNNING");

        private final String languageConstant;

        private Locked(String languageConstant) {
            this.languageConstant = languageConstant;
        }

        public String getValue() {
            return this.languageConstant;
        }
    }
}

