/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.Unit;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Strings;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.OpencastMetadataCodec;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.metadata.dublincore.Temporal;

@ParametersAreNonnullByDefault
public abstract class OpencastDctermsDublinCore {
    protected final DublinCoreCatalog dc;
    private final Fn<String, DublinCoreValue> mkValue = new Fn<String, DublinCoreValue>(){

        public DublinCoreValue apply(String v) {
            return DublinCoreValue.mk(v);
        }
    };

    private OpencastDctermsDublinCore(DublinCoreCatalog dc) {
        this.dc = dc;
    }

    public DublinCoreCatalog getCatalog() {
        return this.dc;
    }

    @Nonnull
    public List<String> getPublishers() {
        return this.get(DublinCore.PROPERTY_PUBLISHER);
    }

    public void setPublishers(List<String> publishers) {
        this.set(DublinCore.PROPERTY_PUBLISHER, publishers);
    }

    public void addPublisher(String publisher) {
        this.add(DublinCore.PROPERTY_PUBLISHER, publisher);
    }

    public void removePublishers() {
        this.dc.remove(DublinCore.PROPERTY_PUBLISHER);
    }

    @Nonnull
    public List<String> getRightsHolders() {
        return this.get(DublinCore.PROPERTY_RIGHTS_HOLDER);
    }

    public void setRightsHolders(List<String> rightsHolders) {
        this.set(DublinCore.PROPERTY_RIGHTS_HOLDER, rightsHolders);
    }

    public void addRightsHolder(String rightsHolder) {
        this.add(DublinCore.PROPERTY_RIGHTS_HOLDER, rightsHolder);
    }

    public void removeRightsHolders() {
        this.dc.remove(DublinCore.PROPERTY_RIGHTS_HOLDER);
    }

    @Nonnull
    public Opt<String> getLicense() {
        return this.getFirst(DublinCore.PROPERTY_LICENSE);
    }

    public void setLicense(String license) {
        this.set(DublinCore.PROPERTY_LICENSE, license);
    }

    public void removeLicense() {
        this.dc.remove(DublinCore.PROPERTY_LICENSE);
    }

    @Nonnull
    public Opt<String> getDcIdentifier() {
        return this.getFirst(DublinCore.PROPERTY_IDENTIFIER);
    }

    public void setDcIdentifier(String id) {
        this.set(DublinCore.PROPERTY_IDENTIFIER, id);
    }

    public void updateDcIdentifier(Opt<String> id) {
        this.update(DublinCore.PROPERTY_IDENTIFIER, id);
    }

    public void removeDcIdentifier() {
        this.dc.remove(DublinCore.PROPERTY_IDENTIFIER);
    }

    @Nonnull
    public Opt<String> getTitle() {
        return this.getFirst(DublinCore.PROPERTY_TITLE);
    }

    public void setTitle(String title) {
        this.set(DublinCore.PROPERTY_TITLE, title);
    }

    public void updateTitle(Opt<String> title) {
        this.update(DublinCore.PROPERTY_TITLE, title);
    }

    public void removeTitle() {
        this.dc.remove(DublinCore.PROPERTY_TITLE);
    }

    @Nonnull
    public Opt<String> getDescription() {
        return this.getFirst(DublinCore.PROPERTY_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DublinCore.PROPERTY_DESCRIPTION, description);
    }

    public void updateDescription(Opt<String> description) {
        this.update(DublinCore.PROPERTY_DESCRIPTION, description);
    }

    public void removeDescription() {
        this.dc.remove(DublinCore.PROPERTY_DESCRIPTION);
    }

    @Nonnull
    public List<String> getAudiences() {
        return this.get(DublinCore.PROPERTY_AUDIENCE);
    }

    public void setAudiences(List<String> audiences) {
        this.set(DublinCore.PROPERTY_AUDIENCE, audiences);
    }

    public void setAudience(String audience) {
        this.set(DublinCore.PROPERTY_AUDIENCE, audience);
    }

    public void addAudience(String audience) {
        this.add(DublinCore.PROPERTY_AUDIENCE, audience);
    }

    public void updateAudience(Opt<String> audience) {
        this.update(DublinCore.PROPERTY_AUDIENCE, audience);
    }

    public void removeAudiences() {
        this.dc.remove(DublinCore.PROPERTY_AUDIENCE);
    }

    @Nonnull
    public Opt<Temporal> getCreated() {
        return this.getFirstVal(DublinCore.PROPERTY_CREATED).map(OpencastMetadataCodec.decodeTemporal);
    }

    public void setCreated(Date date) {
        if (this.getTemporal().isNone()) {
            this.setDate(DublinCore.PROPERTY_CREATED, date, Precision.Day);
        }
    }

    public void setCreated(Temporal t) {
        if (this.getTemporal().isNone()) {
            t.fold(new Temporal.Match<Unit>(){

                @Override
                public Unit period(DCMIPeriod period) {
                    OpencastDctermsDublinCore.this.setCreated(period.getStart());
                    return Unit.unit;
                }

                @Override
                public Unit instant(Date instant) {
                    OpencastDctermsDublinCore.this.setCreated(instant);
                    return Unit.unit;
                }

                @Override
                public Unit duration(long duration) {
                    return Unit.unit;
                }
            });
        }
    }

    public void removeCreated() {
        this.dc.remove(DublinCore.PROPERTY_CREATED);
    }

    @Nonnull
    public List<String> getCreators() {
        return this.get(DublinCore.PROPERTY_CREATOR);
    }

    public void setCreators(List<String> creators) {
        this.set(DublinCore.PROPERTY_CREATOR, creators);
    }

    public void setCreator(String creator) {
        this.set(DublinCore.PROPERTY_CREATOR, creator);
    }

    public void addCreator(String name) {
        this.add(DublinCore.PROPERTY_CREATOR, name);
    }

    public void updateCreator(Opt<String> name) {
        this.update(DublinCore.PROPERTY_CREATOR, name);
    }

    public void removeCreators() {
        this.dc.remove(DublinCore.PROPERTY_CREATOR);
    }

    @Nonnull
    public Opt<Long> getExtent() {
        return this.getFirst(DublinCore.PROPERTY_EXTENT).map(OpencastMetadataCodec.decodeDuration);
    }

    public void setExtent(Long extent) {
        this.dc.set(DublinCore.PROPERTY_EXTENT, OpencastMetadataCodec.encodeDuration(extent));
    }

    public void removeExtent() {
        this.dc.remove(DublinCore.PROPERTY_EXTENT);
    }

    @Nonnull
    public Opt<Date> getIssued() {
        return this.getFirst(DublinCore.PROPERTY_ISSUED).map(OpencastMetadataCodec.decodeDate);
    }

    public void setIssued(Date date) {
        this.setDate(DublinCore.PROPERTY_ISSUED, date, Precision.Day);
    }

    public void updateIssued(Opt<Date> date) {
        this.updateDate(DublinCore.PROPERTY_ISSUED, date, Precision.Day);
    }

    public void removeIssued() {
        this.dc.remove(DublinCore.PROPERTY_ISSUED);
    }

    @Nonnull
    public Opt<String> getLanguage() {
        return this.getFirst(DublinCore.PROPERTY_LANGUAGE);
    }

    public void setLanguage(String lang) {
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            String doLang = lang;
            if (lang.length() == 2) {
                try {
                    doLang = new Locale(lang).getISO3Language();
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.set(DublinCore.PROPERTY_LANGUAGE, doLang);
        }
    }

    public void removeLanguage() {
        this.dc.remove(DublinCore.PROPERTY_LANGUAGE);
    }

    @Nonnull
    public Opt<String> getSpatial() {
        return this.getFirst(DublinCore.PROPERTY_SPATIAL);
    }

    public void setSpatial(String spatial) {
        this.set(DublinCore.PROPERTY_SPATIAL, spatial);
    }

    public void updateSpatial(Opt<String> spatial) {
        this.update(DublinCore.PROPERTY_SPATIAL, spatial);
    }

    public void removeSpatial() {
        this.dc.remove(DublinCore.PROPERTY_SPATIAL);
    }

    @Nonnull
    public Opt<String> getSource() {
        return this.getFirst(DublinCore.PROPERTY_SOURCE);
    }

    public void setSource(String source) {
        this.set(DublinCore.PROPERTY_SOURCE, source);
    }

    public void removeSource() {
        this.dc.remove(DublinCore.PROPERTY_SOURCE);
    }

    @Nonnull
    public List<String> getContributors() {
        return this.get(DublinCore.PROPERTY_CONTRIBUTOR);
    }

    public void setContributors(List<String> contributors) {
        this.set(DublinCore.PROPERTY_CONTRIBUTOR, contributors);
    }

    public void setContributor(String contributor) {
        this.set(DublinCore.PROPERTY_CONTRIBUTOR, contributor);
    }

    public void addContributor(String contributor) {
        this.add(DublinCore.PROPERTY_CONTRIBUTOR, contributor);
    }

    public void updateContributor(Opt<String> contributor) {
        this.update(DublinCore.PROPERTY_CONTRIBUTOR, contributor);
    }

    public void removeContributors() {
        this.dc.remove(DublinCore.PROPERTY_CONTRIBUTOR);
    }

    @Nonnull
    public Opt<Temporal> getTemporal() {
        return this.getFirstVal(DublinCore.PROPERTY_TEMPORAL).map(OpencastMetadataCodec.decodeTemporal);
    }

    public void setTemporal(Date from, Date to) {
        this.setPeriod(DublinCore.PROPERTY_TEMPORAL, from, to, Precision.Second);
        this.setDate(DublinCore.PROPERTY_CREATED, from, Precision.Day);
    }

    public void removeTemporal() {
        this.dc.remove(DublinCore.PROPERTY_TEMPORAL);
    }

    @Nonnull
    public Opt<Stream<String>> getType() {
        return this.getFirst(DublinCore.PROPERTY_TYPE).map(Strings.split((String)"/"));
    }

    @Nonnull
    public Opt<String> getTypeCombined() {
        return this.getFirst(DublinCore.PROPERTY_TYPE);
    }

    public void setType(String type, String subtype) {
        this.set(DublinCore.PROPERTY_TYPE, type + "/" + subtype);
    }

    public void setType(String type) {
        this.set(DublinCore.PROPERTY_TYPE, type);
    }

    public void removeType() {
        this.dc.remove(DublinCore.PROPERTY_TYPE);
    }

    protected void setDate(EName property, Date date, Precision p) {
        this.dc.set(property, OpencastMetadataCodec.encodeDate(date, p));
    }

    protected void updateDate(EName property, Opt<Date> date, Precision p) {
        for (Date d : date) {
            this.setDate(property, d, p);
        }
    }

    protected void setPeriod(EName property, Date from, Date to, Precision p) {
        this.dc.set(property, OpencastMetadataCodec.encodePeriod(from, to, p));
    }

    protected List<String> get(EName property) {
        return this.dc.get(property, "**");
    }

    protected Opt<String> getFirst(EName property) {
        return Opt.nul((Object)this.dc.getFirst(property));
    }

    protected Opt<DublinCoreValue> getFirstVal(EName property) {
        return Opt.nul((Object)this.dc.getFirstVal(property));
    }

    protected void set(EName property, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.dc.set(property, value);
        }
    }

    protected void set(EName property, List<String> values) {
        List valuesFiltered = Stream.$(values).filter((Fn)Strings.isNotBlank).map(this.mkValue).toList();
        if (!valuesFiltered.isEmpty()) {
            this.dc.remove(property);
            this.dc.set(property, valuesFiltered);
        }
    }

    protected void add(EName property, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.dc.add(property, value);
        }
    }

    protected void update(EName property, Opt<String> value) {
        for (String v : value) {
            this.set(property, v);
        }
    }

    public static final class Series
    extends OpencastDctermsDublinCore {
        public Series(DublinCoreCatalog dc) {
            super(dc);
        }
    }

    public static final class Episode
    extends OpencastDctermsDublinCore {
        public Episode(DublinCoreCatalog dc) {
            super(dc);
        }

        @Nonnull
        public Opt<String> getIsPartOf() {
            return this.getFirst(DublinCore.PROPERTY_IS_PART_OF);
        }

        public void setIsPartOf(String seriesID) {
            this.set(DublinCore.PROPERTY_IS_PART_OF, seriesID);
        }

        public void updateIsPartOf(Opt<String> seriesID) {
            this.update(DublinCore.PROPERTY_IS_PART_OF, seriesID);
        }

        public void removeIsPartOf() {
            this.dc.remove(DublinCore.PROPERTY_IS_PART_OF);
        }
    }
}

