/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import com.entwinemedia.fn.Fn;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.metadata.dublincore.Temporal;

@ParametersAreNonnullByDefault
public final class OpencastMetadataCodec {
    public static final Fn<String, Date> decodeDate = new Fn<String, Date>(){

        public Date apply(String a) {
            return OpencastMetadataCodec.decodeDate(a);
        }
    };
    public static final Fn<String, Long> decodeDuration = new Fn<String, Long>(){

        public Long apply(String a) {
            return OpencastMetadataCodec.decodeDuration(a);
        }
    };
    @Nonnull
    public static final Fn<DublinCoreValue, Temporal> decodeTemporal = new Fn<DublinCoreValue, Temporal>(){

        public Temporal apply(DublinCoreValue a) {
            return OpencastMetadataCodec.decodeTemporal(a);
        }
    };

    private OpencastMetadataCodec() {
    }

    @Nonnull
    public static DublinCoreValue encodeDate(Date date, Precision p) {
        return EncodingSchemeUtils.encodeDate(date, p);
    }

    @Nonnull
    public static Date decodeDate(String date) {
        return EncodingSchemeUtils.decodeMandatoryDate(date);
    }

    @Nonnull
    public static DublinCoreValue encodeDuration(long ms) {
        return EncodingSchemeUtils.encodeDuration(ms);
    }

    public static long decodeDuration(String ms) {
        return EncodingSchemeUtils.decodeMandatoryDuration(ms);
    }

    @Nonnull
    public static DublinCoreValue encodePeriod(Date from, Date to, Precision precision) {
        return EncodingSchemeUtils.encodePeriod(new DCMIPeriod(from, to), precision);
    }

    @Nonnull
    public static Temporal decodeTemporal(DublinCoreValue temporal) {
        return EncodingSchemeUtils.decodeMandatoryTemporal(temporal);
    }
}

