/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageSerializer;
import org.opencastproject.metadata.api.MetadataValue;
import org.opencastproject.metadata.api.StaticMetadata;
import org.opencastproject.metadata.api.StaticMetadataService;
import org.opencastproject.metadata.api.util.Interval;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Temporal;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.NonEmptyList;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Predicate;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMetadataServiceDublinCoreImpl
implements StaticMetadataService {
    private static final Logger logger = LoggerFactory.getLogger(StaticMetadataServiceDublinCoreImpl.class);
    private Function<Catalog, Option<DublinCoreCatalog>> loader = new Function<Catalog, Option<DublinCoreCatalog>>(){

        public Option<DublinCoreCatalog> apply(Catalog catalog) {
            return StaticMetadataServiceDublinCoreImpl.this.load(catalog);
        }
    };
    protected int priority = 0;
    protected Workspace workspace = null;
    protected MediaPackageSerializer serializer = null;

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setMediaPackageSerializer(MediaPackageSerializer serializer) {
        this.serializer = serializer;
    }

    public void activate(Map properties) {
        String priorityString;
        logger.debug("activate()");
        if (properties != null && (priorityString = (String)properties.get("priority")) != null) {
            try {
                this.priority = Integer.parseInt(priorityString);
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to set priority to {}", (Object)priorityString);
                throw e;
            }
        }
    }

    public StaticMetadata getMetadata(MediaPackage mp) {
        return (StaticMetadata)Monadics.mlist((List)Collections.list((Object[])mp.getCatalogs(DublinCoreCatalog.ANY_DUBLINCORE))).find(StaticMetadataServiceDublinCoreImpl.flavorPredicate(MediaPackageElements.EPISODE)).flatMap(this.loader).map((Function)new Function<DublinCoreCatalog, StaticMetadata>(){

            public StaticMetadata apply(DublinCoreCatalog episode) {
                return StaticMetadataServiceDublinCoreImpl.newStaticMetadataFromEpisode(episode);
            }
        }).getOrElse((Object)null);
    }

    private static StaticMetadata newStaticMetadataFromEpisode(DublinCoreCatalog episode) {
        Option start;
        final Option id = Option.option((Object)episode.getFirst(DublinCore.PROPERTY_IDENTIFIER));
        Option created = Option.option((Object)episode.getFirst(DublinCore.PROPERTY_CREATED)).map((Function)new Function<String, Date>(){

            public Date apply(String a) {
                Date date = EncodingSchemeUtils.decodeDate(a);
                return date != null ? date : (Date)Misc.chuck((Throwable)new RuntimeException(a + " does not conform to W3C-DTF encoding scheme."));
            }
        });
        final Option temporalOpt = Option.option((Object)episode.getFirstVal(DublinCore.PROPERTY_TEMPORAL)).map(StaticMetadataServiceDublinCoreImpl.dc2temporalValueOption());
        if (episode.getFirst(DublinCore.PROPERTY_TEMPORAL) != null) {
            DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod(episode.getFirst(DublinCore.PROPERTY_TEMPORAL));
            start = Option.option((Object)period.getStart());
        } else {
            start = created;
        }
        final Option language = Option.option((Object)episode.getFirst(DublinCore.PROPERTY_LANGUAGE));
        final Option extent = Collections.head(episode.get(DublinCore.PROPERTY_EXTENT)).map((Function)new Function<DublinCoreValue, Long>(){

            public Long apply(DublinCoreValue a) {
                Long extent = EncodingSchemeUtils.decodeDuration(a);
                return extent != null ? extent : (Long)Misc.chuck((Throwable)new RuntimeException(a + " does not conform to ISO8601 encoding scheme for durations."));
            }
        });
        final Option type = Option.option((Object)episode.getFirst(DublinCore.PROPERTY_TYPE));
        final Option isPartOf = Option.option((Object)episode.getFirst(DublinCore.PROPERTY_IS_PART_OF));
        final Option replaces = Option.option((Object)episode.getFirst(DublinCore.PROPERTY_REPLACES));
        final Option available = Collections.head(episode.get(DublinCore.PROPERTY_AVAILABLE)).flatMap((Function)new Function<DublinCoreValue, Option<Interval>>(){

            public Option<Interval> apply(DublinCoreValue v) {
                DCMIPeriod p = EncodingSchemeUtils.decodePeriod(v);
                return p != null ? Option.some((Object)Interval.fromValues((Date)p.getStart(), (Date)p.getEnd())) : (Option)Misc.chuck((Throwable)new RuntimeException(v + " does not conform to W3C-DTF encoding scheme for periods"));
            }
        });
        final NonEmptyList titles = new NonEmptyList((Collection)Monadics.mlist(episode.get(DublinCore.PROPERTY_TITLE)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_TITLE.getLocalName())).value());
        final List subjects = Monadics.mlist(episode.get(DublinCore.PROPERTY_SUBJECT)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_SUBJECT.getLocalName())).value();
        final List creators = Monadics.mlist(episode.get(DublinCore.PROPERTY_CREATOR)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_CREATOR.getLocalName())).value();
        final List publishers = Monadics.mlist(episode.get(DublinCore.PROPERTY_PUBLISHER)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_PUBLISHER.getLocalName())).value();
        final List contributors = Monadics.mlist(episode.get(DublinCore.PROPERTY_CONTRIBUTOR)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_CONTRIBUTOR.getLocalName())).value();
        final List description = Monadics.mlist(episode.get(DublinCore.PROPERTY_DESCRIPTION)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_DESCRIPTION.getLocalName())).value();
        final List rightsHolders = Monadics.mlist(episode.get(DublinCore.PROPERTY_RIGHTS_HOLDER)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_RIGHTS_HOLDER.getLocalName())).value();
        final List spatials = Monadics.mlist(episode.get(DublinCore.PROPERTY_SPATIAL)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_SPATIAL.getLocalName())).value();
        final List accessRights = Monadics.mlist(episode.get(DublinCore.PROPERTY_ACCESS_RIGHTS)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_ACCESS_RIGHTS.getLocalName())).value();
        final List licenses = Monadics.mlist(episode.get(DublinCore.PROPERTY_LICENSE)).map(StaticMetadataServiceDublinCoreImpl.dc2mvString(DublinCore.PROPERTY_LICENSE.getLocalName())).value();
        return new StaticMetadata(){

            public Option<String> getId() {
                return id;
            }

            public Option<Date> getCreated() {
                return start;
            }

            public Option<Date[]> getTemporalPeriod() {
                if (temporalOpt.isSome() && temporalOpt.get() instanceof DCMIPeriod) {
                    DCMIPeriod p = (DCMIPeriod)temporalOpt.get();
                    return Option.option((Object)new Date[]{p.getStart(), p.getEnd()});
                }
                return Option.none();
            }

            public Option<Date> getTemporalInstant() {
                if (temporalOpt.isSome() && temporalOpt.get() instanceof Date) {
                    return temporalOpt;
                }
                return Option.none();
            }

            public Option<Long> getTemporalDuration() {
                if (temporalOpt.isSome() && temporalOpt.get() instanceof Long) {
                    return temporalOpt;
                }
                return Option.none();
            }

            public Option<Long> getExtent() {
                return extent;
            }

            public Option<String> getLanguage() {
                return language;
            }

            public Option<String> getIsPartOf() {
                return isPartOf;
            }

            public Option<String> getReplaces() {
                return replaces;
            }

            public Option<String> getType() {
                return type;
            }

            public Option<Interval> getAvailable() {
                return available;
            }

            public NonEmptyList<MetadataValue<String>> getTitles() {
                return titles;
            }

            public List<MetadataValue<String>> getSubjects() {
                return subjects;
            }

            public List<MetadataValue<String>> getCreators() {
                return creators;
            }

            public List<MetadataValue<String>> getPublishers() {
                return publishers;
            }

            public List<MetadataValue<String>> getContributors() {
                return contributors;
            }

            public List<MetadataValue<String>> getDescription() {
                return description;
            }

            public List<MetadataValue<String>> getRightsHolders() {
                return rightsHolders;
            }

            public List<MetadataValue<String>> getSpatials() {
                return spatials;
            }

            public List<MetadataValue<String>> getAccessRights() {
                return accessRights;
            }

            public List<MetadataValue<String>> getLicenses() {
                return licenses;
            }
        };
    }

    public int getPriority() {
        return this.priority;
    }

    private static Function<DublinCoreValue, Object> dc2temporalValueOption() {
        return new Function<DublinCoreValue, Object>(){

            public Object apply(DublinCoreValue dcv) {
                Temporal temporal = EncodingSchemeUtils.decodeTemporal(dcv);
                if (temporal != null) {
                    return temporal.fold(new Temporal.Match<Object>(){

                        @Override
                        public Object period(DCMIPeriod period) {
                            return period;
                        }

                        @Override
                        public Object instant(Date instant) {
                            return instant;
                        }

                        @Override
                        public Object duration(long duration) {
                            return duration;
                        }
                    });
                }
                return Misc.chuck((Throwable)new RuntimeException(dcv + " does not conform to ISO8601 encoding scheme for temporal."));
            }
        };
    }

    private static Function<DublinCoreValue, MetadataValue<String>> dc2mvString(final String name) {
        return new Function<DublinCoreValue, MetadataValue<String>>(){

            public MetadataValue<String> apply(DublinCoreValue dcv) {
                return new MetadataValue((Object)dcv.getValue(), name, dcv.getLanguage());
            }
        };
    }

    private static Predicate<Catalog> flavorPredicate(final MediaPackageElementFlavor flavor) {
        return new Predicate<Catalog>(){

            public Boolean apply(Catalog catalog) {
                return flavor.equals((Object)catalog.getFlavor());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<DublinCoreCatalog> load(Catalog catalog) {
        Option option;
        InputStream in = null;
        try {
            URI uri = catalog.getURI();
            if (this.serializer != null) {
                uri = this.serializer.decodeURI(uri);
            }
            in = this.workspace.read(uri);
            option = Option.some((Object)DublinCores.read(in));
        }
        catch (Exception e) {
            Option option2;
            try {
                logger.warn("Unable to load metadata from catalog '{}'", (Object)catalog);
                option2 = Option.none();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return option2;
        }
        IOUtils.closeQuietly((InputStream)in);
        return option;
    }
}

