/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.dublincore;

import java.util.Date;
import org.opencastproject.metadata.dublincore.DCMIPeriod;

public abstract class Temporal {
    private Temporal() {
    }

    public static Temporal instant(final Date instant) {
        if (instant == null) {
            throw new IllegalArgumentException("instant must not be null");
        }
        return new Temporal(){

            public Date getInstant() {
                return instant;
            }

            @Override
            public <A> A fold(Match<A> v) {
                return v.instant(instant);
            }
        };
    }

    public static Temporal period(final DCMIPeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("period must not be null");
        }
        return new Temporal(){

            public DCMIPeriod getPeriod() {
                return period;
            }

            @Override
            public <A> A fold(Match<A> v) {
                return v.period(period);
            }
        };
    }

    public static Temporal duration(final long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be positive or zero");
        }
        return new Temporal(){

            public long getDuration() {
                return duration;
            }

            @Override
            public <A> A fold(Match<A> v) {
                return v.duration(duration);
            }
        };
    }

    public abstract <A> A fold(Match<A> var1);

    public static interface Match<A> {
        public A period(DCMIPeriod var1);

        public A instant(Date var1);

        public A duration(long var1);
    }
}

